<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
    include '../../config/database.php';
    include_once '../../config/properties.php';
    include_once "../../resources/offering.php";
    require_once('tcpdf_include.php');

    $id = $_GET['uid'];
    $name = $_GET['name'];
    $from_date = $_GET['from_date'];
    $to_date = $_GET['to_date'];

    $start = date("d-m-Y", strtotime($from_date));
    $end = date("d-m-Y", strtotime($to_date));

    // initialize objects
    $offering = new Offering();
    $offering->user_id = $id;
    $total_points = 0;

    // Extend the TCPDF class to create custom Header and Footer
    class MYPDF extends TCPDF {

        //Page header
        public function Header() {
            // get the current page break margin
            $bMargin = $this->getBreakMargin();
            // get current auto-page-break mode
            $auto_page_break = $this->AutoPageBreak;
            // disable auto-page-break
            $this->SetAutoPageBreak(false, 0);

            // restore auto-page-break status
            $this->SetAutoPageBreak($auto_page_break, $bMargin);
            // set the starting point for the page content
            $this->setPageMark();
        }

    }

    // create new PDF document
    $pdf = new MYPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetTitle('Report');

// set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

// set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, 2, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(0);
    $pdf->SetFooterMargin(0);

// remove default footer
    $pdf->setPrintFooter(false);

// set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
    if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
        require_once(dirname(__FILE__) . '/lang/eng.php');
        $pdf->setLanguageArray($l);
    }
// add a page
    $pdf->AddPage();

    $pdf->SetFont('freesans', '', 10);
    //---------------------
    $off_val_date = "";
    $data = "<h4>" . _("US0109") . " : $name</h4>";
    if ($from_date !== "") {
        $data .= "<h4>Starts From : $start  To : $end</h4>";
    } else {
        $data .= "<h4>Starts From : ---  To : ---</h4>";
    }

    $tbl = '<h2 align="center">' . _("RP0107") . '</h2>';
    if ($from_date !== "") {
        $off_val_date = " AND DATE(ca.course_assigned_ts)>='$from_date' AND DATE(ca.course_assigned_ts)<='$to_date' ";
    } else {
        $off_val_date = "";
    }
    $pdf->writeHTML($data, true, false, false, false, '');

    $tbl .= '<table cellspacing="0" cellpadding="5" border="1">
    <tr>
            <th>' . _('HM0114') . '</th>
            <th>' . _('RP0109') . '</th>
            <th>' . _('RP0110') . '</th>
            <th>' . _('RP0111') . '</th>
            <th>' . _('RP0112') . '</th>
    </tr>';
    $stmt = $offering->offering_Course_Report($off_val_date);
    $num = $stmt->rowCount();
    if ($num > 0) {
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $tbl .= ' <tr nobr="true">
                                                        <td>' . $row['course_name'] . '</td>
                                                        <td>' . $row['total_time'] . '</td>
                                                        <td>' . $row['content_completion'] . '</td>
                                                        <td>' . $row['passing_score'] . '</td>
                                                        <td>' . $row['score'] . '</td>
                                                        ';         
            $tbl .= '</tr>';
        }
    }
    $total_duration = $offering->get_Course_totalTime($off_val_date);
    $tbl .= '<tr nobr="true">
<td colspan="4" align="right"><b>' . _("RP0119") . '</b></td>
<td><b>' . $total_duration . '</b></td>
</tr>';
    $tbl .= '</table>';
    $pdf->writeHTML($tbl, true, false, false, false, '');

    $discussion_forum = 0;
    $offer_completion = 0;
    $offer_ratings = 0;
    $offer_score1 = 0;
    $score1 = 0;
    $offer_score2 = 0;
    $score2 = 0;
    $offer_score3 = 0;
    $score3 = 0;
    $offer_score4 = 0;
    $score4 = 0;
    $offer_view = 0;
    $html = '<h2 align="center">' . _("RP0115") . '</h2>';
    $stmt_points = $offering->get_ReportActivityPoints();
    while ($row_pt = $stmt_points->fetch(PDO::FETCH_ASSOC)) {
        if ($row_pt['name'] == "discussion_forum") {
            $discussion_forum = $row_pt['points'];
        }
        if ($row_pt['name'] == "offer_completion") {
            $offer_completion = $row_pt['points'];
        }
        if ($row_pt['name'] == "offer_ratings") {
            $offer_ratings = $row_pt['points'];
        }
        if ($row_pt['name'] == "offer_score1") {
            $offer_score1 = $row_pt['points'];
            $score1 = $row_pt['score'];
        }
        if ($row_pt['name'] == "offer_score2") {
            $offer_score2 = $row_pt['points'];
            $score2 = $row_pt['score'];
        }
        if ($row_pt['name'] == "offer_score3") {
            $offer_score3 = $row_pt['points'];
            $score3 = $row_pt['score'];
        }
        if ($row_pt['name'] == "offer_score4") {
            $offer_score4 = $row_pt['points'];
            $score4 = $row_pt['score'];
        }
        if ($row_pt['name'] == "offer_view") {
            $offer_view = $row_pt['points'];
        }
    }
    $html .= '<table cellspacing="0" cellpadding="5" border="1">';
    $html .= '<tr nobr="true">';
    $html .= "<th>" . _("RP0116") . "</th>"
            . "<th>" . _("RP0117") . "</th>"
            . "<th>" . _("RP0118") . "</th>"
            . "</tr>";
    $total_points_pt = 0.0;
    //forum
    if ($from_date !== "") {
        $forum_val_date = "AND DATE(ft.last_updated_ts)>='$from_date' AND DATE(ft.last_updated_ts)<='$to_date'";
    } else {
        $forum_val_date = "";
    }
    $forum_count = $offering->get_totaltopic($forum_val_date, $discussion_forum);
    if ($from_date !== "") {
        $forum_val_date = "AND DATE(ftr.last_updated_ts)>='$from_date' AND DATE(ftr.last_updated_ts)<='$to_date'";
    } else {
        $forum_val_date = "";
    }
    $response_count = $offering->get_totalresponse($forum_val_date, $discussion_forum);
    $total_res = $forum_count + $response_count;
    $total_points_pt += $total_res;
    $html .= '<tr nobr="true">';
    $html .= "<td>" . _('LB0111') . "</td>
                                            <td></td>
                                            <td>$total_res</td>
                                        </tr>";
//                                       //offer completion
    $offer_completionDate = "";
    if ($from_date !== "") {
        $offer_completionDate = "AND DATE(ca.course_assigned_ts)>='$from_date' AND DATE(ca.course_assigned_ts)<='$to_date'";
    } else {
        $offer_completionDate = "";
    }
    $stmt_completion = $offering->get_offer_CompletionCount($offer_completionDate, $offer_completion, $score1, $score2, $score3, $score4, $offer_score1, $offer_score2, $offer_score3, $offer_score4);
    while ($row_cmp = $stmt_completion->fetch(PDO::FETCH_ASSOC)) {
        $offer_completion_points_value = $row_cmp['offer_completion_points'];
        $offer_score1_points_value = $row_cmp['offer_score1_points'];
        $offer_score2_points_value = $row_cmp['offer_score2_points'];
        $offer_score3_points_value = $row_cmp['offer_score3_points'];
        $offer_score4_points_value = $row_cmp['offer_score4_points'];
    }
    $offer_completion_points = "";
    $stmt_completion_points = $offering->get_offer_CompletionPointsCount($offer_completionDate, $offer_completion);
    while ($row_cmppt = $stmt_completion_points->fetch(PDO::FETCH_ASSOC)) {
        $offer_completion_points .= $row_cmppt['course_name'] . "(" . $row_cmppt['offer_completion_points'] . ")<br/>";
    }
    $total_points_pt += $offer_completion_points_value;
    $html .= '<tr nobr="true">';
    $html .= "<td>" . _('RP0124') . "</td>
                                            <td >$offer_completion_points</td>
                                            <td>$offer_completion_points_value</td>
                                        </tr>";
    //above90
    $offer_score1_points = "";
    $score_value = " ca.score >= " . $score1 . " ";
    $stmt_completion_score1 = $offering->get_offer_score($offer_completionDate, $offer_score1, $score_value);
    while ($row_cmp_score1 = $stmt_completion_score1->fetch(PDO::FETCH_ASSOC)) {
        $offer_score1_points .= $row_cmp_score1['course_name'] . "(" . $row_cmp_score1['offer_score1_points'] . ")<br/>";
    }
    $total_points_pt += $offer_score1_points_value;
    $html .= '<tr nobr="true">';
    $html .= "<td>" . _('RP0125') . " $score1 and above</td>
                                            <td>$offer_score1_points</td>
                                            <td>$offer_score1_points_value</td>
                                        </tr>";
    //above80
    $offer_score2_points = "";
    $score_value = " ca.score >= " . $score2 . " AND ca.score<" . $score1 . " ";
    $stmt_completion_score2 = $offering->get_offer_score($offer_completionDate, $offer_score2, $score_value);
    while ($row_cmp_score2 = $stmt_completion_score2->fetch(PDO::FETCH_ASSOC)) {
        $offer_score2_points .= $row_cmp_score2['course_name'] . "(" . $row_cmp_score2['offer_score1_points'] . ")<br/>";
    }
    $total_points_pt += $offer_score2_points_value;
    $html .= '<tr nobr="true">';
    $html .= "<td>" . _('RP0125') . " " . $score2 . " - " . --$score1 . " </td>
                                            <td>$offer_score2_points</td>
                                            <td>$offer_score2_points_value</td>
                                        </tr>";
    //above70
    $offer_score3_points = "";
    $score_value = " ca.score >= " . $score3 . " AND ca.score<" . $score2 . " ";
    $stmt_completion_score3 = $offering->get_offer_score($offer_completionDate, $offer_score3, $score_value);
    while ($row_cmp_score3 = $stmt_completion_score3->fetch(PDO::FETCH_ASSOC)) {
        $offer_score3_points .= $row_cmp_score3['course_name'] . "(" . $row_cmp_score3['offer_score1_points'] . ")<br/>";
    }
    $total_points_pt += $offer_score3_points_value;
    $html .= '<tr nobr="true">';
    $html .= "<td>" . _('RP0125') . " " . $score3 . " - " . --$score2 . " </td>
                                            <td>$offer_score3_points</td>
                                            <td>$offer_score3_points_value</td>
                                        </tr>";
    //above70
    $offer_score4_points = "";
    $score_value = " ca.score >= " . $score4 . " AND ca.score<" . $score3 . " ";
    $stmt_completion_score4 = $offering->get_offer_score($offer_completionDate, $offer_score4, $score_value);
    while ($row_cmp_score4 = $stmt_completion_score4->fetch(PDO::FETCH_ASSOC)) {
        $offer_score4_points .= $row_cmp_score4['course_name'] . "(" . $row_cmp_score4['offer_score1_points'] . ")<br/>";
    }
    $total_points_pt += $offer_score4_points_value;
    $html .= '<tr nobr="true">';
    $html .= "<td>" . _('RP0125') . " " . $score4 . " - " . --$score3 . " </td>
                                            <td>$offer_score4_points</td>
                                            <td>$offer_score4_points_value</td>
                                        </tr>";
    //offer view
//                                        $total_viewTime = $offering->get_offer_viewpt($offer_completionDate,$offer_view);
    $offer_totalTime = 0.0;
    $offer_view_points = "";
    $stmt_view = $offering->get_offer_view($offer_completionDate, $offer_view);
    while ($row_view = $stmt_view->fetch(PDO::FETCH_ASSOC)) {
        $offer_view_points .= $row_view['course_name'] . "(" . $row_view['total_time'] . ")<br/>";
        $offer_totalTime += $row_view['total_time'];
    }
    $total_points_pt += $offer_totalTime;
    $html .= '<tr nobr="true">';
    $html .= "<td>" . _('RP0126') . "</td>
                                            <td>$offer_view_points</td>
                                            <td>$offer_totalTime</td>
                                        </tr>";
    //offer rating
    $offer_totalrating = 0.0;
    $offer_rating_points = "";
    $stmt_rat = $offering->get_offer_rating($offer_completionDate, $offer_ratings);
    while ($row_rat = $stmt_rat->fetch(PDO::FETCH_ASSOC)) {
        $offer_rating_points .= $row_rat['course_name'] . "(" . $row_rat['rating_value'] . ")<br/>";
        $offer_totalrating += $row_rat['rating_value'];
    }
    $total_points_pt += $offer_totalrating;
    $html .= '<tr nobr="true">';
    $html .= "<td>" . _('RP0127') . "</td>
                                            <td>$offer_rating_points</td>
                                            <td>$offer_totalrating</td>
                                        </tr>";
    $html .= '<tr nobr="true">';
    $html .= '<td colspan="2" align="right"><b>' . _('RP0123') . '</b></td> <td><b> ' . $total_points_pt . ' </b></td></tr>';
    $html .= "</table>";

    $pdf->writeHTML($html, true, false, false, false, '');


// -----------------------------------------------------------------------------
//Close and output PDF document
    die($pdf->Output('report_user.pdf', 'I'));

//============================================================+
// END OF FILE
//============================================================+

?>


