<?php
// start session 
session_start();
    include 'config/database.php';
    include_once "security/session_config.php";
    include_once "security/csrf.php";
    // connect to database
    
    include_once 'config/properties.php';
    include_once "resources/manageusers.php";
    include_once "resources/EncryptDecrypt.php";
    include_once "resources/notice.php";

    // initialize objects
    $users = new ManageUsers();
    $notice = new Notice();
    $csrf_token=get_csrf_token();

    // set page title
    $page_no = 4;
    $page_url = "announcement.php";
    $user_id = $_SESSION['uid'];

    // for pagination purposes
    $page = isset($_GET['page']) ? $_GET['page'] : 1; // page is the current page, if there's nothing set, default is page 1
    $records_per_page = 10; // set records or rows of data per page
    $from_record_num = ($records_per_page * $page) - $records_per_page; // calculate for the query LIMIT clause
    ?>
    <!DOCTYPE>
    <html lang="en">
        <head>
            <?php include "./head.php" ?>
            <title>
                <?php echo _("LB0103"); ?>
            </title>
            <link rel="stylesheet" href="assets/css/announcement/style.css">

        </head>
        <body>
            <?php include "./menu_primary.php"; ?>
            <section class="page-header mt-0 masthead -type-2 pt-0 pb-0 justify-center">
                <div class="masthead__bg">
                    <div class="bg-image js-lazy loaded" data-ll-status="loaded" 
                    <?php if ($cust_company_banner_image_path_announcement == "") { ?>
                             style="background-image: url(assets/images/bg/announcement.jpg)" 
                         <?php } else { ?>
                             style="background-image: url('<?php echo $cust_company_banner_image_path_announcement; ?>');"
                         <?php } ?>
                         ></div>
                </div>
                <h1 class="masthead__title text-white text-center pt-60 pb-50 mt-0 mb-0">
                    <?php echo _("HM0127") ?>
                </h1>
            </section>
            <div class = "container pb-90 rounded-16 mb-50">
                <?php
                $notice->user_id = $user_id;
                $notice->date = $date;
                $stmt = $notice->getNotices($from_record_num, $records_per_page);
                // count number of retrieved products
                $num = $stmt->rowCount();

                if ($num > 0) {
                    // needed for paging
                    $total_rows = $notice->getNotices_count();
                    ?>

                    <div class="pb-5 border-bottom-dark">
                        <h2 class="text-20 fw-500"><?php echo $total_rows ?> Announcements</h2>
                    </div>
                    <ol class="c-stepper mt-10 px-0">
                        <?php
                        $newEndDatedif = "";
                        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                            extract($row);
                            $newEndDate = date("d M Y", strtotime($end_date));
                            ?>

                            <?php if ($newEndDatedif != $newEndDate) { ?>
                                <li class="c-stepper__item <?php if ($view_ts == null) { ?>active<?php } ?>">
                                    <div class="c-stepper__content">
                                        <h4 class="c-stepper__title <?php if ($view_ts == null) { ?>active<?php } ?> mt-5 ml-10"><?php echo $newEndDate ?></h4>
                                    <?php } ?>
                                    <div class="accordion -block-2 text-left js-accordion mt-20 shadow-3" <?php if ($view_ts == null) { ?>onclick="UpdateViewTimeStamp(this, <?php echo $notice_board_id ?>, '<?php echo $csrf_token ?>')"<?php } ?> id="notice_<?php echo $notice_board_id ?>">
                                        <div class="accordion__item">
                                            <div class="accordion__button py-15 px-25 bg-light-3 <?php if ($view_ts == null) { ?>active<?php } ?>">
                                                <div class="d-flex items-center">
                                                    <div class="accordion__icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                             viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                                             stroke-linecap="round" stroke-linejoin="round"
                                                             class="feather feather-chevron-down icon">
                                                        <polyline points="6 9 12 15 18 9"></polyline>
                                                        </svg>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                             viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                                             stroke-linecap="round" stroke-linejoin="round"
                                                             class="feather feather-chevron-up icon">
                                                        <polyline points="18 15 12 9 6 15"></polyline>
                                                        </svg>
                                                    </div>
                                                    <span class="text-17 fw-500 lh-15"><?php echo htmlentities($notice_subject) ?></span>
                                                </div>
                                            </div>

                                            <div class="accordion__content">
                                                <div class="accordion__content__inner px-30 py-30">
                                                    <div class="y-gap-30 text-15 lh-15">
                                                        <?php echo nl2br(htmlentities($notice_desc)); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php $newEndDatedif = $newEndDate; ?>
                                    <?php if ($newEndDatedif != $newEndDate) { ?>
                                    </div>
                                </li>
                                <?php
                            }
                        }
                        ?>
                    </ol>
                    <?php
                    $_GET['total_rows'] = $total_rows;
                    $_GET['records_per_page'] = $records_per_page;
                    $_GET['page'] = $page;
                    $_GET['page_url'] = $page_url;
                    include('modules/paging.php');
                } else {
                    ?>
                    <div class="d-flex justify-center mt-25 py-60 text-30 fw-500">
                        <?php echo _("AN0501"); ?>
                    </div>

                <?php }
                ?>
            </div>
            <?php include "./footer_primary.php" ?>
            <script>
                function UpdateViewTimeStamp(thisobj, notice_board_id,csrf_token) {
                    var id = notice_board_id;
                    $.ajax({
                        url: "modules/show_announcement.php",
                        data: {"id": id,"csrf_token":csrf_token},
                        dataType: "html",
                        type: 'POST',
                        success: function () {
                            $(thisobj).find('.accordion__button').removeClass('active');
                            if ($(thisobj).closest('li').find('.active').length == "1") {
                                $(thisobj).prev('.c-stepper__title').removeClass('active');
                                $(thisobj).closest('.c-stepper__item').removeClass('active');
                            }
                        }
                    });
                }
                $(window).on("load", function () {
                    var url = document.location.toString();
                    var paramString = url.split('?')[1];
                    $(".accordion").each(function () {
                        if ($(this).attr('id') === paramString) {
                            $(this).click();
                            $(this).find('.accordion__item').addClass('is-active');
                            $(this).find('.accordion__content').css("max-height", "60px");
                        }
                    });
                });
            </script>
        </body>
    </html>