<?php

//============================================================+
// File name   : example_051.php
// Begin       : 2009-04-16
// Last Update : 2013-05-14
//
// Description : Example 051 for TCPDF class
//               Full page background
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Full page background
 * @author Nicola Asuni
 * @since 2009-04-16
 */
// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');
require_once('../../config.php');

$cname = "";
$clogo = "";
//$sql = "SELECT * FROM company_profile";
//$result = mysqli_query($link, $sql);
//if ($row = mysqli_fetch_array($result)) {
//    $cname = $row['name'];
//    $clogo = $row['logo_path'];
//}

$is_name = $_GET['is_name'];

$format_id=$_GET['format_id'];
$comp_name_path ="";
$sign_path="";
$sql1 = "SELECT cp.name,cp.logo_path,cf.comp_name_path,cf.sign_path FROM certificate_format as cf,company as cp WHERE cp.company_id=cf.company_id AND cf.format_id=$format_id";
$result1 = mysqli_query($link, $sql1);
if ($row1 = mysqli_fetch_array($result1)) {
    $comp_name_path = $row1['comp_name_path'];
    $sign_path = $row1['sign_path'];
    $cname = $row1['name'];
    $clogo = $row1['logo_path'];
}

$text1 = $_GET['t1'];
$text2 = $_GET['t2'];
$text3 = $_GET['t3'];
$text4 = $_GET['t4'];
$text5 = $_GET['t5'];
$text6 = $_GET['t6'];

$text1_color = $_GET['c1'];
$record1 = explode(",", $text1_color);
$text2_color = $_GET['c2'];
$record2 = explode(",", $text2_color);
$text3_color = $_GET['c4'];
$record3 = explode(",", $text3_color);
$text4_color = $_GET['c6'];
$record4 = explode(",", $text4_color);
$text5_color = $_GET['c8'];
$record5 = explode(",", $text5_color);
$name_color = $_GET['c3'];
$record6 = explode(",", $name_color);
$course_color = $_GET['c5'];
$record7 = explode(",", $course_color);
$grade_color = $_GET['c7'];
$record8 = explode(",", $grade_color);
$signatory_color = $_GET['c9'];
$record9 = explode(",", $signatory_color);
$comp_name_color = $_GET['c10'];
$record10 = explode(",", $comp_name_color);

$text1_size = $_GET['f1'];
$text2_size = $_GET['f2'];
$text3_size = $_GET['f4'];
$text4_size = $_GET['f6'];
$text5_size = $_GET['f8'];
$name_size = $_GET['f3'];
$course_size = $_GET['f5'];
$grade_size = $_GET['f7'];
$signatory_size = $_GET['f9'];
$comp_name_size = $_GET['f10'];

// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // get the current page break margin
        $bMargin = $this->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $this->AutoPageBreak;
        // disable auto-page-break
        $this->SetAutoPageBreak(false, 0);
        // set bacground image
        $this->Image(FORMAT_TEMPLATE, 0, 0, 297, 210, '', '', '', false, 300, '', false, false, 0);
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $this->setPageMark();
    }

}

// create new PDF document
$pdf = new MYPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetTitle('Certificate');
$pdf->SetSubject('Certificate');
$pdf->SetKeywords('Certificate');

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(0, 0, 0);
$pdf->SetHeaderMargin(0);
$pdf->SetFooterMargin(0);

// remove default footer
$pdf->setPrintFooter(false);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
    require_once(dirname(__FILE__) . '/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// add a page
$pdf->AddPage();
$style3 = array('width' => 0.2, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0));
// Print a text
$pdf->Ln(20);
$pdf->SetFont('freesans', 'B', $comp_name_size);
$pdf->SetTextColor($record10[0], $record10[1], $record10[2]);
if ($is_name == "Y") {
    $pdf->MultiCell(0, 0, $cname, 0, 'C', 0, 0, '', '', true, 0);
} else if ($is_name == "F") {
	if($comp_name_path!="")
	{
	$pdf->Image(COMP_NAME_PATH . $comp_name_path, '', '', '', '', '', '', '', true, 300, 'C');
	}
	else{
        $pdf->MultiCell(0, 0, '[Company name image]', 0, 'C', 0, 0, '', '', true, 0);
	}
}
$pdf->Ln(22);
$pdf->SetFont('freesans', 'B', $text1_size);
$pdf->SetTextColor($record1[0], $record1[1], $record1[2]);
$pdf->MultiCell(0, 0, $text1, 0, 'C', 0, 0, '', '', true, 0);
$pdf->Ln(22);
$pdf->SetFont('freesans', 'B', $text2_size);
$pdf->SetTextColor($record2[0], $record2[1], $record2[2]);
$pdf->MultiCell(0, 0, $text2, 0, 'C', 0, 0, '', '', true, 0);
$pdf->Ln(12);
$pdf->Image(FORMAT_BADGE, 40, 76, '', '', '', '', '', true, 300, '');
$pdf->SetFont('freesans', 'B', $name_size);
$pdf->SetTextColor($record6[0], $record6[1], $record6[2]);
$pdf->MultiCell(0, 0, '[First name] [Last name]', 0, 'C', 0, 0, '', '', true, 0);
$pdf->Ln(20);
$pdf->SetFont('freesans', 'B', $text3_size);
$pdf->SetTextColor($record3[0], $record3[1], $record3[2]);
$pdf->MultiCell(0, 0, $text3, 0, 'C', 0, 0, '', '', true, 0);
$pdf->Ln(11);
$pdf->SetFont('freesans', 'B', 20);
$pdf->SetTextColor($record7[0], $record7[1], $record7[2]);
$pdf->MultiCell(0, 0, '[Course]', 0, 'C', 0, 0, '', '', true, 0);
$pdf->Ln(14);
$pdf->SetFont('freesans', 'B', $text4_size);
$pdf->SetTextColor($record4[0], $record4[1], $record4[2]);
$pdf->MultiCell(0, 0, $text4, 0, 'C', 0, 0, '', '', true, 0);
$pdf->Ln(10);
$pdf->SetFont('freesans', 'BU', $grade_size);
$pdf->SetTextColor($record8[0], $record8[1], $record8[2]);
$pdf->MultiCell(0, 0, '[Grade]', 0, 'C', 0, 0, '', '', true, 0);
$pdf->Ln(15);
//$pdf->SetXY(50, 150);
$pdf->setCellPaddings($left = '50', $top = '', $right = '46', $bottom = '');
if ($text5 != "") {
    $pdf->SetFont('freesans', 'B', $text5_size);
    $pdf->SetTextColor($record5[0], $record5[1], $record5[2]);
    $pdf->Cell(0, 0, '[Date]', 0, false, 'L', 0, '', 0, false, 'T', 0);
}
if ($clogo != "") {
    $pdf->Image(COMPANY_PROFILE . $clogo, '', '', '', '', '', '', '', true, 300, 'C');
}

$pdf->SetFont('freesans', 'B', $signatory_size);
$pdf->SetTextColor($record9[0], $record9[1], $record9[2]);
if($sign_path!="")
	{
	$pdf->Image(SIGNATORY_PATH . $sign_path, 220, 142, '', '', '', '', '', true, 100, 'C');
	}
else
{
$pdf->Cell(0, 0, '[Signatory]', 0, false, 'R', 0, '', 0, false, 'T', 'M');
}
if ($text5 != "") {
    $pdf->Line(30, 156, 100, 156);
}
if ($text6 != "") {
    $pdf->Line(200, 156, 270, 156);
}
$pdf->Ln(1);
$pdf->setCellPaddings($left = '45', $top = '', $right = '30', $bottom = '');
if ($text5 != "") {
    $pdf->SetFont('freesans', 'B', $text5_size);
    $pdf->SetTextColor($record5[0], $record5[1], $record5[2]);
    $pdf->Cell(0, 30, $text5, 0, false, 'L', 0, '', 0, false, 'T', 'M');
}
if ($text6 != "") {
    $pdf->SetFont('freesans', 'B', $signatory_size);
    $pdf->SetTextColor($record9[0], $record9[1], $record9[2]);
    $pdf->Cell(0, 30, $text6, 0, false, 'R', 0, '', 0, false, 'T', 'M');
}
//$pdf->SetFont('times', 'BU', $grade_size);
//$pdf->SetTextColor($record8[0], $record8[1], $record8[2]);
//$pdf->MultiCell(0, 0, '[Grade]', 0, 'L', 0, 0, '', '', true, 0);
//$pdf->Ln(10);
//$pdf->Line(2, 158, 50, 158, $style3);
//$pdf->Image(FORMAT_BADGE, '', '', '', '', '', '', '', true, 300, 'C');
//$pdf->SetFont('times', 'BU', $grade_size);
//$pdf->SetTextColor($record8[0], $record8[1], $record8[2]);
//$pdf->MultiCell(0, 0, '[Grade]', 0, 'R', 0, 0, '', '', true, 0);
//$pdf->Line(2, 158, 50, 158, $style3);
// --- example with background set on page ---
// remove default header
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// ---------------------------------------------------------
//Close and output PDF document
$pdf->Output('certificate_format.pdf', 'I');
