<?php
/// start session 
session_start();
    include 'config/database.php';
    include_once "security/session_config.php";
    // connect to database
    
    include_once 'config/properties.php';
    include_once "resources/manageusers.php";
    include_once "resources/EncryptDecrypt.php";

    $users = new ManageUsers();

    // set page title
    $page_no = 6;
    $user_id = $_SESSION['uid'];
    ?>
    <!DOCTYPE>
    <html lang="en">
        <head>
            <?php include "./head.php" ?>
            <title>
                <?php echo _("LB0106"); ?>
            </title>
            <link rel="stylesheet" href="assets/css/about/style.css">
        </head>
        <body>
            <?php include "./menu_primary.php"; ?>
            <div class="container py-30 x-gap-60 bg-primary-opacity-1 rounded-16 mb-50">
                <div class="row justify-center text-center mb-40">

                    <div class="sectionTitle mb-20">
                        <h2 class="sectionTitle__title"> <?php echo _("AB0109"); ?></h2>
                        <p class="sectionTitle__text"><?php echo _("INF0102")?></p>
                    </div>

                    <div class="container bg-white pt-40 lg:pt-20 rounded-16">
                        <div class="row justify-center items-center text-center pb-20">
                            <p class="text-20 mt-0 mb-0">Version <?php echo $properties['jdbc.version'] ?></p>
                            <p class="mt-5 mb-0"><?php echo _("AB0103"); ?> :&nbsp;<?php echo htmlentities($cust_company_name); ?></p>
                            <?php if ($row_company['logo_path'] != "") { ?>

                                <img  src="<?php echo $cust_company_image_path; ?>" alt='Image' class="about_company_logo"><br/><br/>
                                <?php
                            }
                            ?>
                            <p class="mt-10"><?php echo _("AB0101") ?><br />
                                <?php echo _("AB0102") ?></p>
                        </div>

                        <div class="row justify-center items-center text-center py-60">
                            <div class="row y-gap-10 justify-center text-center">
                                <div class="col-auto">
                                    <div class="sectionTitle ">
                                        <h2 class="sectionTitle__title"><?php echo _("AB0104") ?></h2>
                                        <p class="sectionTitle__text"><?php echo _("AB0105") ?></p>
                                    </div>
                                </div>
                            </div>

                            <div class="row y-gap-30 justify-between pt-30 lg:pt-20 pb-30">

                                <div class="col-xl-2 col-lg-3 col-md-6">
                                    <div class="d-flex flex-column items-center text-center">
                                        <div
                                            class="relative size-120 d-flex justify-center items-center rounded-full bg-primary-opacity-1">
                                            <img src="assets/images/icons/about1.svg" alt="image">
                                        </div>
                                        <div class="text-17 fw-500 text-dark-1 mt-30"><?php echo _("AB0106") ?></div>
                                    </div>
                                </div>

                                <div class="col-auto xl:d-none">
                                    <div class="pt-30">
                                        <img src="assets/images/icons/dot_arrow.svg" alt="icon">
                                    </div>
                                </div>

                                <div class="col-xl-2 col-lg-3 col-md-6">
                                    <div class="d-flex flex-column items-center text-center">
                                        <div
                                            class="relative size-120 d-flex justify-center items-center rounded-full bg-primary-opacity-1">
                                            <img src="assets/images/icons/about3.svg" alt="image">
                                        </div>
                                        <div class="text-17 fw-500 text-dark-1 mt-30"><?php echo _("AB0107") ?></div>
                                    </div>
                                </div>

                                <div class="col-auto xl:d-none">
                                    <div class="pt-30">
                                        <img src="assets/images/icons/dot_arrow_down.svg" alt="icon">
                                    </div>
                                </div>


                                <div class="col-xl-2 col-lg-3 col-md-6">
                                    <div class="d-flex flex-column items-center text-center">
                                        <div
                                            class="relative size-120 d-flex justify-center items-center rounded-full bg-primary-opacity-1">
                                            <img src="assets/images/icons/about2.svg" alt="image">
                                        </div>
                                        <div class="text-17 fw-500 text-dark-1 mt-30"><?php echo _("AB0108") ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <?php include "./footer_primary.php" ?>
        </body>
    </html>

