<?php
session_start();
require_once("../config/database.php");
require_once("lti.php");
require_once("lib.php");

$lti = new LTI();
$admin_user_id = $_GET['user_id'];
$lti_types_id = $_GET['id'];
$courseid=$_GET['course_id'];
$comp_id=$_GET['comp_id'];
$config = array();
$type = new \stdClass();
$title = "";
$text = "";
try {
    $stmt = $lti->get_lti_types($lti_types_id);
    // fetch values
    if ($result = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $type->lti_typename = $result['tool_name'];
        $type->typeid = $result['lti_types_id'];
        $type->lti_toolurl = $result['tool_url'];
        $type->lti_ltiversion = $result['lti_version'];
        $type->lti_clientid = $result['client_id'];
        $type->toolproxyid = $result['tool_proxy_id'];
        $type->lti_parameters = $result['parameter'];
    }

    $stmt = $lti->get_lti_types_config($lti_types_id);
    // fetch values
    while ($result = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $config[$result['name']] = $result['value'];
    }
    if (isset($config['publickeyset'])) {
        $type->lti_publickeyset = $config['publickeyset'];
    }
    if (isset($config['keytype'])) {
        $type->lti_keytype = $config['keytype'];
    }
    if (isset($config['initiatelogin'])) {
        $type->lti_initiatelogin = $config['initiatelogin'];
    }
    if (isset($config['sendname'])) {
        $type->lti_sendname = $config['sendname'];
    }
    if (isset($config['send_email_id'])) {
        $type->lti_sendemailaddr = $config['send_email_id'];
    }
    if (isset($config['accept_grades'])) {
        $type->lti_acceptgrades = $config['accept_grades'];
    }
    if (isset($config['customparameters'])) {
        $type->lti_customparameters = $config['customparameters'];
    }
    if (isset($config['launchcontainer'])) {
        $type->lti_launchcontainer = $config['launchcontainer'];
    }
    if (isset($config['content_item_selection_request'])) {
        $type->lti_toolurl_ContentItemSelectionRequest = $config['content_item_selection_request'];
    }
    // Get the parameters from the LTI services.
    foreach ($config as $name => $value) {
        if (strpos($name, 'ltiservice_') === 0) {
            $type->{$name} = $config[$name];
        }
    }
} catch (PDOException $e) {
    error_log("Caught $e");
}
# ------------------------------
# START CONFIGURATION SECTION
#
if ($type->lti_ltiversion === LTI_VERSION_1P3) {
    if (!isset($SESSION->lti_initiatelogin_status)) {
        echo lti_initiate_login($admin_user_id,$courseid,$comp_id, 0, 0, null, $type, 'ContentItemSelectionRequest', $title, $text);
        exit;
    } else {
        unset($SESSION->lti_initiatelogin_status);
    }
}
?>

