<?php
// start session 
session_start();
if (!isset($_SESSION['uid'])) {
    header("Location: index.php");
} else {
    // connect to database
    include 'config/database.php';
    include_once 'config/properties.php';
    include_once "resources/manageusers.php";
    include_once "resources/EncryptDecrypt.php";
    include_once "resources/survey.php";

    // initialize objects
    $survey = new Survey();
    $users = new ManageUsers();

    // set page title
    $page_no = 10;
    $page_url = "survey.php";
    $user_id = $_SESSION['uid'];

    // for pagination purposes
    $page = isset($_GET['page']) ? $_GET['page'] : 1; // page is the current page, if there's nothing set, default is page 1
    $records_per_page = 10; // set records or rows of data per page
    $from_record_num = ($records_per_page * $page) - $records_per_page; // calculate for the query LIMIT clause
    ?>
    <!DOCTYPE>
    <html lang="en">
        <head>
            <?php include "./head.php" ?>
            <title>
                <?php echo _("SY0108"); ?>
            </title>
            <link rel="stylesheet" href="assets/css/survey/style.css">
        </head>
        <body>
            <?php include "./menu_primary.php"; ?>
            <section class="page-header mt-0 masthead -type-2 pt-0 pb-0 justify-center">
                <div class="masthead__bg">
                    <div class="bg-image js-lazy loaded" data-ll-status="loaded"
                    <?php if ($cust_company_banner_image_path_survey == "") { ?>
                             style="background-image: url(assets/images/bg/survey.jpg)" 
                         <?php } else { ?>
                             style="background-image: url('<?php echo $cust_company_banner_image_path_survey; ?>');"
                         <?php } ?>
                         ></div>
                </div>
                <h1 class="masthead__title text-white text-center pt-60 pb-50 mt-0 mb-0">
                    <?php echo _("SY0101"); ?>
                </h1>
            </section>
            <div class="container pb-90 rounded-16 mb-50">
                <?php
                $survey->user_id = $user_id;
                $survey->date = $date;
                $stmt = $survey->getSurvey($from_record_num, $records_per_page);
                // count number of retrieved products
                $num = $stmt->rowCount();
                if ($num > 0) {
                    // needed for paging
                    $total_rows = $survey->getSurvey_count();
                    ?>
                    <ol class="c-stepper mt-10 px-0">
                        <?php
                        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                            extract($row);
                            $newStartDate = date("d M Y", strtotime($start_date));
                            $newEndDate = date("d M Y", strtotime($end_date));
                            ?>
                            <li class="c-stepper__item">
                                <a class="c-stepper__content" href="javascript:void(0)" onclick="showSurvey(<?php echo $survey_publish_id ?>)">
                                    <div class="px-20 py-10 border-light bg-white rounded-8 shadow-2">
                                        <h2 class="text-16 fw-500 lh-15 border-bottom-light pb-20"><?php echo htmlentities($survey_title) ?></h2>
                                        <?php if($survey_description != ""){ ?>
                                        <div class="text-15 lh-15 py-10 border-bottom-light">
                                            <?php echo htmlentities($survey_description) ?>
                                        </div>
                                        <?php } ?>
                                        <div class="d-flex py-15">
                                            <div><i class="fa fa-calendar"></i> Start Date: <?php echo htmlentities($newStartDate) ?></div>
                                            <div class="ml-30"><i class="fa fa-calendar"></i> End Date: <?php echo htmlentities($newEndDate) ?></div>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        <?php } ?>
                    </ol>
                    <?php
                    $_GET['total_rows'] = $total_rows;
                    $_GET['records_per_page'] = $records_per_page;
                    $_GET['page'] = $page;
                    $_GET['page_url'] = $page_url;
                    include('modules/paging.php');
                } else {
                    ?>
                    <div class="d-flex justify-center mt-25 py-60 text-30 fw-500">
                        <?php echo _("SY0104"); ?>
                    </div>

                    <?php
                }
                ?>
            </div>
            <?php include "./footer_primary.php" ?>
        </body>
    </html>
<?php } ?>
<script>
    function showSurvey(sur_id) {
        var width = window.innerWidth;
        var height = window.innerHeight;
//        window.open('../assessment/quiz_assessment.php?oid=' + oid + '&aid=' + aid, 'newwindow', 'width=' + width + ', height=' + height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,top=' + ((window.innerHeight - height) / 2) + ', left=' + ((window.innerWidth - width) / 2));
        var winName = 'MySurveyWindow';
        var winURL = 'quiz_survey.php';
        var windowoption = 'width=' + width + ', height=' + height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,top=' + ((window.innerHeight - height) / 2) + ', left=' + ((window.innerWidth - width) / 2);
        //var windowoption = 'width=' + window.width + ', height=' + window.height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,fullscreen=yes';
        var params = {'sur_id': sur_id, 'c_pg': "survey"};
        var form = document.createElement("form");
        form.setAttribute("method", "post");
        form.setAttribute("action", winURL);
        form.setAttribute("target", winName);
        for (var i in params) {
            if (params.hasOwnProperty(i)) {
                var input = document.createElement('input');
                input.type = 'hidden';
                input.name = i;
                input.value = params[i];
                form.appendChild(input);
            }
        }
        document.body.appendChild(form);
        window.open('', winName, windowoption);
        //window.open('', winName, "fullscreen=yes,width=" + window.width + ",height=" + window.height)
        form.target = winName;
        form.submit();
        document.body.removeChild(form);
       /* var ss = window.location.href;
        var splitURL = ss.toString().split("?");
        window.location.href = splitURL[0];*/
    }
</script>
