<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
// start session
session_start();
if (!isset($_SESSION['uid'])) {
    header("Location: index.php");
} else {
// connect to database
    include_once "config/database.php";
    include_once "config/properties.php";
    include_once "resources/EncryptDecrypt.php";
    include_once "resources/offering.php";
    include_once "resources/manageusers.php";
    include_once "resources/survey.php";
    include_once "resources/company.php";
    include_once "resources/notice.php";

    // initialize objects
    $offering = new Offering();
    $notice = new Notice();
    $company = new Company();
    $survey = new Survey();
    $users = new ManageUsers();
    $page_no = '';
    $page_url = "";
    $user_id = $_SESSION['uid'];
    $website = "";
    $stmt = $company->getCustCompanyDetail($_SESSION['uid']);
    if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if ($row['website_link'] != "") {
            $website = $row['website_link'];
        }
    }
    $offering->user_id = $user_id;
    $offering->date = $date;
//     echo $total_rows;
    ?>
    <!DOCTYPE>
    <html lang="en">

        <head>
            <?php include "./head.php" ?>
            <title>
                <?php echo _("HM0136"); ?>
            </title>
            <link rel="stylesheet" href="assets/css/report/style.css">
        </head>

        <body>
            <?php include "./menu_primary.php"; ?>
            <div class="container py-20 x-gap-60 bg-primary-opacity-1 rounded-16 mb-50">
                <div class="row justify-start">
                    <div class="sectionTitle mb-10 text-center">
                        <h2 class="sectionTitle__title text-20">User Details</h2>
                    </div>

                    <div class="container bg-white rounded-16">
                        <div class="row justify-start">
                            <?php
                            $mobile_no = "---";
                            $email_id = "---";
                            $project = "---";
                            $location = "---";
                            $designation = "---";
                            $department = "---";
			    $end_date = "---";
                            $stmt_user = $users->UserDetails($_SESSION['uid']);
                            if ($row_user = $stmt_user->fetch(PDO::FETCH_ASSOC)) {
                                if ($row_user["email_id"] != "") {
                                    $email_id = $row_user["email_id"];
                                }if ($row_user["mobile_no"] != "") {
                                    $mobile_no = $row_user["mobile_no"];
                                }if ($row_user["project"] != "") {
                                    $project = $row_user["project"];
                                }if ($row_user["location"] != "") {
                                    $location = $row_user["location"];
                                }if ($row_user["designation"] != "") {
                                    $designation = $row_user["designation"];
                                }if ($row_user["dept_name"] != "") {
                                    $department = $row_user["dept_name"];
                                }
 				if ($row_user["end_date"] != ""){
                                    $end_date = $row_user["end_date"];
                                }
                                ?>
                                <div class="d-flex items-center py-10 col-md-2">
                                    <div class="d-flex justify-center items-center size-40 rounded-full bg-primary-opacity-1">
                                        <div class="fa fa-user text-16"></div>
                                    </div>
                                    <div class="ml-12">
                                        <h4 class="text-15 lh-1 fw-500"><?php echo _("CRT5108") ?></h4>
                                        <div class="text-13 lh-1 mt-10"><?php echo $row_user["user_id"] ?></div>
                                    </div>
                                </div>
                                <div class="d-flex items-center py-10 col-md-2">
                                    <div class="d-flex justify-center items-center size-40 rounded-full bg-primary-opacity-1">
                                        <div class="fa fa-user text-16 "></div>
                                    </div>
                                    <div class="ml-12">
                                        <h4 class="text-15 lh-1 fw-500"><?php echo _("US0153") ?></h4>
                                        <div class="text-13 lh-1 mt-10 wrap_text" id="name"><?php echo $row_user["first_name"] . "" . $row_user["last_name"] ?></div>
                                    </div>
                                </div>
                                <div class="d-flex items-center py-10 col-md-2">
                                    <div class="d-flex justify-center items-center size-40 rounded-full bg-primary-opacity-1">
                                        <div class="fa fa-user text-16 "></div>
                                    </div>
                                    <div class="ml-12">
                                        <h4 class="text-15 lh-1 fw-500"><?php echo _("US0109") ?></h4>
                                        <div class="text-13 lh-1 mt-10 wrap_text"><?php echo $row_user["login_id"] ?></div>
                                    </div>
                                </div>
                                <div class="d-flex items-center py-10 col-md-2">
                                    <div class="d-flex justify-center items-center size-40 rounded-full bg-primary-opacity-1">
                                        <div class="fa fa-envelope text-16"></div>
                                    </div>
                                    <div class="ml-12">
                                        <h4 class="text-15 lh-1 fw-500"><?php echo _("US0114") ?></h4>
                                        <div class="text-13 lh-1 mt-10 wrap_text"><?php echo $email_id ?></div>
                                    </div>
                                </div>
                                <div class="d-flex items-center py-10 col-md-2">
                                    <div class="d-flex justify-center items-center size-40 rounded-full bg-primary-opacity-1">
                                        <div class="fa fa-phone text-16"></div>
                                    </div>
                                    <div class="ml-12">
                                        <h4 class="text-15 lh-1 fw-500"><?php echo _("US0113") ?></h4>
                                        <div class="text-13 lh-1 mt-10"><?php echo $mobile_no ?></div>
                                    </div>
                                </div>

                                <div class="d-flex items-center py-10 col-md-2">
                                    <div class="d-flex justify-center items-center size-40 rounded-full bg-primary-opacity-1">
                                        <div class="fa fa-building text-16"></div>
                                    </div>
                                    <div class="ml-12">
                                        <h4 class="text-15 lh-1 fw-500"><?php echo _("RP0102") ?></h4>
                                        <div class="text-13 lh-1 mt-10"><?php echo $end_date ?></div>
                                    </div>
                                </div>

                                <div class="d-flex items-center py-10 col-md-2">
                                    <div class="d-flex justify-center items-center size-40 rounded-full bg-primary-opacity-1">
                                        <div class="fa fa-building text-16"></div>
                                    </div>
                                    <div class="ml-12">
                                        <h4 class="text-15 lh-1 fw-500"><?php echo _("RP0101") ?></h4>
                                        <div class="text-13 lh-1 mt-10"><?php echo $row_user["name"] ?></div>
                                    </div>
                                </div>
                                <div class="d-flex items-center py-10 col-md-2">
                                    <div class="d-flex justify-center items-center size-40 rounded-full bg-primary-opacity-1">
                                        <div class="fa fa-building text-16"></div>
                                    </div>
                                    <div class="ml-12">
                                        <h4 class="text-15 lh-1 fw-500"><?php echo _("US0152") ?></h4>
                                        <div class="text-13 lh-1 mt-10"><?php echo $department ?></div>
                                    </div>
                                </div>
                                <div class="d-flex items-center py-10 col-md-2">
                                    <div class="d-flex justify-center items-center size-40 rounded-full bg-primary-opacity-1">
                                        <div class="fa fa-cloud text-16"></div>
                                    </div>
                                    <div class="ml-12">
                                        <h4 class="text-15 lh-1 fw-500"><?php echo _("US0115") ?></h4>
                                        <div class="text-13 lh-1 mt-10"><?php echo $designation ?></div>
                                    </div>
                                </div>
                                <div class="d-flex items-center py-10 col-md-2">
                                    <div class="d-flex justify-center items-center size-40 rounded-full bg-primary-opacity-1">
                                        <div class="fa fa-book text-16"></div>
                                    </div>
                                    <div class="ml-12">
                                        <h4 class="text-15 lh-1 fw-500"><?php echo _("US0118") ?></h4>
                                        <div class="text-13 lh-1 mt-10"><?php echo $project ?></div>
                                    </div>
                                </div>
                                <div class="d-flex items-center py-10 col-md-2">
                                    <div class="d-flex justify-center items-center size-40 rounded-full bg-primary-opacity-1">
                                        <div class="fa fa-map-marker text-16"></div>
                                    </div>
                                    <div class="ml-12">
                                        <h4 class="text-15 lh-1 fw-500"><?php echo _("US0119") ?></h4>
                                        <div class="text-13 lh-1 mt-10"><?php echo $location ?></div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>

                    <div class="container bg-white rounded-16 py-20 mt-20">
                        <P class="px-10 text-16 text-color-primary"><i><?php echo _("RP0103") ?></i></P>
                        <div class="d-flex justify-start items-center py-10">
                            <h4 class="text-15 lh-1 fw-500 col-md-2"><?php echo _("RP0105") ?></h4>
                            <div class="d-flex justify-start items-center col-md-3">
                                <label><?php echo _("US0143") ?></label>
                                <form class="contact-form mb-0 ml-5">
                                    <input type="date" class="text-16" autocomplete='off' style="padding: 10px 22px;" id="from_date">
                                    <span class="text-red-1" id="error"><?php echo _("RP0121") ?></span>
                                </form>
                            </div>
                            <div class="d-flex justify-start items-center col-md-3">
                                <label><?php echo _("US0144") ?></label>
                                <form class="contact-form mb-0 ml-5">
                                    <input type="date" class="text-16" autocomplete='off' style="padding: 10px 22px;" id="to_date">
                                    <span class="text-red-1" id="error1"><?php echo _("RP0121") ?></span>
                                </form>
                            </div>

                            <a href="javascript:;" class="button -icon bg-color-primary h-40 text-white px-40 ml-30" id="submit">
                                <i class="fa fa-check text-13 mr-5"></i> <?php echo _("RP0106") ?>
                            </a>
                            <a id="download" href="" class="button -icon bg-color-primary h-40 text-white px-40 ml-30"><i class="fa fa-download text-13 mr-5"></i><?php echo _("CRT2103") ?></a>
                        </div>
                        <div class="text-red-1" id="error2"><?php echo _("RP0130") ?></div>

                        <div id="report_details">
                            <div class="sectionTitle mb-10 text-center mt-30">
                                <h2 class="sectionTitle__title text-20"><?php echo _("RP0107") ?></h2>
                            </div>

                            <div class="table-responsive mt-10">
                                <table class="table_report w-1/1">
                                    <colgroup>
                                        <col style="width:5%">
                                        <col style="width:10%">
                                        <col style="width:10%">
                                        <col style="width:10%">
                                        <col style="width:10%">
                                        <col style="width:10%">
                                        <col style="width:10%">
                                        <col style="width:10%">
                                        <col style="width:10%">
                                        <col style="width:10%">
                                        <col style="width:5%">
                                        <col style="width:5%">
                                    </colgroup>
                                    <thead class="bg-color-primary">
                                        <tr>
                                            <th><?php echo _("RP0131") ?></th>
                                            <th><?php echo _("RP0108") ?></th>
                                            <th><?php echo _("HM0114") ?></th>
                                            <th><?php echo _("RP0109") ?></th>
                                            <th><?php echo _("RP0110") ?></th>
                                            <th><?php echo _("RP0111") ?></th>
                                            <th><?php echo _("RP0112") ?></th>
                                            <th><?php echo _("CRT1109") ?></th>
                                            <th><?php echo _("RP0113") ?></th>
                                            <th><?php echo _("RP0122") ?></th>
                                            <th><?php echo _("RP0114") ?></th>
                                            <th><?php echo _("CR0111") ?>?</th>
                                        </tr>
                                    </thead>
                                    <tbody id="progress">

                                    </tbody>
                                </table>
                            </div>

                            <div class="points">
                                <div class="sectionTitle mb-10 text-center mt-30">
                                    <h2 class="sectionTitle__title text-20"><?php echo _("RP0115") ?></h2>
                                </div>
                                <div class="table-responsive mt-10">
                                    <table class="table_report w-1/1">
                                        <colgroup>
                                            <col style="width:5%">
                                            <col style="width:30%">
                                            <col style="width:30%">
                                            <col style="width:30%">
                                        </colgroup>
                                        <thead class="bg-color-primary">
                                            <tr>
                                                <th><?php echo _("RP0131") ?></th>
                                                <th><?php echo _("RP0116") ?></th>
                                                <th><?php echo _("RP0117") ?></th>
                                                <th><?php echo _("RP0118") ?></th>
                                            </tr>
                                        </thead>
                                        <tbody id="points">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <?php include "./footer_primary.php"; ?>
        </body>
    </html>
<?php } ?>
<script>
    var user = <?php echo $_SESSION['uid']; ?>;
    $('#error').css({"display": "none"});
    $('#error1').css({"display": "none"});
    $('#error2').css({"display": "none"});
    var from_date = $('#from_date').val();
    var to_date = $('#to_date').val();
    var name = $('#name').text();
    submit();
    function submit() {
        var download = "certificate/template/download_report.php?name=" + name + "&from_date=" + from_date + "&to_date=" + to_date + "";
        $("#download").attr("href", download);
        $.ajax({
            url: 'modules/learning_process_report.php',
            data: {"user_id": user, "from_date": from_date, "to_date": to_date},
            type: 'GET',
            dataType: "html",
            contentType: "application/json",
            cache: false,
            async: false,
            success: function (response) {
                var obj = JSON.parse(response);
                $("#progress").empty();
                $("#points").empty();
                if (obj.courses !== "") {
                    $('#progress').append(obj.courses);
                }
                if (obj.points !== "") {
                    $('#points').append(obj.points);
                    if ($('#total_points').text() == 0) {
                        $('.points').hide();
                    } else {
                        $('.points').show();
                    }
                }
                // $('#html').val($('#report_details').html());
                //Dowload button show and Hide
                if ($('#no_result').length) {
                    $('#download').hide();
                } else {
                    $('#download').show();
                }
            }
        });
    }
    $("#submit").click(function (e) {
        e.preventDefault();
        from_date = $('#from_date').val();
        to_date = $('#to_date').val();
        if (from_date != "" && to_date == "") {
            $('#error1').css({"display": "block"});
        } else if (from_date == "" && to_date != "") {
            $('#error').css({"display": "block"});
        } else if (new Date(from_date) > new Date(to_date)) {
            $('#error2').css({"display": "block"});
        } else {
            $('#error').css({"display": "none"});
            $('#error1').css({"display": "none"});
            $('#error2').css({"display": "none"});
            submit();
        }
    });
</script>