<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
// start session
session_start();
if (!isset($_SESSION['uid'])) {
    header("Location: index.php");
} else {
    // connect to database
    include 'config/database.php';
    include_once 'config/properties.php';
    include_once "resources/search.php";
    include_once "resources/EncryptDecrypt.php";
    include_once "resources/manageusers.php";
    // initialize objects
    $search = new Search();
     $users = new ManageUsers();
    // set page title
    $page_title = _("HM0120");
    $page_no = 11;
    $user_id = $_SESSION['uid'];

    $search->user_id = $user_id;
    $search->date = $date;
?>
<!DOCTYPE>
<html lang="en">

<head>
    <?php include "./head.php" ?>
    <link rel="stylesheet" href="assets/css/search/style.css">
    <link id="favicon" rel="shortcut icon" type="image/png" href="" />
    <title><?php echo _("HM0120"); ?></title>
    <style>
        .highlight {
    background-color: yellow;
        }
    </style>
</head>

<body>
    <?php include "./menu_primary.php"; ?>

    <div class="container py-30 x-gap-50 bg-primary-opacity-1 rounded-16 mb-60">

        <div class="row ">

            <div class="sectionTitle justify-center text-center">
                <h2 class="sectionTitle__title "><?php echo _("HM0120"); ?></h2>
                <p class="sectionTitle__text "><?php echo _("SR0102"); ?></p>
            </div>
            <div class="row justify-center text-center">
                <div class="col-xl-6 col-lg-8">
                    <form class="form-single-field -help mb-0" method="get" action="search.php">
                        <input class="text-18" type="text" id="myInput" value="<?php echo htmlspecialchars(trim($_GET['s']), ENT_QUOTES); ?>" name="s" id="s" placeholder="<?php echo _("SR0103");?>" required=""  onblur="this.value = removeSpaces(this.value);" >
                        <button class="button -purple-1 text-white" type="submit">
                            <i class="fa fa-search text-16 mr-10"></i>
                            <?php echo _("HM0120");?>
                        </button>
                    </form>

                    <div class="form-checkbox d-flex items-center ml-5">
                        <div class="checkbox">
                            <input type="checkbox" name="exact" id="exact" <?php if (isset($_GET['exact'])) { ?>checked=""<?php } ?>>
                            <div class="form-checkbox__mark">
                                <div class="form-checkbox__icon icon-check"></div>
                            </div>
                        </div>
                        <div class="text-16 ml-12"><?php echo _("SR0104");?></div>
                    </div>
                </div>
            </div>

            <h3 class="mt-30 pl-5" id="res"></h3>
            <div class="rounded-8 bg-white -dark-bg-dark-1 shadow-4 mt-10" id="search_text">
                <div class="" id="no_search">
                    <h3><?php echo _("ER0101");?></h3>
                </div>
                <!--Active courses-->
                <?php
                $html = "";
                $attempt_no = 0;
                $total_search=0;

                $srch = trim($_GET['s']);

                $construct = '';
                $construct_course = "";
                $construct_lesson = "";
                $construct_content = "";
                $construct_notice_board = "";
                $construct_reference_material = "";

                function escapeJsonString($value) { # list from www.json.org: (\b backspace, \f formfeed)
                    // $escapers = array("\\", "/", "\"", "\n", "\r", "\t", "\x08", "\x0c", "'","(");
                    //  $replacements = array("\\\\", "\\/", "\\\"", "\\n", "\\r", "\\t", "\\f", "\\b", "\'","[(]");
                    $escapers = array("\\", "/", "\"", "'", "(", ".", ")", "|", "+");
                    $replacements = array("[\\]", "[/]", "[\"]", "[\']", "[(]", "[.]", "[)]", "[|]", "[+]");
                    $result = str_replace($escapers, $replacements, $value);
                    return $result;
                }

                if (isset($_GET['exact'])) {

                    $srch = escapeJsonString($srch);

                    //$construct = '[[:<:]]'.$srch.'[[:>:]]';
                    $construct = '([[:blank:][:punct:]]|^)' . $srch . '([[:punct:][:blank:]]|$)';
                } else {
                    //$srch = addslashes($srch);
                    $srch = escapeJsonString($srch);
                    $srch_exploded = explode(" ", $srch);
                    foreach ($srch_exploded as $srch_each) {
                        // $construct .= '[[:<:]]' . $srch_each . '[[:>:]]|';
                        $construct .= '([[:blank:][:punct:]]|^)' . $srch_each . '([[:punct:][:blank:]]|$)|';
                    }
                    $construct = rtrim($construct, '|');
                }

                //Active courses
                $stmt = $search->activecourses();
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {

                    $flag = 0;
                    $check_course = 0;
                    $check_lesson = 0;
                    $check_content = 0;

                    $search->offering_id = $row['offering_id'];
                    $stmt3 = $search->course_search($construct);
                    if ($row3 = $stmt3->fetch(PDO::FETCH_ASSOC)) {
                        $check_course++;
                        $total_search++;
                        $flag = 1;
                        ?>
                
                <div class="d-flex justify-start py-40 border-bottom-dark">
                    <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                        <i class="text-16 fa fa-chevron-right"></i>
                    </div>
                    <div class="px-10">
                        <a href="courseview.php?offering=<?php echo $row['offering_id'] ?>" rel="search_course" class="text-blue-3 text-20 mt-5"><?php echo htmlentities($row['course_name']); ?>
                            (<?php echo _("SR0105")?>)</a>
                        <p class="mt-5" id="course_desc"><?php echo htmlentities($row3['course_description']); ?></p>
                        <?php
                        }

                        $stmt2 = $search->offering_lessons();
                        while ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
                            $search->lesson_id = $row2['lesson_id'];
                            $stmt3 = $search->lesson_search($construct);
                            if ($row3 = $stmt3->fetch(PDO::FETCH_ASSOC)) {
                                if ($check_course == 0) {
                                    $total_search++;
                                    $check_course++;
                                    $check_lesson++;
                                    ?>
                                <div class="d-flex justify-start py-40 border-bottom-dark">
                                    <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                        <?php if ($flag == 0) { ?><i class="text-16 fa fa-chevron-right"></i><?php $flag = 1; }  ?>
                                    </div>
                                <div class="px-10">
                                <?php } ?>
                                    <div class="d-flex justify-start mt-10">
                                        <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                            <i class="text-14 fa fa-chevron-right"></i>
                                        </div>
                                        <div class="px-10 mt-5">
                                            <a href="courseview.php?offering=<?php echo $row['offering_id'] ?>#data_<?php echo $row3['lesson_id']; ?>" rel="search_lesson" class="text-blue-3 text-16">
                                                <span class="bg-yellow-6"><?php echo $row3['lesson_name']; ?></span>
                                                (Lesson)</a>
                                            <p class="mt-5" id="course_desc"><?php echo $row3['lesson_desc']; ?></p>
                                        </div>
                                    </div>
                            <?php
                            }
                            $stmt4 = $search->content_search($construct);
                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                    if ($check_course == 0) {
                                        $total_search++;
                                        $check_course++;
                                        $check_content++;
                                        ?>
                                    <div class="d-flex justify-start py-40 border-bottom-dark">
                                    <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                        <?php if ($flag == 0) { ?><i class="text-16 fa fa-chevron-right"></i><?php $flag = 1; }  ?>
                                    </div>
                                <div class="px-10">
                                <?php } ?>
                                    <div class="d-flex justify-start mt-10">
                                        <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                            <i class="text-14 fa fa-chevron-right"></i>
                                        </div>
                                        <div class="px-10 mt-5">
                                            <a href="courseview.php?offering=<?php echo $row['offering_id'] ?>#content" rel="search_lesson" class="text-blue-3 text-16">
                                                <span class="bg-yellow-6"><?php echo $row4['content_title']; ?></span>
                                                (Lesson)</a>
                                            <p class="mt-5" id="course_desc"><?php echo $row4['content_desc']; ?></p>
                                        </div>
                                    </div>
                                    <?php
                                                }
                                            }
                                            if ($check_content != 0) {
                                                ?>
                                            </div>
                                        </div>
                                        <?php
                                    } else if ($check_lesson != 0) {
                                        ?>
                                    </div>
                                </div>
                                <?php
                            } else if ($check_course != 0) {
                                ?>
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
               <!--Completed courses-->
               <?php
               $stmt_completed = $search->completedcourses();
                while ($row_completed = $stmt_completed->fetch(PDO::FETCH_ASSOC)) {
                    $flag = 0;
                    $end_date = $row_completed['end_date'];
                    $check_course = 0;
                    $check_lesson = 0;
                    $check_content = 0;

                    $search->offering_id = $row_completed['offering_id'];
                    $stmt3 = $search->course_search($construct);
                    if ($row3 = $stmt3->fetch(PDO::FETCH_ASSOC)) {
                        $total_search++;
                        $check_course++;
                        $flag = 1;
                        ?>
                        <div class="d-flex justify-start py-40 border-bottom-dark">
                            <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                <i class="text-16 fa fa-chevron-right"></i>
                            </div>
                            <div class="px-10">
                                <a href="courseview.php?offering=<?php echo $row_completed['offering_id'] ?>" rel="search_course" class="text-blue-3 text-20 mt-5"><?php echo $row3['course_name']; ?> (<?php echo _("SR0106")?>)</a>
                                <p class="mt-5" id="course_desc"><?php echo htmlentities($row3['course_description']); ?></p>
                    <?php
                    }
                    $stmt2 = $search->offering_lessons();
                    while ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
                        $search->lesson_id = $row2['lesson_id'];
                        $stmt3 = $search->lesson_search($construct);
                            if ($row3 = $stmt3->fetch(PDO::FETCH_ASSOC)) {
                                if ($check_course == 0) {
                                    $check_lesson++;
                                    $total_search++;
                                    $check_course++;
                    ?>
                    <div class="d-flex justify-start py-40 border-bottom-dark">
                        <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                            <?php if ($flag == 0) { ?><i class="text-16 fa fa-chevron-right"></i><?php $flag = 1; }  ?>
                        </div>
                    <div class="px-10">
                                <?php } ?> 
                        <div class="d-flex justify-start mt-10">
                                <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                    <i class="text-14 fa fa-chevron-right"></i>
                                </div>
                                <div class="px-10 mt-5">
                                    <a href="courseview.php?offering=<?php echo $row_completed['offering_id'] ?>#data_<?php echo $row3['lesson_id']; ?>" rel="search_lesson" class="text-blue-3 text-16">
                                        <span class="bg-yellow-6"><?php echo $row3['lesson_name']; ?></span>
                                        (Lesson)</a>
                                        <p class="mt-5" id="course_desc"><?php echo htmlentities($row3['lesson_desc']); ?></p>
                                </div>
                        </div>
                        <?php
                            }

                            $stmt4 = $search->content_search($construct);
                            while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                if ($check_course == 0) {
                                    $total_search++;
                                    $check_course++;
                                    $check_content++;
                        ?>
                        <div class="d-flex justify-start py-40 border-bottom-dark">
                            <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                <?php if ($flag == 0) { ?><i class="text-16 fa fa-chevron-right"></i><?php $flag = 1; }  ?>
                            </div>
                            <div class="px-10">
                                <?php } ?> 
                                <div class="d-flex justify-start mt-10">
                                    <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                        <i class="text-14 fa fa-chevron-right"></i>
                                    </div>
                                    <div class="px-10 mt-5">
                                        <a href="courseview.php?offering=<?php echo $row_completed['offering_id'] ?>#content" rel="search_content" class="text-blue-3 text-16">
                                        <span class="bg-yellow-6"><?php echo $row4['content_title']; ?></span>
                                        (Lesson)</a>
                                        <p class="mt-5" id="course_desc"><?php echo htmlentities($row4['content_desc']); ?></p>
                                    </div>
                                </div>
                                <?php 
                                    }
                                }if ($check_content != 0) { ?>
                                    </div>
                                </div>
                            <?php } else if ($check_lesson != 0) { ?>
                                    </div>
                                </div>
                           <?php } else if ($check_course != 0) { ?>
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
               <!--Incompleted courses-->
                <?php
                $stmt_incomplete = $search->incompletecourses();
                while ($row_incomplete = $stmt_incomplete->fetch(PDO::FETCH_ASSOC)) {
                    $flag = 0;
                    $end_date = $row_incomplete['end_date'];
                    $check_course = 0;
                    $check_lesson = 0;
                    $check_content = 0;

                    $search->offering_id = $row_incomplete['offering_id'];
                    $stmt3 = $search->course_search($construct);
                    if ($row3 = $stmt3->fetch(PDO::FETCH_ASSOC)) {
                        $total_search++;
                        $check_course++;
                        $flag = 1;
                        ?>
                        <div class="d-flex justify-start py-40 border-bottom-dark">
                            <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                <i class="text-16 fa fa-chevron-right"></i>
                            </div>
                            <div class="px-10">
                                <a href="courseview.php?offering=<?php echo $row_incomplete['offering_id'] ?>" rel="search_course" class="text-blue-3 text-20 mt-5"><?php echo $row_incomplete['course_name']; ?> (<?php echo _("SR0107")?>)</a>
                                <p class="mt-5" id="course_desc"><?php echo htmlentities($row_incomplete['course_description']); ?></p>
                            <?php
                            }
                            $stmt2 = $search->offering_lessons();
                            while ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {

                                $search->lesson_id = $row2['lesson_id'];
                                $stmt4 = $search->lesson_search($construct);
                                if ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {

                                    if ($check_course == 0) {
                                        $check_lesson++;
                                        $total_search++;
                                        $check_course++;
                                        ?>
                                <div class="d-flex justify-start py-40 border-bottom-dark">
                                    <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                        <?php if ($flag == 0) { ?><i class="text-16 fa fa-chevron-right"></i><?php $flag = 1; }  ?>
                                    </div>
                                <div class="px-10">
                                            <?php } ?> 
                                    <div class="d-flex justify-start mt-10">
                                            <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                                <i class="text-14 fa fa-chevron-right"></i>
                                            </div>
                                            <div class="px-10 mt-5">
                                                <a href="courseview.php?offering=<?php echo $row_incomplete['offering_id'] ?>#data_<?php echo $row4['lesson_id']; ?>" rel="search_lesson" class="text-blue-3 text-16">
                                                    <span class="bg-yellow-6"><?php echo $row4['lesson_name']; ?></span>
                                                    (Lesson)</a>
                                                    <p class="mt-5" id="course_desc"><?php echo htmlentities($row4['lesson_desc']); ?></p>
                                            </div>
                                    </div>
                                    <?php
                                        }
                                        $stmt4 = $search->content_search($construct);
                                        while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                            if ($check_course == 0) {
                                                $total_search++;
                                                $check_course++;
                                                $check_content++;
                                                ?>
                                                <div class="d-flex justify-start py-40 border-bottom-dark">
                                                    <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                                        <?php if ($flag == 0) { ?><i class="text-16 fa fa-chevron-right"></i><?php $flag = 1; }  ?>
                                                    </div>
                                                    <div class="px-10">
                                                        <?php } ?> 
                                                        <div class="d-flex justify-start mt-10">
                                                            <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                                                <i class="text-14 fa fa-chevron-right"></i>
                                                            </div>
                                                            <div class="px-10 mt-5">
                                                                <a href="courseview.php?offering=<?php echo $row_incomplete['offering_id'] ?>#content" rel="search_content" class="text-blue-3 text-16">
                                                                <span class="bg-yellow-6"><?php echo $row4['content_title']; ?></span>
                                                                (Lesson)</a>
                                                                <p class="mt-5" id="course_desc"><?php echo htmlentities($row4['content_desc']); ?></p>
                                                            </div>
                                                        </div>
                                                        <?php
                                                }
                                            }if ($check_content != 0) {
                                                ?>
                                            </div>
                                        </div>
                                        <?php
                                    } else if ($check_lesson != 0) {
                                        ?>
                                    </div>
                                </div>
                                <?php
                            } else if ($check_course != 0) {
                                ?>
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
               <!--Notice Board-->
                <?php
                $stmt = $search->notices($construct);
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    $total_search++;
                    ?>
                <div class="d-flex justify-start py-40 border-bottom-dark">
                    <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                        <i class="text-16 fa fa-chevron-right"></i>
                    </div>
                    <div class="px-10">
                        <a href="announcement.php#notice_board_<?php echo $row['notice_board_id']; ?>" rel="search_course" class="text-blue-3 text-20 mt-5"><span class="bg-yellow-6"><?php echo $row['notice_subject']; ?></span>
                            (Announcement)</a>
                        <p class="mt-5" id="course_desc"><?php echo htmlentities($row['notice_desc']); ?></p>
                    </div>
                </div>
                <?php } ?>
                
               <!--Reference material-->
               <?php
               //Reference materials
                $stmt = $search->referencematerials($construct);
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    $total_search++;
                    ?>
                    <div class="d-flex justify-start py-40 border-bottom-dark">
                        <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                            <i class="text-16 fa fa-chevron-right"></i>
                        </div>
                        <div class="px-10">
                            <a href="references.php#reference_material_<?php echo $row['reference_material_id']; ?>" rel="search_course" class="text-blue-3 text-20 mt-5">
                                <span class="bg-yellow-6"><?php echo $row['reference_title']; ?></span>
                                (<?php echo _("RM0101")?>)</a>
                            <p class="mt-5" id="course_desc"><?php echo htmlentities($row['reference_desc']); ?></p>
                        </div>
                    </div>
                <?php } ?>
               <!--Discussion Form-->
               <?php
                $stmt_disc_form = $search->forum_topics();
                while ($row_disc_form = $stmt_disc_form->fetch(PDO::FETCH_ASSOC)) {
                    $check_topic = 0;
                    $check_reply = 0;
                    $flag = 0;

                    $search->topic_id = $row_disc_form['topic_id'];
                    $stmt_topic = $search->topic_search($construct);
                    if ($row_topic = $stmt_topic->fetch(PDO::FETCH_ASSOC)) {
                        $check_topic++;
                        $total_search++;
                        $flag = 1;
                        ?>
                        <div class="d-flex justify-start py-20 border-bottom-dark">
                            <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                <i class="text-16 fa fa-chevron-right"></i>
                            </div>
                            <div class="px-10">
                                <h5 class="mt-5">Question - Discussion Forum :</h5>
                                <a href="forum.php#forum_topic_<?php echo $row_topic['topic_id']; ?>" rel="search_topic" class="text-blue-3 text-20 mt-5"><?php echo htmlentities($row_topic['topic_desc']); ?></a>
                                <?php
                            }
                            $stmt_reply = $search->topic_response_search($construct);
                            while ($row_reply = $stmt_reply->fetch(PDO::FETCH_ASSOC)) {
                                if ($check_topic == 0) {
                                    $check_topic++;
                                    $total_search++;
                                    $check_reply++;
                                    ?>
                                <div class="d-flex justify-start mt-10">
                                    <div class="text-center rounded-8 px-8 py-8 bg-light-3" style="height: fit-content;">
                                        <?php if ($flag == 0) { ?><i class="text-14 fa fa-chevron-right"></i><?php $flag = 1; } ?>
                                    </div>
                                    <div class="px-10">
                                        <?php } ?> 
                                        <h5 class="mt-5">Reply - Discussion Forum :</h5>
                                        <a href="forum.php#forum_response_<?php echo $row_reply['response_id']; ?>" rel="search_reply" class="text-blue-3 text-16"><?php echo htmlentities($row_reply['response_desc']); ?></a>
                                          <?php
                                    }
                                    if ($check_reply != 0) {
                                        ?>
                                    </div>
                                </div>
                                <?php
                            } else if ($check_topic != 0) {
                                ?>
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
        </div>

    </div>
    <?php include "./footer_primary.php"; ?>
    <script type='text/javascript' src="assets/js/jquery.highlight.js"></script>
    <script type="text/javascript">
         $('#res').html("<?php echo $total_search; ?> <?php echo _("SR0108") ?>: &quot;<?php echo htmlspecialchars($_GET['s'], ENT_QUOTES); ?>&quot;");
         var total_search = <?php echo $total_search ?>;
            if(total_search !== 0){
                 $('#no_search').css({"display": "none"});
                 $('#no_search').removeClass('d-flex justify-center py-50');
            }else{
                $('#no_search').addClass('d-flex justify-center py-50');
                $('#no_search').css({"display": "block"});
            }
        
        
         (function ($) {
            $('#search_text p').each(function () {
                var search_value = "<?php echo $_GET['s']; ?>";
                if ($('#exact').prop("checked") == true) {
                    if (/^[a-zA-Z0-9- ]*$/.test(search_value) == false) {
                        $(this).highlight(search_value);
                    } else {
                        $(this).highlight(search_value, {
                            wordsOnly: true, wordsBoundary: '\\b\\W*'
                        });
                    }
                } else {
                    var list = new Array();
                    var array = search_value.split(' ');
                    $.each(array, function (i) {
                        list.push(array[i]);
                    });
                    $(this).highlight(list, {wordsOnly: true, wordsBoundary: '\\b\\W*'});
                }
            });

            $('#search_text a').each(function () {
                var search_value = "<?php echo $_GET['s']; ?>";
                if ($('#exact').prop("checked") == true) {
                    if (/^[a-zA-Z0-9- ]*$/.test(search_value) == false) {
                        $(this).highlight(search_value);
                    } else {
                        $(this).highlight(search_value, {
                            wordsOnly: true, wordsBoundary: '\\b\\W*'
                        });
                    }
                } else {
                    var list = new Array();
                    var array = search_value.split(' ');
                    $.each(array, function (i) {
                        list.push(array[i]);
                    });
                    $(this).highlight(list, {wordsOnly: true, wordsBoundary: '\\b\\W*'});
                }
            });

//            $('.discussion_form small').each(function () {
//                var search_value = "<?php echo $_GET['s']; ?>";
//                if ($('#exact').prop("checked") == true) {
//                    if (/^[a-zA-Z0-9- ]*$/.test(search_value) == false) {
//                        $(this).highlight(search_value);
//                    } else {
//                        $(this).highlight(search_value, {
//                            wordsOnly: true, wordsBoundary: '\\b\\W*'
//                        });
//                    }
//                } else {
//                    var list = new Array();
//                    var array = search_value.split(' ');
//                    $.each(array, function (i) {
//                        list.push(array[i]);
//                    });
//                    $(this).highlight(list, {wordsOnly: true, wordsBoundary: '\\b\\W*'});
//                }
//            });
        })(jQuery);

    </script>
</body>

</html>
<?php } ?>