<?php
include_once "config/database.php";
include_once 'config/properties.php';
include_once "resources/assessment.php";
include_once "resources/offering.php";
include_once "resources/EncryptDecrypt.php";
include_once "resources/manageusers.php";

// initialize objects
$assessment = new Assessment();
$offering = new Offering();
$users = new ManageUsers();
$mcrypt = new MCrypt();
if (!isset($_GET['user'])) {
    header('Location: 404.php');
}

$user = $_GET['user'];

$encrypted = $mcrypt->decrypt($user);
$arr = explode('&', $encrypted, 3);
$id = $arr[0];
$oid = $arr[1];
$attm = $arr[2];

$final_res = null;
$res = null;
$per = null;
$pass_score = null;
$max_attm = null;
$score_flag = null;
$is_scorm = null;
$course_id = null;

$offering->offering_id = $oid;
$assessment->offering_id = $oid;

$aid = $assessment->get_assessmentno();

$offering->user_id = $id;
$offering->assessment_id = $aid;

$assessment->offering_id = $oid;
$assessment->attempt_no = $attm;
$assessment->user_id = $id;
$assessment->assessment_id = $aid;

$stmt = $assessment->get_score();
if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    extract($row);
    $per = $score;
}
$stmt = $assessment->get_result();
if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    extract($row);
    $final_res = $result;
}
$stmt = $assessment->get_offer_detail();
if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    extract($row);
    $pass_score = $passing_score;
    $max_attm = $max_attempts;
    $is_scorm = $is_scorm;
    $score_flag = $score_flag;
    $course_id = $course_id;
}
if ($per >= $pass_score) {
    $res = "Pass";
} else {
    $res = "Fail";
}
$remaining_attempts = $max_attm - $attm;
?>
<html>
    <head>
        <?php include "./head.php" ?>
        <title>
            Report
        </title>
        <link rel="stylesheet" href="assets/css/assessment/style.css">
    </head>
    <body>
        <?php include "./menu_secondary.php" ?>
        <input type="hidden" id="res" value="<?php echo $res; ?>" /> 
        <input type="hidden" id="attm_ex" value="<?php echo $max_attm - $attm; ?>" /> 
        <input type="hidden" id="oid" value="<?php echo $oid; ?>" /> 
        <input type="hidden" id="is_scorm" value="<?php echo $is_scorm; ?>" /> 

        <div class="container py-10 x-gap-40 bg-light-9 rounded-8 mb-50 mt-20">
            <div class="row y-gap-30 mb-0">

                <div class="col-xl-12 col-lg-12 px-0">
                    <div class="rounded-8 bg-white -dark-bg-dark-1 shadow-4 px-30 pb-30">

                        <div class="d-flex justify-center items-center py-10 border-bottom-light">
                            <h3 class="lh-1 fw-500"><?php echo _("CRT4109") ?></h3>
                        </div>
                        <?php if ($res == "Pass") { ?>
                            <div class="text-center items-center py-5">
                                <h3 class="w-1/1 lh-1 fw-500 text-green-1"><?php echo _("AS0201"); ?></h3>
                                <h4 class="w-1/1 lh-1 fw-500 mt-15"><?php echo _("AS0202"); ?></h4>
                            </div>
                        <?php } else { ?>
                            <div class="text-center items-center py-5">
                                <h3 class="w-1/1 lh-1 fw-500 text-red-1"><?php echo _("AS0101") ?></h3>
                                <?php
                                if ($attm == $max_attm) {
                                    $msg = _("AS0102");
                                } else {
                                    $msg = _("AS0103");
                                }
                                ?>
                                <h4 class="w-1/1 lh-1 fw-500 mt-15"><?php echo $msg ?></h4>
                            </div>
                        <?php } ?>

                        <?php if ($score_flag == "Yes") { ?>
                            <div class="d-flex justify-center">
                                <div class="col-md-4 text-center py-10">
                                    <div class="progress mb-0">
                                        <div class="progress-bar <?php if ($result == "pass") { ?>progress-bar-danger<?php } else { ?>progress-bar-success<?php } ?>" role="progressbar" aria-valuenow="<?php echo $per ?>"
                                             aria-valuemin="0" aria-valuemax="100" style="width:<?php echo $per ?>%">
                                        </div>
                                    </div>
                                    <div class="text-black mt-5"><?php echo $per ?>% <?php _("CR0110"); ?></div>
                                </div>
                            </div>
                        <?php } ?>

                        <div class="d-flex justify-center">
                            <div class="d-flex justify-between items-end text-dark-3 border-light rounded-8 py-10 px-30">
                                <div class="text-14 text-black"><?php echo _("CRT3105") ?> : <?php echo $max_attm ?></div>
                            </div>
                            <div
                                class="d-flex justify-between items-end text-dark-3 border-light rounded-8 py-10 px-20 ml-10">
                                <div class="text-14 text-black"><?php echo _("AS0134") ?> : <?php echo $remaining_attempts ?></div>
                            </div>
                        </div>

                        <h3 class="lh-1 fw-500 text-center"><?php echo _("TB104"); ?></h3>
                        <div class="table-responsive mt-10">
                            <table class="result_table w-1/1">
                                <colgroup>
                                    <col style="width:20%">
                                    <col style="width:15%">
                                    <col style="width:10%">
                                    <col style="width:15%">
                                    <col style="width:10%">
                                    <col style="width:10%">
                                    <col style="width:10%">
                                    <col style="width:10%">
                                </colgroup>
                                <thead>
                                    <tr>
                                        <th><?php echo _("CRT4103"); ?></th>
                                        <th><?php echo _("CRT4102"); ?></th>
                                        <th><?php echo _("CRT4104"); ?></th>
                                        <th><?php echo _("CRT4105"); ?>(%)</th>
                                        <th><?php echo _("CRT4106"); ?>(%)</th>
                                        <th><?php echo _("CRT4107"); ?></th>
                                        <?php if ($score_flag == "Yes") { ?>
                                            <th><?php echo _("CRT4108"); ?>(%)</th>
                                        <?php } ?>
                                        <th><?php echo _("CRT4109"); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stmt = $offering->get_assessment_score_card();
                                    if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                        extract($row);
                                        $stmt_assemnt_attempt = $offering->offering_current_attempt();
                                        if ($row_assemnt_attempt = $stmt_assemnt_attempt->fetch(PDO::FETCH_ASSOC)) {
                                            extract($row_assemnt_attempt);
                                            if ($attempt_no == "") {
                                                $attempt_no = "Not attempted";
                                            }
                                        }
                                        $stmt1 = $offering->get_user_score();
                                        if ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {
                                            extract($row1);
                                            $score1 = $score;
                                            if ($score1 >= $passing_score) {
                                                $result1 = 'Pass';
                                            } else {
                                                $result1 = 'Fail';
                                            }
                                        } else {
                                            $score1 = 'Not attempted';
                                            $result1 = 'Not attempted';
                                        }
                                        ?>
                                        <tr class="bg-white shadow-1 rounded-8 border-light">
                                            <td><?php echo htmlentities($assessment_name) ?></td>
                                            <td>
                                                <div class="about-content">
                                                    <div class="bg-green-2 about-content-list__icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                             viewBox="0 0 24 24" fill="none" stroke="#000" stroke-width="2"
                                                             stroke-linecap="round" stroke-linejoin="round"
                                                             class="fa fa-check icon">
                                                        <polyline points="20 6 9 17 4 12">
                                                        </polyline>
                                                        </svg>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <span
                                                    class="text-11 rounded-16 text-black bg-blue-6 py-5 px-5">Assessment</span>
                                            </td>
                                            <td>
                                                <?php echo htmlentities($pass_score) ?>
                                            </td>
                                            <td>
                                                <?php echo htmlentities($weightage) ?>
                                            </td>
                                            <td>
                                                <?php echo htmlentities($attempt_no) ?>
                                            </td>
                                            <?php if ($score_flag == "Yes") { ?>
                                                <td>
                                                    <?php echo $score1; ?>
                                                </td>
                                            <?php }  
                                            $con_bg = $result1 == "Pass" ? "bg-green-2" : "bg-red-2"; ?>
                                            <td>
                                                <span
                                                    class="text-11 rounded-16 text-blue-3 <?php echo $con_bg?> py-5 px-5"><?php echo $result1 ?></span>
                                            </td>
                                        </tr>
                                    <?php } ?>

                                    <?php
                                    $stmt_scorm = $offering->get_scorm_score_card();
                                    if ($stmt_scorm->rowCount() > 0) {
                                        while ($row_scorm = $stmt_scorm->fetch(PDO::FETCH_ASSOC)) {
                                            extract($row_scorm);
                                            $offering->scorm_id = $scorm_id;
                                            ?>

                                            <tr class="bg-white shadow-2 rounded-8 border-light">
                                                <?php
                                                $stmt_scorm1 = $offering->get_scorm_score_card_considered();
                                                if ($row_scorm1 = $stmt_scorm1->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row_scorm1);
                                                    ?>
                                                    <td><?php htmlentities($content_title) ?></td>
                                                    <td>
                                                        <div class="about-content">
                                                            <div class="bg-green-2 about-content-list__icon">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                     viewBox="0 0 24 24" fill="none" stroke="#000" stroke-width="2"
                                                                     stroke-linecap="round" stroke-linejoin="round"
                                                                     class="fa fa-check icon">
                                                                <polyline points="20 6 9 17 4 12">
                                                                </polyline>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="text-11 rounded-16 text-black bg-blue-6 py-5 px-5">Interactive Video</span>
                                                    </td>
                                                    <td>
                                                        <?php echo $mastery_score ?>
                                                    </td>
                                                    <td>
                                                        <?php echo $weightage ?>
                                                    </td>


                                                <?php } else { ?>
                                                    <td><?php htmlentities($content_title) ?></td>
                                                    <td>
                                                        <div class="about-content">
                                                            <div class="bg-red-2 about-content-list__icon">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                     viewBox="0 0 24 24" fill="none" stroke="#000" stroke-width="2"
                                                                     stroke-linecap="round" stroke-linejoin="round" class="fa fa-x icon">
                                                                <line x1="18" y1="6" x2="6" y2="18"></line>
                                                                <line x1="6" y1="6" x2="18" y2="18"></line>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="text-11 rounded-16 text-black bg-blue-6 py-5 px-5">Interactive Video</span>
                                                    </td>
                                                    <td>
                                                        <?php echo $mastery_score ?>
                                                    </td>
                                                    <td>
                                                        ---
                                                    </td>

                                                <?php } ?>
                                                <td> --- </td>


                                                <?php if ($score_flag == "Yes") { ?>
                                                    <td>
                                                        <?php
                                                        $stmt_scorm2 = $offering->get_scorm_score_user();
                                                        if ($row_scorm2 = $stmt_scorm2->fetch(PDO::FETCH_ASSOC)) {
                                                            extract($row_scorm2);
                                                            if ($value != "") {
                                                                echo $value;
                                                            } else {
                                                                echo '---';
                                                            }
                                                        } else {
                                                            echo 'Not attempted';
                                                        }
                                                        ?>
                                                    </td>
                                                <?php } ?>
                                                <td>
                                                    <?php
                                                    $stmt_scorm2 = $offering->get_scorm_lesson_status_user();
                                                    if ($row_scorm2 = $stmt_scorm2->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row_scorm2);
                                                        $value = $value;
                                                    } else {
                                                        $value = "Not attempted";
                                                    }
                                                     if ($value == "completed" || $value == "passed") {
                                                                    ?>
                                                                    <span
                                                                        class="text-11 rounded-16 text-blue-3 lh-2 bg-green-2 py-5 px-5"><?php echo $value ?></span>
                                                                    <?php } else if($value == "Not attempted"){ ?>
                                                                    <span
                                                                        class="text-11 rounded-16 text-black lh-2 bg-blue-2 py-5 px-5"><?php echo $value ?></span>
                                                                    <?php } else { ?>
                                                                    <span
                                                                        class="text-11 rounded-16 text-blue-3 lh-2 bg-red-2 py-5 px-5"><?php echo $value ?></span>
                                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                    }
                                    ?>
                                                 <!--xapi-->
                                                <?php
                                                $stmt_xapi = $offering->get_xapi_score_card();
                                                if ($stmt_xapi->rowCount() > 0) {
                                                    while ($row_xapi = $stmt_xapi->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row_xapi);
                                                        $offering->xapi_id = $xapi_id;
                                                        ?>

                                                        <tr class="bg-white shadow-2 rounded-8 border-light">
                                                            <?php
                                                            $stmt_xapi1 = $offering->get_xapi_score_card_considered();
                                                            if ($row_xapi1 = $stmt_xapi1->fetch(PDO::FETCH_ASSOC)) {
                                                                extract($row_xapi1);
                                                                ?>
                                                                <td><?php echo htmlentities($content_title) ?></td>
                                                                <td>
                                                                    <div class="about-content">
                                                                        <div class="bg-green-2 about-content-list__icon">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                                 viewBox="0 0 24 24" fill="none" stroke="#000" stroke-width="2"
                                                                                 stroke-linecap="round" stroke-linejoin="round"
                                                                                 class="fa fa-check icon">
                                                                            <polyline points="20 6 9 17 4 12">
                                                                            </polyline>
                                                                            </svg>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <span class="text-11 rounded-16 text-black bg-blue-6 py-5 px-5"><?php echo _("CRT2106") ?></span>
                                                                </td>
                                                                <td>
                                                                    <?php // $stmt_xapis = $offering->get_xapi_score_status_user();
//                                                                    if ($row_xapis = $stmt_xapis->fetch(PDO::FETCH_ASSOC)) {
//                                                                    extract($row_xapis);
//                                                                        if($status == "passed" || $status == "failed" || $status == "completed" || $status == "incomplete"){?>
                                                                      <?php // echo $min_score; ?>     
                                                                      <?php // }else{ ?>
                                                                        <?php // echo ""; 
//                                                                            } 
//                                                                    } else { 
//                                                                          echo ""; 
//                                                                    } ?>
                                                                    <?php echo _("HM0119"); ?> 
                                                                </td>
                                                                <td>
                                                                    <?php echo $weightage ?>
                                                                </td>


                                                            <?php } else { ?>
                                                                <td><?php echo htmlentities($content_title) ?></td>
                                                                <td>
                                                                    <div class="about-content">
                                                                        <div class="bg-red-2 about-content-list__icon">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                                 viewBox="0 0 24 24" fill="none" stroke="#000" stroke-width="2"
                                                                                 stroke-linecap="round" stroke-linejoin="round" class="fa fa-x icon">
                                                                            <line x1="18" y1="6" x2="6" y2="18"></line>
                                                                            <line x1="6" y1="6" x2="18" y2="18"></line>
                                                                            </svg>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <span class="text-11 rounded-16 text-black bg-blue-6 py-5 px-5">Interactive Video</span>
                                                                </td>
                                                                <td>
                                                                   <?php echo _("HM0119"); ?>
                                                                </td>
                                                                <td>
                                                                    ---
                                                                </td>

                                                            <?php } ?>
                                                            <td> --- </td>


                                                            <?php if ($score_flag == "Yes") { ?>
                                                                <td>
                                                                    <?php
                                                                    $stmt_xapi2 = $offering->get_xapi_score_user();
                                                                    if ($row_xapi2 = $stmt_xapi2->fetch(PDO::FETCH_ASSOC)) {
                                                                        extract($row_xapi2);
                                                                        if($actual_score !=0){
                                                                            if ($score_max != 0 && $score_max !=100) {
                                                                                $xs=($actual_score*100)/$score_max; 
                                                                                echo $xs;
                                                                            } else {
                                                                                echo $actual_score;
                                                                            }
                                                                        }else{
                                                                            echo '---';
                                                                        }
                                                                    } else {
                                                                        echo 'Not attempted';
                                                                    }
                                                                    ?>
                                                                </td>
                                                            <?php } ?>
                                                            <td>
                                                                <?php
                                                                $stmt_xapi3 = $offering->get_xapi_lesson_status_user();
                                                                if ($row_xapi3 = $stmt_xapi3->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_xapi3);
                                                                    $value1 = $status;
                                                                } else {
                                                                    $value1 = "Not attempted";
                                                                }
                                                                if($xapi_batch == "W"){ ?>
                                                                <span
                                                                        class="text-11 rounded-16 lh-2 text-black bg-blue-2 py-5 px-5">Awaited</span>    
                                                              <?php  }else if ($value1 == "completed" || $value1 == "passed") {
                                                                    ?>
                                                                    <span
                                                                        class="text-11 rounded-16 lh-2 text-blue-3 bg-green-2 py-5 px-5"><?php echo $value1 ?></span>
                                                                <?php } else if($value1 == "failed" || $value1 == "incomplete"){ ?>
                                                                    <span
                                                                        class="text-11 rounded-16 lh-2 text-blue-3 bg-red-2 py-5 px-5"><?php echo $value1 ?></span>
                                                                    <?php } else{?>
                                                                        <span
                                                                        class="text-11 rounded-16 lh-2 text-black bg-blue-2 py-5 px-5"><?php echo $value1 ?></span>
                                                                    <?php } ?>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                               <!--//LTI-->
                                                <?php
                                                $stmt_lti = $offering->get_lti_score_card();
                                                if ($stmt_lti->rowCount() > 0) {
                                                    while ($row_lti = $stmt_lti->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row_lti);
                                                        $offering->lti_id = $lti_id;
                                                        $stmt_grade = $offering->get_gradeitem();
                                                        if ($stmt_grade->rowCount() > 0) {
                                                        ?>

                                                        <tr class="bg-white shadow-2 rounded-8 border-light">
                                                            <?php
                                                            $stmt_lti1 = $offering->get_lti_score_card_considered();
                                                            if ($row_lti1 = $stmt_lti1->fetch(PDO::FETCH_ASSOC)) {
                                                                extract($row_lti1);
                                                                ?>
                                                                <td><?php echo htmlentities($content_title) ?></td>
                                                                <td>
                                                                    <div class="about-content">
                                                                        <div class="bg-green-2 about-content-list__icon">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                                 viewBox="0 0 24 24" fill="none" stroke="#000" stroke-width="2"
                                                                                 stroke-linecap="round" stroke-linejoin="round"
                                                                                 class="fa fa-check icon">
                                                                            <polyline points="20 6 9 17 4 12">
                                                                            </polyline>
                                                                            </svg>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <span class="text-11 rounded-16 text-black bg-blue-6 py-5 px-5"><?php echo _("CRT2106") ?></span>
                                                                </td>
                                                                <td>
                                                                     <?php
                                                                    $stmt_gt = $offering->get_gradeitem();
                                                                    if ($row_gt = $stmt_gt->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_gt);
                                                                        echo $grade_pass; 
                                                                    }else{
                                                                        echo "---"; 
                                                                    }
                                                                ?>
                                                                </td>
                                                                <td>
                                                                    <?php echo $weightage ?>
                                                                </td>


                                                            <?php } else { ?>
                                                                <td><?php echo htmlentities($content_title) ?></td>
                                                                <td>
                                                                    <div class="about-content">
                                                                        <div class="bg-red-2 about-content-list__icon">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                                 viewBox="0 0 24 24" fill="none" stroke="#000" stroke-width="2"
                                                                                 stroke-linecap="round" stroke-linejoin="round" class="fa fa-x icon">
                                                                            <line x1="18" y1="6" x2="6" y2="18"></line>
                                                                            <line x1="6" y1="6" x2="18" y2="18"></line>
                                                                            </svg>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <span class="text-11 rounded-16 text-black bg-blue-6 py-5 px-5">Interactive Video</span>
                                                                </td>
                                                                <td>
                                                                     <?php
                                                                    $stmt_gt = $offering->get_gradeitem();
                                                                    if ($row_gt = $stmt_gt->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_gt);
                                                                        echo $grade_pass; 
                                                                    }else{
                                                                        echo "---"; 
                                                                    }
                                                                ?>
                                                                </td>
                                                                <td>
                                                                    ---
                                                                </td>

                                                            <?php } ?>
                                                            <td> --- </td>


                                                            <?php 
                                                                  $raw_grade = "";
                                                        $lti_attempted = "N";
                                                        $stmt_track = $offering->check_content_track();
                                                        if ($stmt_track->rowCount() > 0) {
                                                            $lti_attempted = "Y";
                                                        }
                                                            if ($score_flag == "Yes") { ?>
                                                                <td>
                                                                    <?php
                                                                    $stmt_lti2 = $offering->get_lti_score_user();
                                                                    if ($row_lti2 = $stmt_lti2->fetch(PDO::FETCH_ASSOC)) {
                                                                        extract($row_lti2);
                                                                        if($raw_grade !=0){
//                                                                            if ($raw_grade_max != 0 && $raw_grade_max !=100) {
//                                                                                 $xs=round((($raw_grade*100)/$raw_grade_max),2);
//                                                                                echo $xs;
//                                                                            } else {
                                                                                echo $raw_grade;
//                                                                            }
                                                                        }else{
                                                                            if($lti_attempted == 'Y'){
                                                                                echo 'Awaited';
                                                                            }else{
                                                                                echo 'Not attempted';
                                                                            }
                                                                        }
                                                                    } else {
                                                                        echo 'Not attempted';
                                                                    }
                                                                    ?>
                                                                </td>
                                                            <?php } ?>
                                                            <td>
                                                                <?php
                                                                $stmt_lti3 = $offering->get_lti_lesson_status_user();
                                                                if ($row_lti3 = $stmt_lti3->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_lti3);
                                                                    if($raw_grade >= $grade_pass ){
                                                                        $value1 = "Completed";
                                                                    }else{
                                                                        $value1 = "incomplete";
                                                                    }
                                                                } else {
                                                                   if($lti_attempted == 'Y'){
                                                                        $value1 = 'Awaited';
                                                                    }else{
                                                                        $value1 ='Not attempted';
                                                                    }
                                                                }
                                                                if ($value1 == "completed") {
                                                                    ?>
                                                                    <span
                                                                        class="text-11 rounded-16 lh-2 text-blue-3 bg-green-2 py-5 px-5"><?php echo $value1 ?></span>
                                                                <?php } else if($value1 == "incomplete"){ ?>
                                                                    <span
                                                                        class="text-11 rounded-16 lh-2 text-blue-3 bg-red-2 py-5 px-5"><?php echo $value1 ?></span>
                                                                    <?php } else{?>
                                                                        <span
                                                                        class="text-11 rounded-16 lh-2 text-black bg-blue-2 py-5 px-5"><?php echo $value1 ?></span>
                                                                    <?php } ?>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        }
                                                    }
                                                }
                                                ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-center items-center mt-20 survey_nav_button">
                            <a href="#" class="button bg-color-primary h-40 text-white px-60"
                               id="mark_as_review" onclick="navigation();">
                                <?php echo _("AS0131") ?>
                            </a>
                        </div>

                    </div>
                </div>

            </div>
        </div>
        <?php include "./footer_secondary.php" ?>
        <script>
            function navigation() {
                window.close();
            }
        </script>
    </body>
</html>
<?php ?>

