<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
// start session
session_start();
if (!isset($_SESSION['uid'])) {
    header("Location: index.php");
} else {

    if (!isset($_POST['sur_id'])) {
        header('Location: 404.php');
    }

    include_once "config/database.php";
    include_once "resources/survey.php";
    include_once 'config/properties.php';
    include_once "resources/manageusers.php";
    include_once "resources/EncryptDecrypt.php";
// initialize objects
    $survey = new Survey();
    $users = new ManageUsers();

    $survey_id = "";
    $page_title = "";
    $id = $_SESSION['uid'];
    $sur_id = $_POST['sur_id'];
    $c_page = $_POST['c_pg'];
    $group_name_flag = "";
    $welcome_message = "";
    $end_message = "";
    $no_questions = 0;
    $survey_format = "";

    $survey->sur_id = $sur_id;
    $survey->user_id = $id;
    $stmt1 = $survey->survey();
    if ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {
        $survey_id = $row1['survey_id'];
        $group_name_flag = $row1['display_group_name'];
        $welcome_message = $row1['welcome_msg'];
        $end_message = $row1['end_msg'];
        $survey_format = $row1['survey_format'];
        $page_title = $row1['survey_title'];
    }
    $survey->survey_id = $survey_id;
    ?>
    <!DOCTYPE>
    <html lang="en">

        <head>
            <?php include "./head.php" ?>
            <!-- Styles -->
            <link rel="stylesheet" href="assets/css/survey/view.css">
            <link rel="stylesheet" href="assets/css/glightbox.css">
            <title><?php echo $page_title; ?></title>

        </head>

        <body>
            <?php include "./menu_secondary.php"; ?>
            <div class="container py-10 x-gap-40 bg-light-9 rounded-8 mb-50 mt-20">
                <div class="row y-gap-30 mb-0">

                    <div class="col-xl-12 col-lg-12 px-0">
                        <div class="rounded-8 bg-white -dark-bg-dark-1 shadow-4">
                            <div class="py-20 px-20 border-bottom-light text-center">
                                <h2 class="lh-12"><?php echo $page_title ?></h2>
                            </div>
                            <div id="welcome_msg">
                                <p class="py-40 px-40 border-bottom-light" style="justify-content: space-evenly;"><?php echo $welcome_message ?></p>

                                <div class="d-flex justify-center items-center py-30 assmt_nav_button">
                                    <a href="javascript:;" class="button -icon bg-color-primary h-40 text-white px-40" id="start">
                                        <?php echo _("SY0102") . _("SY0101"); ?>
                                        <i class="fa fa-angle-double-right text-13 ml-5"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="py-20 px-20" id="questions">
                                <?php
                                if ($survey_format == 'single') {
                                    echo "<div class='survey_qus'>";

                                    $m = 0;
                                    $count = 1;
                                    $no_questions = $survey->get_no_questions();
                                    echo "<input type='hidden' value='{$no_questions}'>";
                                    $stmt5 = $survey->getSurvey_question();
                                } else if ($survey_format == 'all') {
                                    echo "<div class='survey_all_qus'>";
                                    $m = 0;
                                    $count = 1;
                                    $no_questions = $survey->get_no_questions();
                                    echo "<input type='hidden' value='{$no_questions}'>";
                                    $stmt5 = $survey->getSurvey_question();
                                } else if ($survey_format == 'group') {
                                    echo "<div class='survey_group'>";
                                }
                                ?>

                                <?php
                                if ($survey_format != 'group') {
                                    while ($row5 = $stmt5->fetch(PDO::FETCH_ASSOC)) {
                                        extract($row5);
                                        $m = $m + 1;
                                        echo "<div class='border-light-2 overflow-hidden rounded-8 question mt-8' name='{$survey_question_id}'>";
                                        echo "<input type='hidden' class='qu_id' value='$survey_question_id'>";
                                        echo "<input type='hidden' class='mandatory' value='$mandatory' name='man_{$survey_question_id}'>";
                                        echo "<div class='py-10 px-20 bg-light-3'>";
                                        echo "<div class='d-flex justify-between'>";
                                        echo "<h4 class='text-14 fw-500 text-black'>" . _("AS0112") . " $question_order of $no_questions</h4>";
                                        echo "</div>";
                                        echo "<div class='text-18 lh-12 text-black mt-5 mb-10' id = 'qus_text" . $m . "'>$question_text";
                                        if ($mandatory == 'Y') {
                                            echo "<span class='text-red-1'>*</span>";
                                        }
                                        echo "</div>";
                                        echo "</div>";
                                        if ($question_type_id != "8") {
                                            echo "<div class='px-20 py-15'>";
                                        }
                                        if ($question_type_id == "2") {
                                            echo "<div class='mb-10'>" . _("AS0113") . "</div>";
                                        } else if ($question_type_id == "4") {
                                            echo "<div class='mb-10'>" . _("AS0114") . "</div>";
                                        }
                                        $survey->survey_question_id = $survey_question_id;
                                        $number = $survey->get_surveyoption_count();

                                        $match_val = 0;
                                        $stmt4 = $survey->get_surveyoptions();
                                        if ($question_type_id == "1") {
                                            if ($max_char == null) {
                                                $max_char = 100;
                                            }
                                            echo "<form class='row contact-form mb-0'>";
                                            echo "<div class='col-md-6'>";
                                            echo "<input type='text' placeholder='Text...' class='text-16' autocomplete='off' name='TXT_" . $survey_question_id . "' maxlength='" . $max_char . "'>";
                                            echo "</div>";
                                            echo "</form>";
                                            echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                        } else if ($question_type_id == "2") {
                                            while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                extract($row4);
                                                $count1 = $count++;
                                                echo "<div class='form-radio d-flex items-center'>";
                                                echo "<div class='radio'>";
                                                echo "<input type='radio' name='R_" . $survey_question_id . "' id='radio" . $count1 . "' value='" . htmlentities($option_desc) . "' class='" . $survey_question_option_id . "'>";
                                                echo "<div class='radio__mark'>";
                                                echo "<div class='radio__icon'></div>";
                                                echo "</div>";
                                                echo "</div>";
                                                echo "<div class='text-16 fw-500 ml-12'>" . htmlentities($option_desc) . "</div>";
                                                echo "</div>";
                                            }
                                            echo "<input type='text' class='radio_cmd' id='" . $survey_question_id . "'  minlength='1' maxlength='250'>";
                                            echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                        } else if ($question_type_id == "3") {
                                            echo "<div class='row'>";
                                            echo "<div class='col-md-2'>";
                                            echo "<select class='form-control text-16 py-5 text-center' data-type='qus_type_3' name='" . $survey_question_id . "' id='select_" . $survey_question_id . "'>";
                                            echo "<option value=''>--Select Option--</option>";
                                            while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                extract($row4);
                                                $count1 = $count++;
                                                echo "<option value='" . $survey_question_option_id . "'>" . htmlentities($option_desc) . "</option>";
                                            }
                                            echo "</select>";
                                            echo "</div>";
                                            echo "</div>";
                                            echo "<input type='text' class='select_cmd' id='" . $survey_question_id . "'  minlength='1' maxlength='250'>";
                                            echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                        } else if ($question_type_id == "4") {
                                            while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                extract($row4);
                                                $count1 = $count++;
                                                echo "<div class='form-checkbox d-flex items-center'>";
                                                echo "<div class='checkbox'>";
                                                echo "<input id='checkbox" . $count1 . "' type='checkbox' name='CH_" . $survey_question_id . "' value='" . htmlentities($option_desc) . "'  class='" . $survey_question_option_id . "'>";
                                                echo "<div class='form-checkbox__mark'>";
                                                echo "<div class='form-checkbox__icon icon-check'></div>";
                                                echo "</div>";
                                                echo "</div>";
                                                echo "<div class='text-16 fw-500 ml-12'>" . htmlentities($option_desc) . "</div>";
                                                echo "</div>";
                                            }
                                            echo "<input type='text' class='check_cmd' id='" . $survey_question_id . "' minlength='1' maxlength='250'>";
                                            echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                        } else if ($question_type_id == "5") {
                                            if ($max_char == null) {
                                                $max_char = 100;
                                            }
                                            echo "<form class='row contact-form mb-0'>";
                                            echo "<div class='col-md-6'>";
                                            echo "<textarea placeholder='Text...' class='text-16' rows='4' cols='80' autocomplete='off' id='long_txt' name='TXT_L_" . $survey_question_id . "' maxlength='" . $max_char . "'></textarea>";
                                            echo "</div>";
                                            echo "</form>";
                                            echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                        } else if ($question_type_id == "6") {
                                            while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                extract($row4);
                                                $no_opt = $survey->get_surveyoptions_count();
                                                $count1 = $count++;
                                                echo "<div class='row items-center mt-8' id='drop_" . $survey_question_id . "'>";
                                                echo "<div class='col-auto'>";
                                                echo "<select class='form-control text-16 text-center' data-type='qus_type_6' name='" . $survey_question_option_id . "' id='" . $survey_question_option_id . "' onchange='ch_value($survey_question_id,$survey_question_option_id)'>";
                                                $no = 1;
                                                echo"<option value=''> --Select-- </option>";
                                                for ($no; $no <= $no_opt; $no++) {
                                                    echo "<option value='" . $survey_question_option_id . "' class='$no'>" . $no . "</option>";
                                                }
                                                echo "</select>";
                                                echo "</div>";
                                                echo "<div class='col-md-9'>" . htmlentities($option_desc) . "</div>";
                                                echo "</div>";
                                            }
                                            echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                        } else if ($question_type_id == "7") {
                                            echo "<div class='col-auto text-blue-3 ml-10' id='resetval'><u >Reset</u></div>";
                                            while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                extract($row4);
                                                $no_opt = $max_rank;
                                                echo "<div class='row items-center mt-8' data-type='RK_" . $survey_question_id . "' id='drop_select'>";
                                                echo "<div class='col-md-1'>";
                                                echo "<form class='contact-form num_survey mb-0'>";
                                                echo "<input type='hidden'  class='max_rank' value='$no_opt'>";
                                                echo "<input type='text' class='text-16 ml-10 text-center' data-type='" . $survey_question_option_id . "' autocomplete='off' name='qus_type_7' id='ra_" . $survey_question_option_id . "'>";
                                                echo "</form>";
                                                echo "</div>";
                                                echo "<div class='col-md-9'>" . htmlentities($option_desc) . "</div>";
                                                echo "</div>";
                                            }
                                            echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                        } else if ($question_type_id == "8") {
                                            echo "<div class='qt_8 Lt_" . $survey_question_id . "'>";
                                            echo "<div class='d-flex justify-start px-20 py-20 likert_qus'>";

                                            while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                extract($row4);
                                                $count1 = $count++;
                                                echo "<label class='likert_label'>";
                                                echo "<input type='radio' id='radio" . $count1 . "' name='L_" . $survey_question_id . "' value='" . htmlentities($option_desc) . "' data-type='" . $survey_question_option_id . "' />";
                                                echo "<div class='button px-30 py-20 -light-20 text-black ml-5'>$option_desc</div>";
                                                echo "</label>";
                                            }
                                            echo "</div>";
                                            echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                            echo "</div>";
                                        }
                                        if ($question_type_id != 8) {
                                            echo "</div>";
                                        }

                                        echo "</div>";
                                    }
                                }
                                ?>
                                <?php
                                if ($survey_format == 'group') {
                                    $stmt6 = $survey->getSurvey_group();
                                    $total_survey_group = $stmt6->rowCount();
                                    $current_group = 1;
                                    while ($row6 = $stmt6->fetch(PDO::FETCH_ASSOC)) {
                                        extract($row6);
                                        $m = 0;
                                        $count = 1;
                                        echo "<div class='survey_group_div' id='group_$survey_question_group_id'>";
                                        echo "<h4 class='lh-12 ml-5 border-bottom-light py-5 mb-20'>Survey Group $current_group of $total_survey_group</h4>";
                                        if ($group_name_flag == 'Y') {
                                            echo "<h3 class='text-18 lh-12 text-black ml-5 py-5'>{$group_name}</h3>";
                                        }
                                        $survey->survey_question_group_id = $survey_question_group_id;
                                        $no_questions = $survey->get_no_questions_group();
                                        echo "<input type='hidden' value='{$no_questions}'>";
                                        $stmt5 = $survey->getSurvey_question_group();
                                        while ($row5 = $stmt5->fetch(PDO::FETCH_ASSOC)) {
                                            extract($row5);
                                            $m = $m + 1;
                                            echo "<div class='border-light-2 overflow-hidden rounded-8 question mt-8' name='{$survey_question_id}'>";
                                            echo "<input type='hidden' class='qu_id' value='$survey_question_id'>";
                                            echo "<input type='hidden' class='mandatory' value='$mandatory' name='man_{$survey_question_id}'>";
                                            echo "<div class='py-10 px-20 bg-light-3'>";
                                            echo "<div class='d-flex justify-between'>";
                                            echo "<h4 class='text-14 fw-500 text-black'>" . _("AS0112") . " $m of $no_questions</h4>";
                                            echo "</div>";
                                            echo "<div class='text-18 lh-12 text-black mt-5 mb-10' id = 'qus_text" . $m . "'>$question_text";
                                            if ($mandatory === 'Y') {
                                                echo "<span class='text-red-1'>*</span>";
                                            }
                                            echo "</div>";
                                            echo "</div>";
                                            if ($question_type_id != "8") {
                                                echo "<div class='px-20 py-15'>";
                                            }
                                            if ($question_type_id == "2") {
                                                echo "<div class='mb-10'>" . _("AS0113") . "</div>";
                                            } else if ($question_type_id == "4") {
                                                echo "<div class='mb-10'>" . _("AS0114") . "</div>";
                                            }
                                            $survey->survey_question_id = $survey_question_id;
                                            $number = $survey->get_surveyoption_count();

                                            $match_val = 0;
                                            $stmt4 = $survey->get_surveyoptions();
                                            if ($question_type_id == "1") {
                                                if ($max_char == null) {
                                                    $max_char = 100;
                                                }
                                                echo "<form class='row contact-form mb-0'>";
                                                echo "<div class='col-md-6'>";
                                                echo "<input type='text' placeholder='Text...' class='text-16' autocomplete='off' name='TXT_" . $survey_question_id . "' maxlength='" . $max_char . "'>";
                                                echo "</div>";
                                                echo "</form>";
                                                echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                            } else if ($question_type_id == "2") {
                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row4);
                                                    $count1 = $count++;
                                                    echo "<div class='form-radio d-flex items-center'>";
                                                    echo "<div class='radio'>";
                                                    echo "<input type='radio' name='R_" . $survey_question_id . "' id='radio" . $count1 . "' value='" . htmlentities($option_desc) . "' class='" . $survey_question_option_id . "'>";
                                                    echo "<div class='radio__mark'>";
                                                    echo "<div class='radio__icon'></div>";
                                                    echo "</div>";
                                                    echo "</div>";
                                                    echo "<div class='text-16 fw-500 ml-12'>" . htmlentities($option_desc) . "</div>";
                                                    echo "</div>";
                                                }
                                                echo "<input type='text' class='radio_cmd' id='" . $survey_question_id . "'  minlength='1' maxlength='250'>";
                                                echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                            } else if ($question_type_id == "3") {
                                                echo "<div class='row'>";
                                                echo "<div class='col-md-2'>";
                                                echo "<select class='form-control text-16 py-5 text-center' data-type='qus_type_3' name='" . $survey_question_id . "' id='select_" . $survey_question_id . "'>";
                                                echo "<option value=''>--Select Option--</option>";
                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row4);
                                                    $count1 = $count++;
                                                    echo "<option value='" . $survey_question_option_id . "'>" . htmlentities($option_desc) . "</option>";
                                                }
                                                echo "</select>";
                                                echo "</div>";
                                                echo "</div>";
                                                echo "<input type='text' class='select_cmd' id='" . $survey_question_id . "'  minlength='1' maxlength='250'>";
                                                echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                            } else if ($question_type_id == "4") {
                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row4);
                                                    $count1 = $count++;
                                                    echo "<div class='form-checkbox d-flex items-center'>";
                                                    echo "<div class='checkbox'>";
                                                    echo "<input id='checkbox" . $count1 . "' type='checkbox' name='CH_" . $survey_question_id . "' value='" . htmlentities($option_desc) . "'  class='" . $survey_question_option_id . "'>";
                                                    echo "<div class='form-checkbox__mark'>";
                                                    echo "<div class='form-checkbox__icon icon-check'></div>";
                                                    echo "</div>";
                                                    echo "</div>";
                                                    echo "<div class='text-16 fw-500 ml-12'>" . htmlentities($option_desc) . "</div>";
                                                    echo "</div>";
                                                }
                                                echo "<input type='text' class='check_cmd' id='" . $survey_question_id . "' minlength='1' maxlength='250'>";
                                                echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                            } else if ($question_type_id == "5") {
                                                if ($max_char == null) {
                                                    $max_char = 100;
                                                }
                                                echo "<form class='row contact-form mb-0'>";
                                                echo "<div class='col-md-6'>";
                                                echo "<textarea placeholder='Text...' class='text-16' rows='4' cols='80' autocomplete='off' id='long_txt' name='TXT_L_" . $survey_question_id . "' maxlength='" . $max_char . "'></textarea>";
                                                echo "</div>";
                                                echo "</form>";
                                                echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                            } else if ($question_type_id == "6") {
                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row4);
                                                    $no_opt = $survey->get_surveyoptions_count();
                                                    $count1 = $count++;
                                                    echo "<div class='row items-center mt-8' id='drop_" . $survey_question_id . "'>";
                                                    echo "<div class='col-auto'>";
                                                    echo "<select class='form-control text-16 text-center' data-type='qus_type_6' name='" . $survey_question_option_id . "' id='" . $survey_question_option_id . "' onchange='ch_value($survey_question_id,$survey_question_option_id)'>";
                                                    $no = 1;
                                                    echo"<option value=''> --Select-- </option>";
                                                    for ($no; $no <= $no_opt; $no++) {
                                                        echo "<option value='" . $survey_question_option_id . "' class='$no'>" . $no . "</option>";
                                                    }
                                                    echo "</select>";
                                                    echo "</div>";
                                                    echo "<div class='col-md-9'>" . htmlentities($option_desc) . "</div>";
                                                    echo "</div>";
                                                }
                                                echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                            } else if ($question_type_id == "7") {
                                                echo "<div class='col-auto text-blue-3 ml-10' id='resetval'><u >Reset</u></div>";
                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row4);
                                                    $no_opt = $max_rank;
                                                    echo "<div class='row items-center mt-8' data-type='RK_" . $survey_question_id . "' id='drop_select'>";
                                                    echo "<div class='col-md-1'>";
                                                    echo "<form class='contact-form num_survey mb-0'>";
                                                    echo "<input type='hidden'  class='max_rank' value='$no_opt'>";
                                                    echo "<input type='text' class='text-16 ml-10 text-center' data-type='" . $survey_question_option_id . "' autocomplete='off' name='qus_type_7' id='ra_" . $survey_question_option_id . "'>";
                                                    echo "</form>";
                                                    echo "</div>";
                                                    echo "<div class='col-md-9'>" . htmlentities($option_desc) . "</div>";
                                                    echo "</div>";
                                                }
                                                echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                            } else if ($question_type_id == "8") {
                                                echo "<div class='qt_8 Lt_" . $survey_question_id . "'>";
                                                echo "<div class='d-flex justify-start px-20 py-20 likert_qus'>";

                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row4);
                                                    $count1 = $count++;
                                                    echo "<label class='likert_label'>";
                                                    echo "<input type='radio' id='radio" . $count1 . "' name='L_" . $survey_question_id . "' value='" . htmlentities($option_desc) . "' data-type='" . $survey_question_option_id . "' />";
                                                    echo "<div class='button px-30 py-20 -light-20 text-black ml-5'>$option_desc</div>";
                                                    echo "</label>";
                                                }
                                                echo "</div>";
                                                echo "<span class='text-red-1 mt-5 error_message' name='" . $survey_question_id . "'>" . _("SY0103") . "</span>";
                                                echo "</div>";
                                            }
                                            if ($question_type_id != 8) {
                                                echo "</div>";
                                            }

                                            echo "</div>";
                                        }
                                        echo "</div>";
                                        $current_group++;
                                    }
                                }
                                //div for all items
                                echo "</div>";

                                if ($survey_format == 'single' || $survey_format == 'group') {
                                    $prev_id = $survey_format == "single" ? "prev" : "prev_grp";
                                    $prev_label = $survey_format == "single" ? _('AS0116') : _('SY0109');
                                    $nxt_id = $survey_format == "single" ? "next" : "next_grp";
                                    $nxt_label = $survey_format == "single" ? _('AS0118') : _('SY0110');
                                    $smt_id = $survey_format == "single" ? "submit_single" : "submit_group";
                                    ?>
                                    <div class="d-flex justify-start items-center mt-40 survey_nav_button">
                                        <button  class="button -icon bg-color-primary h-40 text-white" id="<?php echo $prev_id ?>">
                                            <i class="fa fa-angle-double-left text-13 mr-5"></i>
                                            <?php echo $prev_label ?>
                                        </button>
                                        <button class="button -icon bg-color-primary h-40 text-white ml-10"
                                                id="<?php echo $nxt_id ?>">
                                                    <?php echo $nxt_label ?>
                                            <i class="fa fa-angle-double-right text-13 ml-5"></i>
                                        </button>
                                        <button class="button -icon -green-8-1 h-40 text-white ml-10"
                                                id="<?php echo $smt_id ?>">
                                            <i class="fa fa-check text-13 mr-5"></i>
                                            <?php echo _("SY0111") ?>
                                        </button>
                                    </div>
                                <?php } else if ($survey_format == 'all') { ?>
                                    <div class="d-flex justify-start items-center mt-40 survey_nav_button">
                                        <button class="button -icon -green-8-1 h-40 text-white ml-10"
                                                id="submit_all">
                                            <i class="fa fa-check text-13 mr-5"></i>
                                            <?php echo _("SY0111") ?>
                                        </button>
                                    </div>
                                <?php }
                                ?>
                            </div>

                            <div id="end_msg">
                                <p class="py-40 px-40 border-bottom-light" style="justify-content: space-evenly;"><?php echo $end_message ?></p>

                                <div class="d-flex justify-center items-center py-30 assmt_nav_button">
                                    <a href="javascript:;" class="button -icon bg-color-primary h-40 text-white px-40" id="end">
                                        <?php echo _("AS0131"); ?>
                                        <i class="fa fa-angle-double-right text-13 ml-5"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <?php include "./footer_secondary.php"; ?>
            <script src="assets/js/glightbox.min.js"></script>

            <script>
                function setvalue(id) {
                    $('a[id="' + id + '"]').css('background', "#999");
                }
                var submitted = false;
                var is_welcome_msg = "<?php echo $welcome_message; ?>";
                var is_end_msg = "<?php echo $end_message; ?>";
                var is_reload_page = "<?php echo $c_page; ?>";
                $('#welcome_msg').css("display", "none");
                $('#end_msg').css("display", "none");
                $('#questions').css("display", "none");
                $('.error_message').css("display", "none");

                //display div by default 
                if (is_welcome_msg !== '') {
                    $('#welcome_msg').css("display", "block");
                    $('#questions').css("display", "none");
                } else {
                    $('#welcome_msg').css("display", "none");
                    $('#questions').css("display", "block");
                }

                $("#start").click(function () {
                    $('#welcome_msg').css("display", "none");
                    $('#questions').css("display", "block");
                });
                $("#end").click(function () {
                    //window.opener.location.href = "survey.php";
                    window.opener.location.href = is_reload_page + ".php";
                    window.opener.location.reload(true);
                    window.close();
                });

                $("#resetval").click(function () {
                    $("#drop_select input[type='text']").each(function () {
                        $(this).val('');
                        $(this).css('border', '1px solid var(--color-light-8)');
                        $(this).removeAttr('disabled', 'disabled');
                        ind = 0;
                    });
                });
            </script>
            <script>
                //check value for type 6
                function ch_value(ques_idval, optid) {
                    var disp = false;
                    var selected = [];
                    $('div[id="drop_' + ques_idval + '"] select[data-type="qus_type_6"] option:selected').each(function () {
                        if ($(this).val() !== '') {
                            selected.push($(this).text());
                            var length = selected.length;
                            for (var i = 0; i < length; i++) {
                                for (var j = i + 1; j < length; j++) {
                                    if (selected[i] === selected[j])
                                        if (disp === false) {
                                            alert("<?php echo _("SY0106") ?>");

                                            disp = true;
                                            $('div[id="drop_' + ques_idval + '"] select[name="' + optid + '"]').val('');
                                        }
                                }
                            }
                        }
                    });
                }
                var s_format = "<?php echo $survey_format ?>";
                if (s_format === 'single') {
                    var ind = 0;
                    $('.survey_qus input[type="radio"]').click(function () {
                        var userString = $(this).val();
                        var con = userString.toLowerCase();
                        if (con === "other" || con === 'others') {
                            $('.radio_cmd').css("display", "block");
                        } else {
                            $('.radio_cmd').css("display", "none");
                        }
                    });
                    $('.survey_qus input[type="checkbox"]').click(function () {
                        var userString = $(this).val();
                        var con = userString.toLowerCase();
                        if (con === "other" || con === 'others') {
                            $('.check_cmd').css("display", "block");
                        } else {
                            $('.check_cmd').css("display", "none");
                        }
                    });
                    $('.survey_qus select').on('change', function () {
                        var selectedItem = $(this).children("option:selected").text();
                        var con = selectedItem.toLowerCase();
                        if (con === "other" || con === 'others') {
                            $('.select_cmd').css("display", "block");
                        } else {
                            $('.select_cmd').css("display", "none");
                        }
                    });
                    $('.survey_qus input[name="qus_type_7"]').click(function () {
                        $('.current .error_message').css("display", "none");
                        var max_ra = $(".current #drop_select .max_rank").val();
                        ind++;
                        if (~~ind < ~~max_ra) {
                            $(this).val(ind);
                            $(".current #drop_select input[name='qus_type_7']").each(function () {
                                if ($(this).val() !== '') {
                                    $(this).attr('disabled', 'disabled');
                                }
                            });
                        } else if (~~ind === ~~max_ra) {
                            $(this).val(ind);
                            //disabling textbox           
                            $(".current #drop_select input[name='qus_type_7']").each(function () {
                                if ($(this).val() === '') {
                                    $(this).attr('disabled', 'disabled');
                                    $(this).css('border', 'none');
                                }
                            });
                        }
                    });
                } else if (s_format === 'group') {
                    var ind = 0;
                    $('.survey_group input[type="radio"]').click(function () {
                        var userString = $(this).val();
                        var con = userString.toLowerCase();
                        if (con === "other" || con === 'others') {
                            $('.radio_cmd').css("display", "block");
                        } else {
                            $('.radio_cmd').css("display", "none");
                        }
                    });
                    $('.survey_group input[type="checkbox"]').click(function () {
                        var userString = $(this).val();
                        var con = userString.toLowerCase();
                        if (con === "other" || con === 'others') {
                            $('.check_cmd').css("display", "block");
                        } else {
                            $('.check_cmd').css("display", "none");
                        }
                    });
                    $('.survey_group select').on('change', function () {
                        var selectedItem = $(this).children("option:selected").text();
                        var con = selectedItem.toLowerCase();
                        if (con === "other" || con === 'others') {
                            $('.select_cmd').css("display", "block");
                        } else {
                            $('.select_cmd').css("display", "none");
                        }
                    });
                    $('.survey_group input[name="qus_type_7"]').click(function () {
                        var max_ra = $(".current #drop_select .max_rank").val();
                        ind++;
                        if (~~ind < ~~max_ra) {
                            $(this).val(ind);
                            $(".current #drop_select input[name='qus_type_7']").each(function () {
                                if ($(this).val() !== '') {
                                    $(this).attr('disabled', 'disabled');
                                }
                            });
                        } else if (~~ind === ~~max_ra) {
                            $(this).val(ind);
                            //disabling textbox           
                            $(".current #drop_select input[name='qus_type_7']").each(function () {
                                if ($(this).val() === '') {
                                    $(this).attr('disabled', 'disabled');
                                    $(this).css('border', 'none');
                                }
                            });
                        }
                    });
                } else if (s_format === 'all') {
                    var ind = 0;
                    $('.survey_all_qus input[type="radio"]').click(function () {
                        var userString = $(this).val();
                        var con = userString.toLowerCase();
                        if (con === "other" || con === 'others') {
                            $('.radio_cmd').css("display", "block");
                        } else {
                            $('.radio_cmd').css("display", "none");
                        }
                    });
                    $('.survey_all_qus input[type="checkbox"]').click(function () {
                        var userString = $(this).val();
                        var con = userString.toLowerCase();
                        if (con === "other" || con === 'others') {
                            $('.check_cmd').css("display", "block");
                        } else {
                            $('.check_cmd').css("display", "none");
                        }
                    });
                    $('.survey_all_qus select').on('change', function () {
                        var selectedItem = $(this).children("option:selected").text();
                        var con = selectedItem.toLowerCase();
                        if (con === "other" || con === 'others') {
                            $('.select_cmd').css("display", "block");
                        } else {
                            $('.select_cmd').css("display", "none");
                        }
                    });
                    $('.survey_all_qus input[name="qus_type_7"]').click(function () {
                        var max_ra = $(" #drop_select .max_rank").val();
                        ind++;
                        if (~~ind < ~~max_ra) {
                            $(this).val(ind);
                            $(" #drop_select input[name='qus_type_7']").each(function () {
                                if ($(this).val() !== '') {
                                    $(this).attr('disabled', 'disabled');
                                }
                            });
                        } else if (~~ind === ~~max_ra) {
                            $(this).val(ind);
                            //disabling textbox           
                            $(" #drop_select input[name='qus_type_7']").each(function () {
                                if ($(this).val() === '') {
                                    $(this).attr('disabled', 'disabled');
                                    $(this).css('border', 'none');
                                }
                            });
                        }
                    });
                }
            </script>
            <!--next prev button click-->
            <script>
                $(document).ready(function () {

                    if ($('.survey_qus').length) {
                        $('.survey_qus div:first').css("display", "block");
                        $('.survey_qus div:first').addClass('current');
                        $("#prev").attr("disabled", "disabled");
                        $("#prev").removeClass("bg-color-primary").addClass("disabled-btn");
                        $("#submit_single").attr("disabled", "disabled");
                        $("#submit_single").removeClass("-green-8-1").addClass("disabled-btn");
                        if ($(".survey_qus .current").next().length !== 1) {
                            $("#next").attr("disabled", "disabled");
                            $("#next").removeClass("bg-color-primary").addClass("disabled-btn");
                            $("#submit_single").removeAttr("disabled");
                            $("#submit_single").removeClass("disabled-btn").addClass("-green-8-1");
                        }
                    }

                    if ($('.survey_group').length) {
                        $('.survey_group div:first').css("display", "block");
                        $('.survey_group div:first').addClass('current');
                        $("#prev_grp").attr("disabled", "disabled");
                        $("#prev_grp").removeClass("bg-color-primary").addClass("disabled-btn");
                        $("#submit_group").attr("disabled", "disabled");
                        $("#submit_group").removeClass("-green-8-1").addClass("disabled-btn");
                        if ($(".survey_group .current").next().length !== 1) {
                            $("#next_grp").attr("disabled", "disabled");
                            $("#next_grp").removeClass("bg-color-primary").addClass("disabled-btn");
                            $("#submit_group").removeAttr("disabled");
                            $("#submit_group").removeClass("disabled-btn").addClass("-green-8-1");
                        }
                    }
                });

                $("#next").click(function () {
                    var man = false;
                    var qu_id = $('.current .qu_id').val();
                    $('.error_message').css("display", "none");
                    man = checkMandatory(qu_id);
                    if (man === false) {
                        $('.error_message').css("display", "none");
                        if ($(".current").next().length === 1) {
                            $(".current").removeClass("current").hide().next().addClass("current").show();
                            $('html, body').animate({scrollTop: 0}, 'fast');
                        }
                        if ($(".current").next().length !== 1) {
                            $("#next").attr("disabled", "disabled");
                            $("#next").removeClass("bg-color-primary").addClass("disabled-btn");
                            $("#submit_single").removeAttr("disabled");
                            $("#submit_single").removeClass("disabled-btn").addClass("-green-8-1");
                        }
                        $("#prev").removeAttr("disabled");
                        $("#prev").removeClass("disabled-btn").addClass("bg-color-primary");
                    } else {
                        $('.current span[class="error_message"]').css("display", "block");
                    }

                });
                $("#prev").click(function () {
                    if ($(".current").prev().length === 1) {
                        $(".current").removeClass("current").hide().prev().addClass("current").show();
                    }
                    if ($(".current").prev().prev().length !== 1) {
                        $("#prev").attr("disabled", "disabled");
                        $("#prev").removeClass("bg-color-primary").addClass("disabled-btn");
                    }
                    $("#next").removeAttr("disabled");
                    $("#next").removeClass("disabled-btn").addClass("bg-color-primary");
                    $("#submit_single").attr("disabled", "disabled");
                    $("#submit_single").removeClass("-green-8-1").addClass("disabled-btn");
                });

                $("#next_grp").click(function () {
                    var man = false;
                    var qu_id = [];
                    $('.survey_group .current>div').each(function () {
                        qu_id.push($(this).attr('name'));
                    });
                    //$('.current span[class="error_message"]').css("display","none");
                    $('.error_message').css("display", "none");
                    $.each(qu_id, function (index, value) {

                        //Radio button
                        if ($('input[name="R_' + value + '"]').length > 0) {
                            if (!$(' input[name="R_' + value + '"]:checked').length > 0) {
                                var ques_man = $('.current input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            } else {
                                var userString = $('.current input[name="R_' + value + '"]:checked').val();
                                var con = userString.toLowerCase();
                                if (con === 'other' || con === 'others') {
                                    if ($(' input[id="' + value + '"]').val() === "") {
                                        $(' span[name="' + value + '"]').css("display", "block");
                                        man = true;
                                    }
                                }
                            }
                        }
                        //Likert
                        if ($(' input[name="L_' + value + '"]').length > 0) {
                            if (!$(' input[name="L_' + value + '"]:checked').length > 0) {
                                var ques_man = $('.current input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        }
                        //checkbox
                        if ($(' input[name="CH_' + value + '"]').length > 0) {
                            if (!$(' input[name="CH_' + value + '"]:checked').length > 0) {
                                var ques_man = $(' input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            } else {
                                var userString = $(' input[name="CH_' + value + '"]:checked').val();
                                var con = userString.toLowerCase();
                                if (con === 'other' || con === 'others') {
                                    if ($(' input[id="' + value + '"]').val() === "") {
                                        $(' span[name="' + value + '"]').css("display", "block");
                                        man = true;
                                    }
                                }
                            }
                        }
                        //Ranking with select
                        var ans_fl_ras = false;
                        $('div[data-type="RK_' + value + '"] input[name="qus_type_7"]').each(function () {
                            var boxes = $('div[data-type="RK_' + value + '"] input[name="qus_type_7"]').filter(function () {
                                return $(this).val();
                            });
                            var m_r = $('div[data-type="RK_' + value + '"] input[class="max_rank"]').val();

                            if (~~boxes.length === ~~m_r) {
                                ans_fl_ras = true;
                            }
                            if (ans_fl_ras === false) {
                                var ques_man = $(' input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        });
                        //Ranking all
                        $('div[id="drop_' + value + '"] select[data-type="qus_type_6"] option:selected ').each(function () {
                            var ans_fl = false;
                            if ($(this).val() !== '') {
                                ans_fl = true;
                            }
                            if (ans_fl === false) {
                                var ques_man = $(' input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        });
                        //Textbox
                        $(' input[name="TXT_' + value + '"]').each(function () {
                            if ($(this).val().trim() === '') {
                                var ques_man = $(' input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $('span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        });
                        //Long free text
                        $('textarea[name="TXT_L_' + value + '"]').each(function () {
                            if ($(this).val().trim() === '') {
                                var ques_man = $(' input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        });
                        //drop down
                        $(' select[id="select_' + value + '"]').each(function () {
                            if ($(this).val() === '') {
                                var ques_man = $(' input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            } else {
                                var userString = $(this).text();
                                var con = userString.toLowerCase();
                                if (con === 'other' || con === 'others') {
                                    if ($(' input[id="' + value + '"]').val() === "") {
                                        $(' span[name="' + value + '"]').css("display", "block");
                                        man = true;
                                    }
                                }
                            }
                        });
                    });
                    if (man === false) {
                        $('.current span[class="error_message"]').css("display", "none");

                        if ($(".current").next().length === 1) {
                            $(".current").removeClass("current").hide().next().addClass("current").show();
                            $('html, body').animate({scrollTop: 0}, 'fast');
                        }
                        if ($(".current").next().length !== 1) {
                            $("#next_grp").attr("disabled", "disabled");
                            $("#next_grp").removeClass("bg-color-primary").addClass("disabled-btn");
                            $("#submit_group").removeAttr("disabled");
                            $("#submit_group").removeClass("disabled-btn").addClass("-green-8-1");
                        }
                        $("#prev_grp").removeAttr("disabled");
                        $("#prev_grp").removeClass("disabled-btn").addClass("bg-color-primary");
                    }

                });
                $("#prev_grp").click(function () {

                    if ($(".current").prev().length === 1) {
                        $(".current").removeClass("current").hide().prev().addClass("current").show();
                    }
                    if ($(".current").prev().length !== 1) {
                        $("#prev_grp").attr("disabled", "disabled");
                        $("#prev_grp").removeClass("bg-color-primary").addClass("disabled-btn");
                    }
                    $("#next_grp").removeAttr("disabled");
                    $("#next_grp").removeClass("disabled-btn").addClass("bg-color-primary");
                    $("#submit_group").attr("disabled", "disabled");
                    $("#submit_group").removeClass("-green-8-1").addClass("disabled-btn");
                });
            </script>
            <!--//submit function-->
            <script>
                $("#submit_single").click(function () {
                    var ans_no_flag = false;
                    var man = false;
                    var qu_id = $('.current .qu_id').val();

                    //Radio button
                    $('.current span[class="error_message"]').css("display", "none");
                    man = checkMandatory(qu_id);
                    if (man === false) {
                        submitted = true;
                        $('.current span[class="error_message"]').css("display", "none");
                        var qids = [];
                        var allanswers = [];
                        $('.survey_qus>div').each(function () {
                            qids.push($(this).attr('name'));
                        });
                        $.each(qids, function (index, value) {
                            ans_no_flag = EmptyAnswerCheck(value);
                            if (ans_no_flag === true) {
                                return false;
                            }
                        });
                        if (ans_no_flag === false) {
                            alert("<?php echo _("SY0107") ?>");
                        } else {
                            $.each(qids, function (index, value) {
                                var mainObject = new Object();

                                mainObject.qid = value;
                                mainObject.option = [];

                                mainObject = answerResponse(value);

                                allanswers.push(mainObject);
                            });
                            var allAns = JSON.stringify(allanswers);
                            //                alert(allAns);
                            var sid = <?php echo $survey_id; ?>;
                            if (confirm('<?php echo _("SY0105") ?>')) {
                                $.ajax({
                                    url: 'modules/survey_insert.php',
                                    data: {"survey_id": sid, "allanswers": allAns},
                                    dataType: "html",
                                    contentType: "application/json",
                                    type: 'GET',
                                    success: function (data) {
                                        relocate();
                                    }
                                });
                            }
                        }
                    }
                });

                $("#submit_all").click(function () {
                    var ans_no_flag = false;
                    var sub = false;
                    var qids = [];
                    var allanswers = [];

                    $('.survey_all_qus>div').each(function () {
                        qids.push($(this).attr('name'));
                    });
                    // $('span[class="error_message"]').css("display", "none");
                    $('.error_message').css("display", "none");
                    $.each(qids, function (index, value) {
                        var mainObject = new Object();

                        mainObject.qid = value;
                        mainObject.option = [];
                        if ($('input[name="R_' + value + '"]').length > 0) {
                            if ($('input[name="R_' + value + '"]:checked').length > 0) {
                                $('input[name="R_' + value + '"]:checked').each(function () {
                                    var userString = $('input[name="R_' + value + '"]:checked').val();
                                    var con = userString.toLowerCase();
                                    if (con === 'other' || con === 'others') {
                                        if ($('input[id="' + value + '"]').val() === "") {
                                            sub = true;
                                            $('span[name="' + value + '"]').css("display", "block");
                                        }
                                    }

                                    var ans_op = $(this).attr("class");
                                    var comment = $('input[id="' + value + '"]').val();

                                    var subObj = new Object();

                                    subObj.s_optid = ans_op;
                                    subObj.optid = '';
                                    subObj.comment = comment;
                                    mainObject.option.push(subObj);
                                });
                            } else {
                                var ques_man = $('input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    sub = true;
                                    $('span[name="' + value + '"]').css("display", "block");
                                }
                            }
                        } else if ($('input[name="CH_' + value + '"]').length > 0) {
                            if ($('input[name="CH_' + value + '"]:checked').length > 0) {

                                $('input[name="CH_' + value + '"]:checked').each(function () {
                                    var userString = $('input[name="CH_' + value + '"]:checked').val();
                                    var con = userString.toLowerCase();
                                    if (con === 'other' || con === 'others') {
                                        if ($('input[id="' + value + '"]').val() === "") {
                                            sub = true;
                                            $('span[name="' + value + '"]').css("display", "block");
                                        }
                                    }

                                    var ans_op = $(this).attr("class");
                                    var comment = $('input[id="' + value + '"]').val();

                                    var subObj = new Object();

                                    subObj.s_optid = ans_op;
                                    subObj.optid = '';
                                    subObj.comment = comment;
                                    mainObject.option.push(subObj);
                                });
                            } else {
                                var ques_man = $('input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    sub = true;
                                    $('span[name="' + value + '"]').css("display", "block");
                                }
                            }
                        } else if ($('input[name="L_' + value + '"]').length > 0) {
                            if ($('input[name="L_' + value + '"]:checked').length > 0) {
                                $('input[name="L_' + value + '"]:checked').each(function () {
                                    var subObj = new Object();
                                    subObj.s_optid = '';
                                    subObj.optid = $(this).attr("data-type");
                                    subObj.comment = '';
                                    mainObject.option.push(subObj);
                                });
                            } else {
                                var ques_man = $('input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    sub = true;
                                    $('span[name="' + value + '"]').css("display", "block");
                                }
                            }
                        } else if ($('div[data-type="RK_' + value + '"]').length > 0) {
                            var ans_fl_ras = false;
                            $('input[name="qus_type_7"]').each(function () {
                                var boxes = $('div[data-type="RK_' + value + '"] input[name="qus_type_7"]').filter(function () {
                                    return $(this).val();
                                });
                                var m_r = $('div[data-type="RK_' + value + '"] input[class="max_rank"]').val();

                                if (~~boxes.length === ~~m_r) {
                                    ans_fl_ras = true;
                                }
                                if ($(this).val() !== '') {
                                    var subObj = new Object();
                                    subObj.s_optid = $(this).val();
                                    subObj.optid = $(this).attr("data-type");
                                    subObj.comment = '';
                                    mainObject.option.push(subObj);
                                }
                                if (ans_fl_ras === false) {
                                    var ques_man = $('input[name="man_' + value + '"]').val();
                                    if (ques_man === 'Y') {
                                        sub = true;
                                        $('span[name="' + value + '"]').css("display", "block");
                                    }
                                }
                            });
                        } else if ($('input[name="TXT_' + value + '"]').length > 0) {

                            $('input[name="TXT_' + value + '"]').each(function () {
                                if ($(this).val().trim() !== '') {
                                    var subObj = new Object();

                                    subObj.s_optid = '0';
                                    subObj.optid = '';
                                    subObj.comment = $(this).val();
                                    mainObject.option.push(subObj);
                                } else {
                                    var ques_man = $('input[name="man_' + value + '"]').val();
                                    if (ques_man === 'Y') {
                                        sub = true;
                                        $('span[name="' + value + '"]').css("display", "block");
                                    }
                                }
                            });

                        } else if ($('textarea[name="TXT_L_' + value + '"]').length > 0) {

                            $('textarea[name="TXT_L_' + value + '"]').each(function () {
                                if ($(this).val().trim() !== '') {
                                    var subObj = new Object();

                                    subObj.s_optid = '0';
                                    subObj.optid = '';
                                    subObj.comment = $(this).val();
                                    mainObject.option.push(subObj);
                                } else {
                                    var ques_man = $('input[name="man_' + value + '"]').val();
                                    if (ques_man === 'Y') {
                                        sub = true;
                                        $('span[name="' + value + '"]').css("display", "block");
                                    }
                                }
                            });

                        } else if ($('div[id="drop_' + value + '"]').length > 0) {
                            var ans_fl = false;
                            $('.survey_all_qus select[data-type="qus_type_6"] option:selected ').each(function () {

                                if ($(this).val() !== '') {
                                    ans_fl = true;
                                    var subObj = new Object();

                                    subObj.s_optid = $(this).text();
                                    subObj.optid = $(this).val();
                                    subObj.comment = '';
                                    mainObject.option.push(subObj);
                                }
                                if (ans_fl === false) {
                                    var ques_man = $('input[name="man_' + value + '"]').val();
                                    if (ques_man === 'Y') {
                                        sub = true;
                                        $('span[name="' + value + '"]').css("display", "block");

                                    }
                                }
                            });

                        } else {
                            var ans_fl = false;
                            $('select[id="select_' + value + '"]').each(function () {
                                var comment = '';
                                var userString = $(this).text();
                                var con = userString.toLowerCase();
                                if (con === 'other' || con === 'others') {
                                    if ($('.current input[id="' + qu_id + '"]').val() === "") {
                                        man = true;
                                        $('.current span[name="' + qu_id + '"]').css("display", "block");
                                    } else {
                                        comment = $('input[id="' + value + '"]').val();
                                    }
                                }
                                if ($(this).val() !== '') {
                                    ans_fl = true;
                                    var subObj = new Object();

                                    subObj.s_optid = $(this).val();
                                    subObj.optid = '';
                                    subObj.comment = comment;
                                    mainObject.option.push(subObj);
                                }
                                if (ans_fl === false) {
                                    var ques_man = $('input[name="man_' + value + '"]').val();
                                    if (ques_man === 'Y') {
                                        sub = true;
                                        $('span[name="' + value + '"]').css("display", "block");
                                    }
                                }
                            });

                        }

                        allanswers.push(mainObject);
                    });
                    //alert(allanswers);
                    var allAns = JSON.stringify(allanswers);
                    //        alert(allAns);
                    var sid = <?php echo $survey_id; ?>;
                    //        alert(sid);
                    if (sub === false) {
                        submitted = true;
                        $.each(qids, function (index, value) {
                            ans_no_flag = EmptyAnswerCheck(value);
                            if (ans_no_flag === true) {
                                return false;
                            }
                        });
                        if (ans_no_flag === false) {
                            alert("<?php echo _("SY0107") ?>");
                        } else {
                            if (confirm('<?php echo _("SY0105") ?>')) {
                                $.ajax({
                                    url: 'modules/survey_insert.php',
                                    data: {"survey_id": sid, "allanswers": allAns},
                                    dataType: "html",
                                    contentType: "application/json",
                                    type: 'GET',
                                    success: function (data) {
                                        relocate();
                                    }
                                });
                            }
                        }
                    }
                });
                $("#submit_group").click(function () {
                    var ans_no_flag = false;
                    var man = false;
                    var qu_id = [];
                    $('.survey_group .current>div').each(function () {
                        qu_id.push($(this).attr('name'));
                    });
                    //   $('.current span[class="error_message"]').css("display","none");
                    $('.error_message').css("display", "none");
                    $.each(qu_id, function (index, value) {
                        //Radio button
                        if ($(' input[name="R_' + value + '"]').length > 0) {
                            if (!$(' input[name="R_' + value + '"]:checked').length > 0) {
                                var ques_man = $('.current input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            } else {
                                var userString = $('.current input[name="R_' + value + '"]:checked').val();
                                var con = userString.toLowerCase();
                                if (con === 'other' || con === 'others') {
                                    if ($(' input[id="' + value + '"]').val() === "") {
                                        $(' span[name="' + value + '"]').css("display", "block");
                                        man = true;
                                    }
                                }
                            }
                        }
                        //Likert
                        if ($(' input[name="L_' + value + '"]').length > 0) {
                            if (!$(' input[name="L_' + value + '"]:checked').length > 0) {
                                var ques_man = $('.current input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        }
                        //checkbox
                        if ($(' input[name="CH_' + value + '"]').length > 0) {
                            if (!$(' input[name="CH_' + value + '"]:checked').length > 0) {
                                var ques_man = $(' input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            } else {
                                var userString = $(' input[name="CH_' + value + '"]:checked').val();
                                var con = userString.toLowerCase();
                                if (con === 'other' || con === 'others') {
                                    if ($(' input[id="' + value + '"]').val() === "") {
                                        $(' span[name="' + value + '"]').css("display", "block");
                                        man = true;
                                    }
                                }
                            }
                        }
                        //Ranking with select
                        var ans_fl_ras = false;
                        $('div[data-type="RK_' + value + '"] input[name="qus_type_7"]').each(function () {

                            var boxes = $('div[data-type="RK_' + value + '"] input[name="qus_type_7"]').filter(function () {
                                return $(this).val();
                            });
                            var m_r = $('div[data-type="RK_' + value + '"] input[class="max_rank"]').val();

                            if (~~boxes.length === ~~m_r) {
                                ans_fl_ras = true;
                            }
                            if (ans_fl_ras === false) {
                                var ques_man = $(' input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        });
                        //Ranking all
                        $('div[id="drop_' + value + '"] select[data-type="qus_type_6"] option:selected ').each(function () {
                            var ans_fl = false;
                            if ($(this).val() !== '') {
                                ans_fl = true;
                            }
                            if (ans_fl === false) {
                                var ques_man = $(' input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        });
                        //Textbox
                        $(' input[name="TXT_' + value + '"]').each(function () {
                            if ($(this).val().trim() === '') {
                                var ques_man = $(' input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $('span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        });
                        //Long free text
                        $(' textarea[name="TXT_L_' + value + '"]').each(function () {
                            if ($(this).val().trim() === '') {
                                var ques_man = $(' input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        });
                        //drop down
                        $(' select[id="select_' + value + '"]').each(function () {
                            if ($(this).val() === '') {
                                var ques_man = $(' input[name="man_' + value + '"]').val();
                                if (ques_man === 'Y') {
                                    $(' span[name="' + value + '"]').css("display", "block");
                                    man = true;
                                }
                            } else {
                                var userString = $(this).text();
                                var con = userString.toLowerCase();
                                if (con === 'other' || con === 'others') {
                                    if ($(' input[id="' + value + '"]').val() === "") {
                                        $(' span[name="' + value + '"]').css("display", "block");
                                        man = true;
                                    }
                                }
                            }
                        });
                    });
                    var qids = [];
                    var allanswers = [];

                    $('.survey_group .survey_group_div>div').each(function () {
                        qids.push($(this).attr('name'));
                    });
                    if (man === false) {
                        submitted = true;
                        $('.current span[class="error_message"]').css("display", "none");
                        $.each(qids, function (index, value) {
                            ans_no_flag = EmptyAnswerCheck(value);
                            if (ans_no_flag === true) {
                                return false;
                            }
                        });
                        if (ans_no_flag === false) {
                            alert("<?php echo _("SY0107") ?>");
                        } else {
                            $.each(qids, function (index, value) {
                                var mainObject = new Object();

                                mainObject.qid = value;
                                mainObject.option = [];

                                mainObject = answerResponse(value);

                                allanswers.push(mainObject);
                            });
                            var allAns = JSON.stringify(allanswers);
                            var sid = <?php echo $survey_id; ?>;
                            if (confirm('<?php echo _("SY0105") ?>')) {
                                $.ajax({
                                    url: 'modules/survey_insert.php',
                                    data: {"survey_id": sid, "allanswers": allAns},
                                    dataType: "html",
                                    contentType: "application/json",
                                    type: 'GET',
                                    success: function (data) {
                                        relocate();
                                    }
                                });
                            }
                        }
                    }
                });
            </script>
            <script>
                function checkMandatory(qu_id) {
                    var man = false;
                    //Radio button
                    if ($('input[name="R_' + qu_id + '"]').length > 0) {
                        if (!$('input[name="R_' + qu_id + '"]:checked').length > 0) {
                            var ques_man = $('.current input[name="man_' + qu_id + '"]').val();
                            if (ques_man === 'Y') {
                                $('span[name="' + qu_id + '"]').css("display", "block");
                                man = true;
                            }
                        } else {
                            var userString = $('.current input[name="R_' + qu_id + '"]:checked').val();
                            var con = userString.toLowerCase();
                            if (con === 'other' || con === 'others') {
                                if ($('input[id="' + qu_id + '"]').val() === "") {
                                    $('span[name="' + qu_id + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        }
                    }
                    //Likert
                    if ($(' input[name="L_' + qu_id + '"]').length > 0) {
                        if (!$(' input[name="L_' + qu_id + '"]:checked').length > 0) {
                            var ques_man = $('.current input[name="man_' + qu_id + '"]').val();
                            if (ques_man === 'Y') {
                                $(' span[name="' + qu_id + '"]').css("display", "block");
                                man = true;
                            }
                        }
                    }
                    //checkbox
                    if ($(' input[name="CH_' + qu_id + '"]').length > 0) {
                        if (!$(' input[name="CH_' + qu_id + '"]:checked').length > 0) {
                            var ques_man = $(' input[name="man_' + qu_id + '"]').val();
                            if (ques_man === 'Y') {
                                $(' span[name="' + qu_id + '"]').css("display", "block");
                                man = true;
                            }
                        } else {
                            var userString = $(' input[name="CH_' + qu_id + '"]:checked').val();
                            var con = userString.toLowerCase();
                            if (con === 'other' || con === 'others') {
                                if ($(' input[id="' + qu_id + '"]').val() === "") {
                                    $(' span[name="' + qu_id + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        }
                    }
                    //Ranking with select
                    var ans_fl_ras = false;
                    $('div[data-type="RK_' + qu_id + '"] input[name="qus_type_7"]').each(function () {

                        var boxes = $('div[data-type="RK_' + qu_id + '"] input[name="qus_type_7"]').filter(function () {
                            return $(this).val();
                        });
                        var m_r = $('div[data-type="RK_' + qu_id + '"] input[class="max_rank"]').val();

                        if (~~boxes.length === ~~m_r) {
                            ans_fl_ras = true;
                        }
                        if (ans_fl_ras === false) {
                            var ques_man = $(' input[name="man_' + qu_id + '"]').val();
                            if (ques_man === 'Y') {
                                $(' span[name="' + qu_id + '"]').css("display", "block");
                                man = true;
                            }
                        }
                    });
                    //Ranking all
                    $('div[id="drop_' + qu_id + '"] select[data-type="qus_type_6"] option:selected ').each(function () {
                        var ans_fl = false;
                        if ($(this).val() !== '') {
                            ans_fl = true;
                        }
                        if (ans_fl === false) {
                            var ques_man = $(' input[name="man_' + qu_id + '"]').val();
                            if (ques_man === 'Y') {
                                $(' span[name="' + qu_id + '"]').css("display", "block");
                                man = true;
                            }
                        }
                    });
                    //Textbox
                    $(' input[name="TXT_' + qu_id + '"]').each(function () {
                        if ($(this).val().trim() === '') {
                            var ques_man = $(' input[name="man_' + qu_id + '"]').val();
                            if (ques_man === 'Y') {
                                $('span[name="' + qu_id + '"]').css("display", "block");
                                man = true;
                            }
                        }
                    });
                    //Long free text
                    $(' textarea[name="TXT_L_' + qu_id + '"]').each(function () {
                        if ($(this).val().trim() === '') {
                            var ques_man = $(' input[name="man_' + qu_id + '"]').val();
                            if (ques_man === 'Y') {
                                $(' span[name="' + qu_id + '"]').css("display", "block");
                                man = true;
                            }
                        }
                    });
                    //drop down
                    $(' select[id="select_' + qu_id + '"]').each(function () {
                        if ($(this).val() === '') {
                            var ques_man = $(' input[name="man_' + qu_id + '"]').val();
                            if (ques_man === 'Y') {
                                $(' span[name="' + qu_id + '"]').css("display", "block");
                                man = true;
                            }
                        } else {
                            var userString = $(this).text();
                            var con = userString.toLowerCase();
                            if (con === 'other' || con === 'others') {
                                if ($(' input[id="' + qu_id + '"]').val() === "") {
                                    $(' span[name="' + qu_id + '"]').css("display", "block");
                                    man = true;
                                }
                            }
                        }
                    });
                    return man;
                }

                function answerResponse(value) {
                    var mainObject = new Object();

                    mainObject.qid = value;
                    mainObject.option = [];

                    if ($('input[name="R_' + value + '"]').length > 0) {

                        if ($('input[name="R_' + value + '"]:checked').length > 0) {

                            $('input[name="R_' + value + '"]:checked').each(function () {

                                var ans_op = $(this).attr("class");
                                var comment = $('input[id="' + value + '"]').val();
                                var subObj = new Object();

                                subObj.s_optid = ans_op;
                                subObj.optid = '';
                                subObj.comment = comment;
                                mainObject.option.push(subObj);
                            });
                        }
                    } else if ($('input[name="CH_' + value + '"]').length > 0) {
                        if ($('input[name="CH_' + value + '"]:checked').length > 0) {

                            $('input[name="CH_' + value + '"]:checked').each(function () {
                                var ans_op = $(this).attr("class");
                                var comment = $('input[id="' + value + '"]').val();

                                var subObj = new Object();

                                subObj.s_optid = ans_op;
                                subObj.optid = '';
                                subObj.comment = comment;
                                mainObject.option.push(subObj);
                            });
                        }
                    } else if ($('input[name="L_' + value + '"]').length > 0) {
                        if ($('input[name="L_' + value + '"]:checked').length > 0) {

                            $('input[name="L_' + value + '"]:checked').each(function () {

                                var subObj = new Object();

                                subObj.s_optid = '';
                                subObj.optid = $(this).attr("data-type");
                                subObj.comment = '';
                                mainObject.option.push(subObj);
                            });

                        }
                    } else if ($('div[data-type="RK_' + value + '"]').length > 0) {
                        $('div[data-type="RK_' + value + '"] input[name="qus_type_7"]').each(function () {
                            if ($(this).val() !== '') {
                                var subObj = new Object();

                                subObj.s_optid = $(this).val();
                                subObj.optid = $(this).attr("data-type");
                                subObj.comment = '';
                                mainObject.option.push(subObj);
                            }
                        });
                    } else if ($('input[name="TXT_' + value + '"]').length > 0) {

                        $('input[name="TXT_' + value + '"]').each(function () {
                            var subObj = new Object();

                            subObj.s_optid = '0';
                            subObj.optid = '';
                            subObj.comment = $(this).val();
                            mainObject.option.push(subObj);
                        });
                    } else if ($('textarea[name="TXT_L_' + value + '"]').length > 0) {
                        $('textarea[name="TXT_L_' + value + '"]').each(function () {
                            var subObj = new Object();

                            subObj.s_optid = '0';
                            subObj.optid = '';
                            subObj.comment = $(this).val();
                            mainObject.option.push(subObj);
                        });
                    } else if ($('div[id="drop_' + value + '"]').length > 0) {
                        $('div[id="drop_' + value + '"] select[data-type="qus_type_6"] option:selected ').each(function () {
                            if ($(this).val() !== '') {
                                var subObj = new Object();

                                subObj.s_optid = $(this).text();
                                subObj.optid = $(this).val();
                                subObj.comment = '';
                                mainObject.option.push(subObj);
                            }
                        });
                    } else {
                        $('select[id="select_' + value + '"]').each(function () {
                            var comment = '';

                            comment = $('input[id="' + value + '"]').val();

                            if ($(this).val() !== '') {
                                var subObj = new Object();

                                subObj.s_optid = $(this).val();
                                subObj.optid = '';
                                subObj.comment = comment;
                                mainObject.option.push(subObj);
                            }
                        });
                    }
                    return mainObject;
                }

                function relocate() {
                    if (is_end_msg !== '') {
                        $('#end_msg').css("display", "block");
                        $('#questions').css("display", "none");
                    } else {
                        window.opener.location.href = is_reload_page + ".php";
                        window.opener.location.reload(true);
                        window.close();
                    }
                }

                function EmptyAnswerCheck(qu_id) {
                    var ans_no_flag = false;
                    //Radio button
                    if ($(' input[name="R_' + qu_id + '"]').length > 0) {
                        if ($(' input[name="R_' + qu_id + '"]:checked').length > 0) {
                            ans_no_flag = true;
                        }
                    }
                    //Likert
                    if ($(' input[name="L_' + qu_id + '"]').length > 0) {
                        if ($(' input[name="L_' + qu_id + '"]:checked').length > 0) {
                            ans_no_flag = true;
                        }
                    }
                    //checkbox
                    if ($(' input[name="CH_' + qu_id + '"]').length > 0) {
                        if ($(' input[name="CH_' + qu_id + '"]:checked').length > 0) {
                            ans_no_flag = true;
                        }
                    }
                    //Ranking with select
                    $('div[data-type="RK_' + qu_id + '"] input[name="qus_type_7"]').each(function () {
                        var boxes = $('div[data-type="RK_' + qu_id + '"] input[name="qus_type_7"]').filter(function () {
                            return $(this).val();
                        });
                        if (~~boxes.length !== 0) {
                            ans_no_flag = true;
                        }
                    });
                    //Ranking all
                    $('div[id="drop_' + qu_id + '"] select[data-type="qus_type_6"] option:selected ').each(function () {
                        var ans_fl = false;
                        if ($(this).val() !== '') {
                            ans_fl = true;
                        }
                        if (ans_fl === true) {
                            ans_no_flag = true;
                        }
                    });
                    //Textbox
                    $(' input[name="TXT_' + qu_id + '"]').each(function () {
                        if ($(this).val() !== '') {
                            ans_no_flag = true;
                        }
                    });
                    //Long free text
                    $('textarea[name="TXT_L_' + qu_id + '"]').each(function () {
                        if ($(this).val() !== '') {
                            ans_no_flag = true;
                        }
                    });
                    //drop down
                    $('select[id="select_' + qu_id + '"]').each(function () {
                        if ($(this).val() === '') {
                            ans_no_flag = false;
                        } else {
                            ans_no_flag = true;
                        }
                    });
                    return ans_no_flag;
                }
            </script>

            <script>
                window.onbeforeunload = function (e) {
                    e = e || window.event;
                    if (submitted === false) {
                        // For IE and Firefox prior to version 4
                        if (e) {
                            e.returnValue = 'Sure?';
                        }
                        // For Safari
                        return 'Sure?';
                    }
                };
            </script>
        </body>

    </html>
    <?php
}?>