<?php
session_start();
include 'config/database.php';
include_once 'config/properties.php';
include_once "resources/assessment.php";
include_once "resources/manageusers.php";
include_once "resources/EncryptDecrypt.php";

$assessment = new Assessment();
$users = new ManageUsers();

if (!isset($_SESSION['uid'])) {
    header('Location: 404.php');
}

$id = $_SESSION['uid'];
$oid = $_GET['oid'];
$attm = $_GET['attm'];
$aid = $_GET['aid'];
$res = null;
$per = null;
$pass_score = null;
$max_attm = null;
$is_scorm = null;

$assessment->offering_id = $oid;
$assessment->attempt_no = $attm;
$assessment->user_id = $id;
$assessment->assessment_id = $aid;

$stmt = $assessment->get_score();
if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    extract($row);
    $per = $score;
}

$stmt = $assessment->get_offer_detail();
if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    extract($row);
    $pass_score = $passing_score;
    $max_attm = $max_attempts;
    $is_scorm = $is_scorm;
}
if ($per >= $pass_score) {
    $res = "Pass";
} else {
    $res = "Fail";
}
?>
<html lang="en">
    <head>
        <?php include "./head.php" ?>
        <title>
            <?php _("TB103") ?>
        </title>
        <?php include "./menu_secondary.php" ?>
    </head>
    <body>
        <?php
        $rm_attempts = $max_attm - $attm;
        echo "<input type='hidden' id='res' value='$res' /> ";
        echo "<input type='hidden' id='attm_ex' value='" . $rm_attempts . "' /> ";
        echo "<input type='hidden' id='oid' value='$oid' /> ";
        echo "<input type='hidden' id='is_scorm' value='$is_scorm' /> ";
        ?>
        <div class="container py-10 x-gap-40 bg-light-9 rounded-8 mb-50 mt-20">
            <div class="row y-gap-30 mb-0">

                <div class="col-xl-12 col-lg-12 px-0">
                    <div class="rounded-8 bg-white -dark-bg-dark-1 shadow-4">
                        <div class="py-20 px-20 border-bottom-light text-center">
                            <h2 class="text-40 lh-12 text-red-1"><?php echo _("AS0130") ?></h2>
                        </div>

                        <p class="py-40 px-40 border-bottom-light text-center text-20"><?php echo _("AS0401") ?></p>

                        <div class="d-flex justify-center items-center py-30 assmt_nav_button">
                            <button class="button -icon bg-color-primary h-40 text-white px-40" id="prev">
                                <?php echo _("AS0131") ?>
                            </button>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <?php include "./footer_secondary.php" ?>
        <script>
            $('#prev').click(function () {
                var res1 = $('#res').val();
                var is_scorm1 = $('#is_scorm').val();
                if (is_scorm1 === "No") {
                    if (res1 === "Pass") {
                        window.location = "courses.php?mode=complete";
                    } else {
                        var attem_ex1 = $('#attm_ex').val();
                        if (attem_ex1 === "0") {
                            window.location = "courses.php?mode=incomplete";
                        } else {
                            window.location = "home.php";
                        }
                    }
                } else {
                    window.location = "home.php";
                }
            });
        </script>
    </body>
</html>

