<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
// start session
session_start();

include_once "config/database.php";
include_once "resources/assessment.php";
include_once 'config/properties.php';
require_once 'config/i18n.php';

// initialize objects
$assessment = new Assessment();
if (!isset($_SESSION['uid'])) {
    header("Location: index.php");
} else {
// set page title
    $user_id = $_SESSION['uid'];
?>
<!DOCTYPE >
<html lang="en">

<head>
    <?php include "./head.php" ?>
    
    <link rel="stylesheet" href="assets/css/assessment/style.css">
    <link rel="stylesheet" href="assets/css/glightbox.css">
    
    <title><?php echo _("CRT2109"); ?></title>
    <style type="text/css">
        @media (width> 1400px) {
            .container {
                width: 1320px;
            }
        }
          </style>
</head>

<body>
    <!-- preloader start -->
    <div class="preloader js-preloader">
        <div class="preloader__bg" style="transform: scale(1, 0);"></div>
    </div>
    <!-- preloader end -->

    <div class="container py-10 x-gap-40 bg-light-9 rounded-8 mb-50 mt-20">
        <div class="row y-gap-30 mb-20">
            <?php
            $id = $_SESSION['uid'];
            $assmt_path = $properties['jdbc.admin'] . $properties['jdbc.assessment_folder'];
            ?>
            <div class="col-xl-12 col-lg-12 px-0">
                <div class="rounded-8 bg-white -dark-bg-dark-1 shadow-4">
                    <div class="d-flex items-center py-10 px-20 border-bottom-light">
                        <h2 class="text-17 lh-1 fw-500 mt-10 mb-5" ><?php echo _("AS0112");?><span id="qs"></span></h2>
                    </div>
                     
                    <div class="py-20 px-20">
                    
                        <div class="ques_group" >
                            <?php
                            $oid = $_GET['oid'];
                            $aid = $_GET['aid'];
                            $result = $_GET['result'];  //0 means Active
                            $count = 1;
                            $assessment->offering_id = $oid;
                            $assessment->assessment_id = $aid;
                            $no_questions = $assessment->get_no_questions();
                            $stmt = $assessment->get_all_questions();
                                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                    extract($row);
                            ?>
                            <div class="border-light-2 overflow-hidden rounded-8 question" id="<?php echo $question_id ?>" name="<?php echo $sequence_id ?>">
                                <div class="py-15 px-20 bg-light-3">
                                    <div class="d-flex justify-between">
                                        <h4 class="text-14 fw-500 text-black"><?php echo _("AS0112")." ".$sequence_id ?></h4>
                                    </div>
                                    <div class="text-18 lh-12 text-black mt-5 mb-10"><?php echo htmlentities($question_text) ?></div>
                                    <!--question image-->
                                    <?php if ($question_image != "") { 
                                    echo "<div class='relative assessment_image_div'>";
                                        echo "<a href='$assmt_path/$aid/$question_image' class='js-gallery' data-gallery='gallery1'>";
                                            echo "<img class='' src='$assmt_path/$aid/$question_image' alt='image'>";
                                            echo "<div class='absolute-full-center d-flex justify-center items-center'>";
                                            echo "</div>";
                                        echo "</a>";
                                    echo "</div>";
                                    } ?>
                                </div>
                                <div name="options" class="px-20 py-20">
                                    <?php if ($question_type_id == "1") { 
                                    echo "<div class='mb-20'>"._("AS0113")."</div>";
                                    } else if ($question_type_id == "2") {
                                    echo "<div class='mb-20'>"._("AS0114")."</div>";     
                                    }
                                    ?>
                                    <?php 
                                    $assessment->question_id = $question_id;
                                    $number = $assessment->get_option_count();
                                    $match_val = 0;

                                    $stmt4 = $assessment->get_options();

                                    if ($question_type_id == "1") {
                                        while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                            extract($row4);
                                            $count1 = $count++;
                                            $value_radio = "";
                                            if ($option_desc != "") {
                                                $value_radio = $option_desc;
                                            } else {
                                                $value_radio = $option_image;
                                            }
                                            echo "<div class='form-radio d-flex items-center mt-5'>";
                                                echo "<div class='radio'>";
                                                    echo "<input id='radio{$count1}' type='radio' name='{$question_id}' value='" . htmlentities($value_radio) . "' class='{$question_id}_{$option_id}'>";
                                                    echo "<div class='radio__mark'>";
                                                        echo "<div class='radio__icon'></div>";
                                                    echo "</div>";
                                                echo "</div>";
                                                echo "<div class='text-16 fw-500 ml-12' name='{$question_id}_{$option_id}'>". htmlentities($option_desc);
                                                if ($option_image != "") {
                                                    echo "<div class='relative assessment_image_div_option mt-5'>";
                                                        echo "<a href='$assmt_path/$aid/$option_image' class='w-1/1 js-gallery' data-gallery='gallery2'>";
                                                            echo "<img class='' src='$assmt_path/$aid/$option_image' alt='image'>";
                                                            echo "<div class='absolute-full-center d-flex justify-center items-center'></div>";
                                                        echo "</a>";
                                                    echo "</div>";
                                                }
                                                echo "</div>";
                                                echo "<i class='' name='status{$question_id}_{$option_id}'></i>";
                                            echo "</div>";
                                            echo "<pre><div class='ml-25 mt-5 mb-10' id='feedback{$question_id}_{$option_id}'></div></pre>";
                                        }
                                    }else if($question_type_id == "2"){
                                        while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                        extract($row4);
                                        $count1 = $count++;
                                        $value_checkbox = "";
                                        if ($option_desc != "") {
                                            $value_checkbox = $option_desc;
                                        } else {
                                            $value_checkbox = $option_image;
                                        }
                                        echo "<div class='form-checkbox d-flex items-center mt-5'>";
                                            echo "<div class='checkbox'>";
                                                echo "<input id='checkbox$count1' type='checkbox' name='{$question_id}' value='" . htmlentities($value_checkbox) . "' class='{$question_id}_{$option_id}'>";
                                                echo "<div class='form-checkbox__mark'>";
                                                    echo "<div class='form-checkbox__icon icon-check'></div>";
                                                echo "</div>";
                                            echo "</div>";
                                            echo "<div class='text-16 fw-500 ml-12' name='{$question_id}_{$option_id}'>".htmlentities($option_desc);
                                                if ($option_image != "") {
                                                    echo "<div class='relative assessment_image_div_option mt-5'>";
                                                        echo "<a href='$assmt_path/$aid/$option_image' class='w-1/1 js-gallery' data-gallery='gallery2'>";
                                                            echo "<img class='' src='$assmt_path/$aid/$option_image' alt='image'>";
                                                            echo "<div class='absolute-full-center d-flex justify-center items-center'></div>";
                                                        echo "</a>";
                                                    echo "</div>";
                                                }
                                            echo "</div>";
                                            echo "<i class='' name='status{$question_id}_{$option_id}'></i>";
                                        echo "</div>";
                                        echo "<pre><div class='ml-25 mt-5 mb-10' id='feedback{$question_id}_{$option_id}'></div></pre>";
                                        }
                                    } else if ($question_type_id == "3") {
                                        echo "<div class='table-responsive mt-20'>";
                                            echo "<table class='table_mf_ques w-1/1'>";
                                                echo "<colgroup>";
                                                    echo "<col style='width:40%'>";
                                                    echo "<col style='width:40%'>";
                                                echo "</colgroup>";
                                                echo "<thead>";
                                                    echo "<tr>";
                                                        echo "<th>Section A</th>";
                                                        echo "<th>Section B</th>";
                                                    echo "</tr>";
                                                echo "</thead>";
                                                echo "<tbody>";
                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                extract($row4);
                                                $match_val1 = $match_val++;
                                                if ($number > $match_val1) {
                                                    echo "<tr class='bg-white shadow-1 rounded-8 border-light'>";
                                                        echo "<td class='text-16' name='left_option{$question_id}' id='{$option_id}'>" . htmlentities($option_desc);
                                                        if ($option_image != "") {
                                                            echo "<div class='relative assessment_image_div_option mt-5'>";
                                                                echo "<a href='$assmt_path/$aid/$option_image' class='w-1/1 js-gallery' data-gallery='gallery2'>";
                                                                    echo "<img class='' src='$assmt_path/$aid/$option_image' alt='image'>";
                                                                    echo "<div class='absolute-full-center d-flex justify-center items-center'></div>";
                                                                echo "</a>";
                                                            echo "</div>";
                                                        }
                                                        echo "</td>";
                                                        $stmt5 = $assessment->get_MF_options();
                                                        echo "<td >";
                                                            echo "<select class='form-control text-16' name='option_MF{$match_val1}_{$question_id}' id='{$question_id}'>";
                                                                echo "<option value=''>--Select Option--</option>";
                                                                while ($row5 = $stmt5->fetch(PDO::FETCH_ASSOC)) {
                                                                extract($row5);
                                                                echo " <option value='{$option_id}'>" . htmlentities($option_desc) . "</option>";
                                                                }
                                                            echo "</select>";
                                                            echo "<i class='' ></i>";
                                                        echo "</td>";
                                                    echo "</tr>";
                                                }
                                                }
                                                echo "</tbody>";
                                            echo "</table>";
                                        echo "</div>";
                                        echo "<div id='MF_answer$question_id'>";
                                        echo "</div>";
                                    } else if ($question_type_id == "4" || $question_type_id == "5") {
                                        $serial_no = 1;
                                        while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                            extract($row4);
                                            $count1 = $count++;
                                                echo "<form class='contact-form'>";
                                                    echo "<div class='d-flex items-center'>";
                                                        echo "<div class='col-lg-10 pl-0'>";
                                                            echo "<textarea id='text" . $count1 . "' name='FIB_" . $question_id . "' class='text-16' data-type='{$question_id}_{$option_id}' placeholder='Text...' rows='4' cols='80' autocomplete='off'></textarea>";
                                                            echo "<div class='text-16 mt-5' id='answer{$question_id}_{$option_id}'></div>";
                                                            echo "<pre><div class='text-16 mt-5' id='feedback{$question_id}_{$option_id}'></div></pre>";
                                                        echo "</div>";
                                                    echo "</div>";
                                                echo "</form>";
                                        }
                                    }
                                    ?>
                                  
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                               
                        <div class="d-flex justify-start items-center mt-40 assmt_nav_button">
                            <button  class="button -icon bg-color-primary h-40 text-white" id="prev">
                                <i class="fa fa-angle-double-left text-13 mr-5"></i>
                                <?php echo _("AS0116") ?>
                            </button>
                            <button  class="button -icon -green-8-1 h-40 text-white ml-10"
                                 id="show_ans">
                                <i class="fa fa-check text-13 mr-5"></i>
                                <?php echo _("AS0117") ?>
                            </button>
                            <button  class="button -icon bg-color-primary h-40 text-white ml-10"
                                id="next" >
                                <?php echo _("AS0118") ?>
                                <i class="fa fa-angle-double-right text-13 ml-5"></i>
                            </button>                        
                        </div>
                        
                    </div>
                </div>
            </div>

        </div>
    </div>

    <script src="assets/js/jquery-3.6.3.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/vendors.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/glightbox.min.js"></script>
    <script>
//        var current_qs_no="";
        $(document).ready(function () {
            $('.ques_group div:first').css("display", "block");
            $('.ques_group div:first').addClass('current');
            $("#prev").attr("disabled", "disabled");
            $("#prev").removeClass("bg-color-primary").addClass("disabled-btn");
            setPageqs();
//            current_qs_no=$('.current').attr("name");
//            $('#qs').html(" "+current_qs_no+ " of " +<?php echo $no_questions?>);
        });
        function setPageqs(){
            var current_qs_no=$('.current').attr("name");
            $('#qs').html(" "+current_qs_no+ " of " +<?php echo $no_questions?>);
        }
        $("#next").click(function () {
             var no = $(".current").attr('id');
                if ($('input[name="' + no + '"]').length > 0) {
                    if (!$("input[name=" + no + "]:checked").length > 0) {
                        alert("<?php echo _("AS0104"); ?>");
                    } else if (!$("input[name=" + no + "]").prop('disabled') === true) {
                        alert("<?php echo _("AS0105"); ?>");
                    } else {
                      $(".current div[name='options']").addClass('attempted');
                        $(".current").removeClass("current").hide().next().addClass("current").show();
                         setPageqs();
                        if ($(".current").next().length != 1) {
//                            $("#next").addclass("disable");
                              $("#next").attr("disabled", "disabled");
                              $("#next").removeClass("bg-color-primary").addClass("disabled-btn");
                        }
//                        $("#prev").removeClass("disable");
                        $("#prev").removeAttr("disabled");
                        $("#prev").removeClass("disabled-btn").addClass("bg-color-primary");
                    }
                } else if ($('textarea[name="FIB_' + no + '"]').length > 0) {
                    var inputvalue = 0;
                    $('textarea[name="FIB_' + no + '"]').each(function () {
                        if ($(this).val() == '') {
                            inputvalue = 0;
                            return false;
                        } else {
                            inputvalue = 1;
                        }
                    });
                    if (inputvalue == 0) {
                        alert("<?php echo _("AS0106"); ?>");
                    } else if (!$('textarea[name="FIB_' + no + '"]').prop('disabled') == true) {
                        alert("<?php echo _("AS0105"); ?>");
                    } else {
                        $(".current div[name='options']").addClass('attempted');
                        $(".current").removeClass("current").hide().next().addClass("current").show();
                         setPageqs();
                        if ($(".current").next().length != 1) {
//                            $("#next").addclass("disable");
                              $("#next").attr("disabled", "disabled");
                              $("#next").removeClass("bg-color-primary").addClass("disabled-btn");
                        }
//                        $("#prev").removeAttr("disable");
                        $("#prev").removeAttr("disabled");
                        $("#prev").removeClass("disabled-btn").addClass("bg-color-primary");
                    }
                } else {
                    var inputvalue = 0;
                    $('select[id=' + no + ']').each(function () {
                        if ($(this).val() == '') {
                            inputvalue = 0;
                            return false;
                        } else {
                            inputvalue = 1;
                        }
                    });
                    if (inputvalue == 0) {
                        alert("<?php echo _("AS0106"); ?>");
                    } else if (!$("select[id=" + no + "]").prop('disabled') == true) {
                        alert("<?php echo _("AS0105"); ?>");
                    } else {
                        $(".current div[name='options']").addClass('attempted');
                        $(".current").removeClass("current").hide().next().addClass("current").show();
                         setPageqs();
                        if ($(".current").next().length != 1) {
                            $("#next").attr("disabled", "disabled");
                            $("#next").removeClass("bg-color-primary").addClass("disabled-btn");
                        }
                        $("#prev").removeAttr("disabled");
                        $("#prev").removeClass("disabled-btn").addClass("bg-color-primary");
                    }
                }
//            current_qs_no=$('.current').attr("name");
//            $('#qs').html(" "+current_qs_no+ " of " +<?php echo $no_questions?>);
        });
        $("#prev").click(function () {
            if ($(".current").prev().length == 1) {
                $(".current").removeClass("current").hide().prev().addClass("current").show();
            }
            if ($(".current").prev().length != 1) {
//                $("#prev").addclass("disable");
                $("#prev").attr("disabled", "disabled");
                $("#prev").removeClass("bg-color-primary").addClass("disabled-btn");
            }
             $("#next").removeAttr("disabled");
            $("#next").removeClass("disabled-btn").addClass("bg-color-primary");
            setPageqs();
//            current_qs_no=$('.current').attr("name");
//            $('#qs').html(" "+current_qs_no+ " of " +<?php echo $no_questions?>);
        });
        
        //show answer
         $("#show_ans").click(function () {
            var no = $(".current").attr('id');
            var oid = "<?php echo $oid; ?>";
            var aid = "<?php echo $aid; ?>";
            var result = "<?php echo $result; ?>";
            if ($('input[name="' + no + '"]').length > 0) {
                if (!$("input[name=" + no + "]:checked").length > 0) {
                    alert("<?php echo _("AS0110"); ?>");
                } else {
                    var options = "";
                    var options1 = "";
//                    $("input[name='" + no + "']:checked").each(function () {
//                        var str = $(this).attr("class");
//                        var pieces = str.split(/[\s_]+/);
//                        options = options + pieces[pieces.length - 1] + ",";
//                    });
                    $("input[name='" + no + "']").each(function () {
                        var str = $(this).attr("class");
                        var pieces = str.split(/[\s_]+/);
                        // Check if the input is checked
                        if ($(this).prop("checked")) {
                            options += pieces[pieces.length - 1] + ",";
                        } 
                        options1 += pieces[pieces.length - 1] + ",";
                    });
                    options = options.replace(/,\s*$/, "");
                    options1 = options1.replace(/,\s*$/, "");
                    $.ajax({
                        url: 'modules/quiz_calc_cyu.php',
                        data: {"oid":oid,"aid": aid, "question_id": no, "options": options , "allopt" : options1,"result":result},
                        dataType: "html",
                        contentType: "application/json",
                        type: 'GET',
                        success: function (data) {
                            data = $.trim(data);
                            data = JSON.parse(data);

                            $('input[name=' + no + ']').each(function () {
                                $('input[name=' + no + ']').attr("disabled", true);
                                var checkedValue = $(this).val();
                                var checkedValue1 = $(this).attr("class");
//                                alert($('.'+checkedValue1).is(":checked"));
                                var array = [];
                                array = data.answer;
                                $.each(array, function (i) {
                                    if (checkedValue === array[i]) {
//                                        alert(checkedValue1);
                                        $('div[name=' + checkedValue1 + ']').removeClass('border-red-1');
                                        $('i[name=status'+ checkedValue1+']').removeClass('text-red-1');
                                        $('div[name=' + checkedValue1 + ']').addClass('border-green-1 items-center px-10 py-5 rounded-16');
//                                        $('div[name=' + checkedValue1 + ']').closest('i').addClass('fa fa-check-circle-o text-22 ml-5 text-green-5');
                                        $('i[name=status'+ checkedValue1+']').addClass('fa fa-check-circle-o text-22 ml-5 text-green-5');
                                        return false;
                                    }
                                    if (($('.' + checkedValue1).is(":checked")) && (checkedValue !== array[i])) {
                                        $('div[name=' + checkedValue1 + ']').addClass('border-red-1 items-center px-10 py-5 rounded-16');
//                                        $('div[name=' + checkedValue1 + ']').closest('i').addClass('fa fa-times-circle-o text-18 ml-5 text-red-1');
                                        $('i[name=status'+ checkedValue1+']').addClass('fa fa-times-circle-o text-22 ml-5 text-red-1');
                                    } else if (checkedValue !== array[i]) {
                                        
                                    }
                                });
                            });

                            var checked_ids = [];
                            $("input[name='" + no + "']:checked").each(function () {
                                checked_ids.push($(this).attr("class"));
                            });

                            var array1 = [];
                            array1 = data.feedback;
                            $.each(array1, function (i) {
                                $('#feedback' + checked_ids[i] + '').html(array1[i]);
                            });
                        }
                    });
                }
            } else if ($('textarea[name="FIB_' + no + '"]').length > 0) {
                var inputvalue = 0;
                $('textarea[name="FIB_' + no + '"]').each(function () {
                    if ($(this).val() == '') {
                        inputvalue = 0;
                        return false;
                    } else {
                        inputvalue = 1;
                    }
                });
                if (inputvalue == 0) {
                    alert("<?php echo _("AS0106"); ?>");
                } else {
                    var options = "";
                    var answers = "";
                    $('textarea[name="FIB_' + no + '"]').each(function () {
                        var str = $(this).attr("data-type");
                        var pieces = str.split(/[\s_]+/);
                        options = options + pieces[pieces.length - 1] + ",";
                        answers = answers + $(this).val() + ",";
                    });

                    options = options.replace(/,\s*$/, "");
                    answers = answers.replace(/,\s*$/, "");
                     $.ajax({
                        url: 'modules/quiz_calc_cyu.php',
                        data: {"oid":oid,"aid": aid, "question_id2": no, "options": options, "answers": answers,"result":result},
                        dataType: "html",
                        contentType: "application/json",
                        type: 'GET',
                        success: function (data) {
                            data = $.trim(data);
                            data = JSON.parse(data);
                            var array = [], array2 = [];
                            array = data.result;
                            array2 = data.answer;

                            var checked_ids = [];
                            $('textarea[name="FIB_' + no + '"]').each(function (i) {
                                var qoid = $(this).attr("data-type");
                                checked_ids.push(qoid);
                                $('textarea[name="FIB_' + no + '"]').attr("disabled", true);

                                //$.each(array, function (i) {
                                if (array[i] === "Y") {
				$('textarea[data-type="' + qoid + '"]').removeClass('border-red-1');
                                    $('textarea[data-type="' + qoid + '"]').addClass('border-green-1');
                                } else if (array[i] === "N") {
                                    $('textarea[data-type="' + qoid + '"]').addClass('border-red-1');
                                    $('#answer' + qoid + '').html("<b><?php echo _("CA0112");?>: </b>" + array2[i]);
                                }
                                //});
                            });

                            var array1 = [];
                            array1 = data.feedback;
                            $.each(array1, function (i) {
                                $('#feedback' + checked_ids[i] + '').html(array1[i]);
                            });
                        }
                    });
                }
            } else {
                var inputvalue = 0;
                $('select[id=' + no + ']').each(function () {
                    if ($(this).val() == '') {
                        inputvalue = 0;
                        return false;
                    } else {
                        inputvalue = 1;
                    }
                });
                if (inputvalue == 0) {
                    alert("<?php echo _("AS0106"); ?>");
                } else {
                    var total_dropdown = $('select[id=' + no + ']').length;
                    for (var i = 0; i < total_dropdown; ++i)
                    {
                        sValue = $('select[name=option_MF' + i + '_' + no + ']').val();
                        for (var j = 0; j < total_dropdown; ++j)
                        {
                            sValue2 = $('select[name=option_MF' + j + '_' + no + ']').val();
                            if (i != j && sValue == sValue2)
                            {
                                alert("<?php echo _("AS0108"); ?>");
                                return false;
                            }
                        }
                    }

                    var options = "";
                    var option_ids = [];
                    $("td[name='left_option" + no + "']").each(function () {
                        var str = $(this).attr("id");
                        options = options + str + ",";
                        option_ids.push(str);
                    });
                    var selected = "";
                   $("select[id='" + no + "']").each(function () {
                    var selectedValue = $(this).val();
                       selected = selected + selectedValue + ",";
                });
                    options = options.replace(/,\s*$/, "");
                    selected = selected.replace(/,\s*$/, "");
                    $.ajax({
                        url: 'modules/quiz_calc_cyu.php',
                        data: {"oid":oid,"aid": aid, "question_id1": no, "options": options,"selectedopt":selected,"result":result},
                        dataType: "html",
                        contentType: "application/json",
                        type: 'GET',
                        success: function (data) {
                            data = $.trim(data);
                            data = JSON.parse(data);
                            
                            $('select[id=' + no + ']').each(function () {
                                $('select[id=' + no + ']').attr("disabled", true);
                            });
                            var array = [];
                            array = data.answer;
                            for (var i = 0; i < total_dropdown; ++i)
                            {
                                sValue = $('select[name=option_MF' + i + '_' + no + ']').val();
                                if (sValue === array[i])
                                {
                                    $('select[name=option_MF' + i + '_' + no + ']').addClass('border-green-1');
                                    $('select[name=option_MF'+i+'_'+no+']').closest('td').addClass('d-flex justify-between items-center');
//                                    $('td[name=d' + i + '_' + no + ']').addClass('d-flex justify-between items-center');
                                    $('select[name=option_MF'+i+'_'+no+']').next('i').addClass('fa fa-check-circle-o text-18 ml-5 text-green-5');
//                                    $('i[name=status' + i + '_' + no + ']').addClass('fa fa-check-circle-o text-18 ml-5 text-green-5');
                                } else {
                                    $('select[name=option_MF' + i + '_' + no + ']').addClass('border-red-1');
                                    $('select[name=option_MF'+i+'_'+no+']').closest('td').addClass('d-flex justify-between items-center');
//                                    $('td[name=d' + i + '_' + no + ']').addClass('d-flex justify-between items-center');
//                                    $('i[name=status' + i + '_' + no + ']').addClass('fa fa-times-circle-o text-18 ml-5 text-red-1');
                                    $('select[name=option_MF'+i+'_'+no+']').next('i').addClass('fa fa-times-circle-o text-18 ml-5 text-red-1');

                                }
                            }                        

                            $('#MF_answer' + no).html(data.correct_answer);
                        }
                    });
                }
            }
        });
    </script>
    <script>
    function copyToClipboard() {
        var aux = document.createElement("input");
        aux.setAttribute("value", "Function Disabled.....");
        document.body.appendChild(aux);
        aux.select();
        document.execCommand("copy");
        document.body.removeChild(aux);
        alert("Print screen disabled.");
    }

    $(function ()
    {
        $(this).keyup(function (e) {
            if (e.keyCode === 44 || e.keyCode === 137 || e.KeyCode === 93)
                    //100 Save 137 SHift F10 93 RightClick 44 PrintScreen
                    {
                        copyToClipboard();
                        return false;
                    }
        });
    });
    //    RIGHT CLICK DISABLE
//    $(document).on({
//        "contextmenu": function (e) {
//            e.preventDefault();
//        }
//    });
    //disable Ctrl + keys
    document.onkeydown = function (e) {
        e = e || window.event;//Get event
        if (e.ctrlKey) {
            var c = e.which || e.keyCode;//Get key code
            switch (c) {
                case 83://Block Ctrl+S
                case 80 : //block Ctrl+P
                case 17 : //block Ctrl
                case 16 : //block Shift
                    e.preventDefault();
                    e.stopPropagation();
                    alert("key disabled");
                    break;
            }
        }
    };
    </script>

</body>

</html>
 <?php } ?> 