<?php
session_start();
include '../config/database.php';
include_once '../config/properties.php';
include_once "../resources/offering.php";
include_once "../resources/EncryptDecrypt.php";

if (isset($_SESSION['uid'])) {
    $id = $_SESSION['uid'];
    $mode = $_GET['mode'];
    // initialize objects
    $offering = new Offering();
    $offering->user_id = $_SESSION['uid'];
    if ($mode != "l") {
        $off_id = $_GET['id'];
        $mcrypt = new MCrypt();
        $encrypted_offid = $mcrypt->encrypt($off_id);
        $offering->offering_id = $off_id;
        $medal = FALSE;
        $course_name = "";
        $score = 0;
        $offering_type = "";

        $stmt = $offering->offering_display();
        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $score = $row['score'];
            $course_name = $row['course_name'];
            $offering_type = $row['offering_type'];
        }

        $stmt = $offering->get_grade_cert();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            
            if ($row['cut_off'] <= $score) {

                $medal = TRUE;
                echo "<h4 class='text-center mb-5'>";
                if ($offering_type == 'A') {
                    echo _('CRT5101');
                } else {
                    echo _('HM0114');
                }
                echo ': ' . htmlentities($course_name) . '</h4>';

                echo '<input type="hidden" id="encry_oid" value="' . $off_id . '">';
                echo "<div class='table-responsive mt-20'>";
                echo "<table class='table_report w-1/1 text-center' id='active_scorecard'>";
                echo "<colgroup>
                            <col style='width:30%'>
                            <col style='width:40%'>
                            <col style='width:25%'>
                        </colgroup>";
                echo "<thead class='bg-color-primary'>
                            <tr>
                                <th class='text-center'>" . _("CR0107") . "</th>
                                <th class='text-center'>" . _("CR0108") . "</th>
                                <th class='text-center'>" . _("CR0109") . "</th>
                            </tr>
                        </thead>";
                echo "<tbody>";
                echo "<tr class='bg-white shadow-1 rounded-8 border-light'>";
                echo "<td>" . $row['grade'] . "</td>";
                if ($row['grade_type'] != "Default") {
                    $offering->badge_id = $row['badge_id'];
                    $stmt2 = $offering->getgrade_file_achv();
                    if ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
                        if ($row['grade_type'] == "Gold") {
                            $grade_image = $row2['gold_file'];
                        } else if ($row['grade_type'] == "Silver") {
                            $grade_image = $row2['silver_file'];
                        } else if ($row['grade_type'] == "Bronze") {
                            $grade_image = $row2['bronze_file'];
                        }
                        $filepath = ADMIN_PATH . $properties['jdbc.badge_folder'] . "/" . $row['badge_id'] . "/" . str_replace(" ", "%20", $grade_image);
                        echo "<td>
                                            <div class='cert_div'>
                                                <img src=" . $filepath . ">
                                            </div>
                                        </td>";
                    } else {
                        echo '<td>--</td>';
                    }
                } else {
                    echo '<td>--</td>';
                }
                if ($row['template_id'] != "0") {
                    echo '<td><a href="javascript:void(0)" class="text-purple-1" onClick="downloadCertificate()"><i class="fa fa-eye"></i></a></td>';
                } else {
                    echo '<td>--</td>';
                }
                echo "</tr>";
                echo "</tbody>";
                echo "</table>";
                echo "</div>";
                break;
            }
        }
        if ($medal == FALSE) {
            echo "<h4 class='text-center mb-5'>";
            if ($offering_type == 'A') {
                echo _('CRT5101');
            } else {
                echo _('HM0114');
            }
            echo ': ' . htmlentities($course_name) . '</h4>';
            echo '<input type="hidden" id="encry_oid" value="' . $off_id . '">';
            echo "<div class='table-responsive mt-20'>";
            echo "<table class='table_report w-1/1 text-center' id='active_scorecard'>";
            echo "<colgroup>
                            <col style='width:30%'>
                            <col style='width:40%'>
                            <col style='width:25%'>
                        </colgroup>";
            echo "<thead class='bg-color-primary'>
                            <tr>
                                <th class='text-center'>" . _("CR0107") . "</th>
                                <th class='text-center'>" . _("CR0108") . "</th>
                                <th class='text-center'>" . _("CR0109") . "</th>
                            </tr>
                        </thead>";
            echo "<tbody>";
            echo "<tr class='bg-white shadow-1 rounded-8 border-light'>";
            echo "<td>--</td>";
            echo '<td>--</td>';

            echo '<td><a href="javascript:void(0)" class="text-purple-1" onClick="downloadCertificate()"><i class="fa fa-eye"></i></a></td>';
            echo "</tr>";
            echo "</tbody>";
            echo "</table>";
            echo "</div>";
        }
    } else {
        $d_name = "";
        $certificate = "";
        $stmt = $offering->fetch_designation();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $d_name = $row['designation_name'];
            $offering->designation_id = $row['designation_id'];
            echo "<h4 class='text-center mb-5'>" . _("US0115") . ": $d_name</h4>";
        }
        if ($d_name != "") {
            $stmt = $offering->learning_names_display();
            $num = $stmt->rowCount();
            if ($num > 0) {

                echo "
                <div class='centered-container'>
                    <div class='boxlp'>
                ";

                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    $certificate = "";
                    $learning_path_name = $row['learning_path_name'];
                    $lid = $row['learning_path_id'];
                    $learning_path_name_js = json_encode($learning_path_name);

                    // Check certificate availability
                    $offering->learning_path_id = $lid;

                    // Call the method to check if a certificate exists
                    $stmt_cert = $offering->learning_path_completed();
                    $num_cert = $stmt_cert->rowCount();
                    if ($num_cert > 0) {
                        $certificate = "Yes";
                    }

                    // Display learning path
                    echo "
                    <div class='learning-path-container'>
                        <button onclick='loadLearningPathCourses($lid,$learning_path_name_js)' class='learning-path-button'>
                            $learning_path_name
                        </button>";

                    // Call the certificate function to display the certificate icon
                    certificate($offering, $lid, $certificate);

                    echo "</div>";
                }
                echo "       
                    </div>
                </div>";
                echo "</tbody>";
                echo "</table>";
                echo "</div>";
            } else {
                echo "<p><center>" . _("HM0139") . "</center></p>";
            }
        } else {
            echo "<p><center>" . _("HM0139") . "</center></p>";
        }
    }
}

function certificate($offering, $lid, $completed) {
    if ($completed == "Yes") {
        $stmt5 = $offering->learning_certficate();
        $num5 = $stmt5->rowCount();
        if ($num5 > 0) {
            echo '<td><a href="javascript:void(0)" class="text-purple-1" onClick="ViewCertificate(' . $lid . ')"><i class="fa fa-trophy"></i></a></td>';
        } else {
            echo '<td></td>';
        }
    } else {
        echo '<td></td>';
    }
}
?>
<!-- Modal -->
<div id="get_course" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document" >
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
               
                <!-- Display Learning Path Name here -->
                <p id="learningPathName" class="learningpath-style"></p>
           
            
            <div id="get_course_detail" class="modal-body modal-body-lp"  >
                <!-- Content from AJAX call will be injected here -->
            </div>
                   <!-- Separator Line -->
            <hr class="legend-line">
             <!-- Color Indication Section -->
             <div class="px-3 py-2" >
                <p class="legend-font">Legends:</p>
                <ul class="legend-list">
                  
                    <span class="completed"></span> Completed &nbsp;
                    <span class="incomplete"></span> Incomplete &nbsp;
                    <span class="notassigned"></span> Not Yet Assigned
                    
                </ul>
            </div>
            </div>
            <div class="modal-footer">
                <div class="d-flex justify-center">
                    <button class="text-16 button -icon px-50 py-0 -secondary-1 text-white btn-secondary" data-dismiss="modal"><?php echo _("AS0156") ?></button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Function to load courses dynamically into the modal
    function loadLearningPathCourses(learningPathId, learningPathName) {
        $.ajax({
            url: "modules/get_courses.php",
            data: {id: learningPathId},
            dataType: "html",
            type: "GET",
            success: function (data) {
                $('#get_course_detail').html(data);
                $('#learningPathName').text(learningPathName);
                $('#get_course').modal("show");
            }

        });
    }
    // Close the modal
    $('.close, .btn-secondary, .click').on('click', function (event) {
        event.stopPropagation();
        $('#get_course').modal('hide');
    });

</script>

<script>
    if ($('#active_scorecard').length) {
        if ($('#active_scorecard').find('td').length === 0) {
            var flag = $("#check_score_flag").val();
            $('.modal-footer').remove();
            if (flag === "Yes") {
                $('#active_scorecard tbody').append("<tr><td colspan='7'><center><?php echo _("CR0101") ?></center></td></tr>");
            } else {
                $('#active_scorecard tbody').append("<tr><td colspan='6'><center><?php echo _("CR0101") ?></center></td></tr>");
            }
        }
    }

    function downloadCertificate() {
        var oid = $('#encry_oid').val();
        window.open('certificate/template/?id=' + oid);
    }

    function ViewCertificate(id) {
        window.open('certificate/template/learning.php?id=' + id);
    }
</script>
