<?php
session_start();
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32)); // Generate a random CSRF token
}
$csrfToken = $_SESSION['csrf_token'];

$nonce = base64_encode(random_bytes(16));
header("Content-Type: text/html; charset=utf-8");
header("Content-Security-Policy: default-src 'self'; style-src 'self' https://cdnjs.cloudflare.com/ https://fonts.googleapis.com https://www.google.com/recaptcha/ https://www.gstatic.com/recaptcha/ 'nonce-$nonce'; script-src 'self' https://apis.google.com https://www.google.com/recaptcha/ https://www.gstatic.com/recaptcha/ 'nonce-$nonce'; frame-src 'self' https://www.google.com/recaptcha/; font-src 'self' https://cdnjs.cloudflare.com/ https://fonts.gstatic.com; img-src 'self'; form-action 'self'; object-src 'none'; frame-ancestors 'none'; base-uri 'self';");
header("X-Frame-Options: SAMEORIGIN");

// include objects
include_once "config/database.php";
include_once "resources/EncryptDecrypt.php";
include_once 'config/properties.php';
include_once "resources/offering.php";

if (isset($_SESSION['uid'])) {
    echo '<script>window.location="home.php";</script>';
}

$sanitized_input = "";
$password = "";
if (isset($_GET['username'])) {
    $username = $_GET['username']; // Assume this contains untrusted user input
    if ($username == 'guest') {
        $password = "Guest123";
    } else if ($username == 'visitor') {
        $password = "Visitor123";
    }
    $sanitized_input = htmlspecialchars($username, ENT_QUOTES, 'UTF-8');
}
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width,initial-scale=1.0">
        <!-- Styles -->
        <link rel="stylesheet" href="assets/css/login/style.css">
        <link rel="stylesheet" href="assets/css/main.php">
        <link rel="stylesheet" href="assets/css/subs.css"">
        <link rel="stylesheet" href="assets/css/bootstrap.min.css">
        <!-- Fonts -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
        <title>Login | K-nest LMS</title> 
        <link rel="shortcut icon" href="assets/images/icon_header.png" />
        <style type="text/css" nonce="<?php echo $nonce; ?>">
            .preloader__bg{
                transform: scale(1, 0);
            }
            .masthead__bg{
                border-radius: 0px!important;
                left:0!important;
                right:0!important;
            }
            .bg-image{
                background-image: url(assets/images/bg/login.jpg);
            }
            #username_error, #password_error{
                display: none;
            }
            .masthead-form__group{
                position:relative!important;
            }
        </style>
    </head>

    <body>
        <div class="preloader js-preloader">
            <div class="preloader__bg"></div>
        </div>
        <section data-anim-wrap="" class="masthead -type-2 animated">
            <div class="masthead__bg">
                <div class="bg-image js-lazy loaded" data-ll-status="loaded"></div>
            </div>

            <div class="">
                <div class="row">
                    <div class="col-md-6 left_page">
                        <div class="masthead__content">

                            <h1 data-anim-child="slide-up delay-3" class="masthead__title text-white mt-10 is-in-view">
                                Empowering Your Complete Learning Journey
                            </h1>
                            <div data-anim-child="slide-up delay-2"
                                 class="masthead__subtitle fw-500 text-color-secondary text-20 lh-15 is-in-view">
                                <i class="text-white">A simple, yet elegant learning platform built for you!</i>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 right_page">
                        <div data-anim-child="slide-up delay-6" class="masthead-form is-in-view">
                            <h4 class="masthead-form__title text-center text-20 lh-15 fw-500 mb-20 uppercase" >
                                <?php echo _("LG0121"); ?>
                            </h4>
                            <h6><?php echo _("LG0122"); ?></h6>
                            <form method="post">
                                <div class="masthead-form__group mt-20">
                                    <label><?php echo _("LG0123"); ?></label>
                                    <input type="text" placeholder="Your Mobile No / Email Id / Username" id="username" value="<?php echo $sanitized_input; ?>" required>
                                    <span class="text-red-1" id="username_error"><?php echo _("LG0501") ?></span>
                                </div>

                                <div class="masthead-form__group mt-20">
                                    <label class="uppercase"><?php echo _("LG0124"); ?></label>
                                    <input type="password" placeholder="Your Password" required id="password" autocomplete="on" value="<?php echo $password; ?>">
                                    <i class="fa fa-eye password_toggle togglePassword" toggle="#password"></i>
                                    <span class="text-red-1" id="password_error"><?php echo _("LG0502") ?></span>
                                </div>

                                <div class="masthead-form__group mt-20">
                                    <div class="g-recaptcha" data-sitekey="6LePCPoUAAAAAIXZz4Z1vKyuCxZ01mG1XhlMY4Ig"></div>
                                    <span class="text-red-1" id="error"></span>
                                </div>

                                <p class="pt-20">
                                    <?php echo _("LG0125"); ?>
                                    <a href="forgotusername.php" class="text-color-primary"><?php echo _("LG0137"); ?></a>&nbsp;/
                                    <a href="forgotpassword.php" class="text-color-primary"><?php echo _("LG0141"); ?>?</a>
                                </p>

                                <input type="hidden" name="csrf_token" id="csrf_token" value="<?php echo $csrfToken; ?>">
                                <div class="d-flex x-gap-20 items-center justify-between">
                                    <div>                              
                                        <button type="button" id="login" name="submit" class="button -sm px-24 py-20 text-14 bg-color-primary text-white uppercase">
                                            <?php echo _("LG0126") ?>&nbsp;
                                            <i class="fa fa-spinner fa-spin" id="small_loader" ></i>
                                        </button>
                                    </div>
                                    <div>
                                        <?php echo _("LG0127") ?> &nbsp;
                                        <a href="faq.php" class="text-color-secondary footer_company_link text-18"><?php echo _("LG0142"); ?></a>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <div class="login_page_footer bg-color-secondary">
            <footer class="footer -type-5">
                <div class="container">
                    <div class="pt-30">
                        <div class="row justify-center text-center">
                            <div class="col-auto">
                                <div class="footer-footer__copyright text-center h-100 text-white">
                                    &#169; Copyright 2023. Powered by &nbsp;<a href="https://knestlms.com/" target="_blank" class="text-color-primary footer_company_link">K-nest LMS</a>. All Rights Reserved By
                                    &nbsp;<a href="https://4edgeit.com/" target="_blank" class="text-color-primary footer_company_link"> 4Edge IT Solutions.</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>

        <script src="assets/js/jquery-3.6.3.min.js"></script>
        <script src="assets/js/bootstrap.min.js"></script>
        <script src="assets/js/vendors.js"></script>
        <script src="assets/js/main.js"></script>
        <script nonce="<?php echo $nonce; ?>">
            $('#small_loader').hide();
            $(document).bind('keypress', function (e) {
                if (e.keyCode === 13) {
                    login();
                }
            });
            $('#login').click(function () {
                var error_msg = "";
                $('#error').css({"display": "none"});
                $('#error').html("");

                var username = $("#username").val();
                username = username.trim();
                var password = $("#password").val();
                var csrf_token = $("#csrf_token").val();
                var submit = true;
                if (username == "") {
                    $('#username_error').css({"display": "block"});
                    submit = false;
                } else {
                    $('#username_error').hide();
                }
                if (password == "") {
                    $('#password_error').css({"display": "block"});
                    submit = false;
                } else {
                    $('#password_error').hide();
                }
                if (submit) {
                    $('#small_loader').show();
                    $.post("modules/login.php", {
                        username: username,
                        password: password,
                        csrf_token: csrf_token,
                        captcha: grecaptcha.getResponse()
                    },
                            function (data, status, json) {
                                grecaptcha.reset();
                                $('#small_loader').hide();
                                data = $.trim(data);
                                data = JSON.parse(data);
                                if (data.result1 === "error") {
                                    error_msg = data.result2;
                                    $('#error').css({"display": "block"});
                                    $('#error').html(error_msg);
                                } else {
                                    $('#error').css({"display": "none"});
                                    $('#error').html("");
                                    window.location.href = data.result1;
                                }
                            }
                    );
                }
            });
            $('#username').keypress(function (e) {
                var key = e.which;
                if (key == 13) {
                    login();
                    return false;
                }
            });
            $('#password').keypress(function (e) {
                var key = e.which;
                if (key == 13) {
                    login();
                    return false;
                }
            });
            $(".togglePassword").unbind('click').bind('click', function (e) {
                $(this).toggleClass("fa-eye fa-eye-slash");
                var input = $($(this).attr("toggle"));
                if (input.attr("type") == "password") {
                    input.attr("type", "text");
                } else {
                    input.attr("type", "password");
                }
            });
        </script>
    </body>

</html>