<?php
session_start();
include '../config/database.php';
include_once '../config/properties.php';
include_once "../resources/forum.php";
include_once "../resources/EncryptDecrypt.php";

// initialize objects
$forum = new Forum();

$topic_name = $_GET['topic_name'];
$id = $_GET['user_id'];
$user_id = $_SESSION['uid'];
$fl_name1 = "";
$total_rows = 0;
$forum->user_id = $user_id;
$result_fetch_image = $forum->get_user_detail();
if ($row_fetch_image = $result_fetch_image->fetch(PDO::FETCH_ASSOC)) {
    $fl_name1 = $row_fetch_image['user_image'];
}

// for pagination purposes
$page = isset($_GET['page']) ? $_GET['page'] : 1; // page is the current page, if there's nothing set, default is page 1
$records_per_page = 5; // set records or rows of data per page
$flag = isset($_GET['flag']) ? $_GET['flag'] : 0;
if ($flag == 0) {
    $records_per_page = $records_per_page * $page; // set records or rows of data per page
    $from_record_num = 0;
} else {
    $from_record_num = ($records_per_page * $page) - $records_per_page; // calculate for the query LIMIT clause
}
$filepath1 = DEFAULT_USER_IMAGE;
if ($fl_name1 != "") {
    $filepath1 =  ADMIN_HTTP_PATH . $properties['jdbc.user_image_folder'] . "/" . $fl_name1;
}

if ($topic_name == "" && $id == "") {
    //all questions
    $stmt1 = $forum->get_all_questions($from_record_num, $records_per_page);
    $total_disc = $forum->getCount();
    $count_disc = $from_record_num;
} else if ($topic_name !== "" && $id !== "") {
    // topic_change in my_questions
    $stmt1 = $forum->get_questions_topic_user($topic_name, $id, $from_record_num, $records_per_page);
    $total_disc = $forum->getCount();
    $count_disc = $from_record_num;
} else if ($topic_name != "" && $id == "") {
    // 'topic_change in all questions';
    $stmt1 = $forum->get_questions_topic($topic_name, $from_record_num, $records_per_page);
    $total_disc = $forum->getCount();
    $count_disc = $from_record_num;
} else if ($topic_name == "" && $id != "") {
    //my questions
    $stmt1 = $forum->get_questions_user($id, $from_record_num, $records_per_page);
    $total_disc = $forum->getCount();
    $count_disc = $from_record_num;
}
if ($stmt1->rowCount() > 0) {
    while ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {
        $count_disc++;
        $topic_id = $row1['topic_id'];
        $last_updated_ts_topic = $row1['created_ts'];
        $time = date("d-M-Y h:i A", strtotime($last_updated_ts_topic));
        $id1 = $row1['user_id'];
        $fname2 = $row1['first_name'];
        $lname1 = $row1['last_name'];
        $name1 = $fname2 . " " . $lname1;
        $image1 = $row1['user_image'];
        $filepath2 = DEFAULT_USER_IMAGE;
        if ($image1 != "" || $image1 != NULL) {
            $filepath2 = ADMIN_HTTP_PATH . $properties['jdbc.user_image_folder'] . "/" . $image1;
        }
        ?>
        <input type="hidden" id="total_disc" value="<?php echo $total_disc; ?>">

        <div class="topic border-light-2 px-10 py-15 mt-5">
            <div class="d-flex justify-start">
                <img class="mt-8 fit-cover rounded-full size-50" src="<?php echo $filepath2 ?>"
                     alt="image">
                <div class="px-10 py-5" style="width:100%">
                    <p class="pt-0 mb-5"><?php echo htmlentities($row1['topic_name']); ?></p>
                    <pre class="qus_title"><?php echo htmlentities($row1['topic_title']); ?></pre>
                    <p>by <span class="text-blue-3 forumuser"><?php echo $name1; ?></span> - <?php echo $time; ?></p>
                    <pre class="qus_desc"><?php echo htmlentities($row1['topic_desc']); ?> </pre>
                    <div id="question_length_empty<?php echo $row1['topic_id']; ?>" class="text-red-1 ml-5 mb-5 message">Please enter question title and description.</div>
                    <div class="d-flex justify-start mt-5 mb-10 action_buttons">
                        <a href="javascript:void(0)" class="px-15 text-orange-1 border-light rounded-8 py-5 topic_submit"><i
                                class="fa fa-check"></i> <?php echo _("FR0104"); ?></a>
                        <a href="javascript:void(0)" class="px-15 text-orange-1 border-light rounded-8 py-5 ml-5 topic_cancel"><i
                                class="fa fa-times"></i> <?php echo _("FR0111"); ?></a>
                    </div>
                    <div class="d-flex justify-start topic_buttons py-5">
                        <?php if ($row1['reply'] == 0) { ?>
                            <a href="javascript:void(0)" class="px-8 text-blue-3 border-light mt-5 topic_edit" onclick="topicEdit(this,<?php echo $row1['topic_id']; ?>)" title="<?php echo _("FR0116") ?>"><i
                                    class="fa fa-pencil"></i> <?php echo _("FR0116") ?></a>
                            <a href="javascript:void(0)" class="px-8 text-blue-3 border-light mt-5 ml-5 topic_delete" onclick="topicDelete(this,<?php echo $row1['topic_id']; ?>)" title="<?php echo _("FR0117") ?>"><i
                                    class="fa fa-trash"></i> <?php echo _("FR0117") ?></a>
                            <?php } ?>
                            <?php
                            $check_spam = $forum->check_spam_topic($topic_id, $user_id);
                            if ($check_spam->fetch(PDO::FETCH_ASSOC)) {
                                ?>

                            <a href="javascript:void(0)" class="px-8 text-blue-3 border-light mt-5 ml-5 " onclick="topicRemoveSpam(this,<?php echo $topic_id ?>);" title="<?php echo _("FR0119") ?>"><i
                                    class="fa fa-exclamation"></i> <i class="fa fa-spinner fa-spin" id="loader_tra<?php echo $topic_id ?>" style="display:none;margin-left:5px;"></i><?php echo _("FR0119") ?></a>
                                <?php
                            } else {
                                if ($user_id != $id1) {
                                    ?>
                                <a href="javascript:void(0)" class="px-8 text-blue-3 border-light mt-5 ml-5" onclick="topicReportSpam(this,<?php echo $topic_id ?>);" title="<?php echo _("FR0118") ?>"><i class="fa fa-ban"></i> <i class="fa fa-spinner fa-spin" id="loader_ta<?php echo $topic_id ?>" style="display:none;margin-left:5px;"></i><?php echo _("FR0118") ?></a>
                                <?php
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>

            <div class="replies border-top-light pl-0 ml-35">
                <h4>Replies: </h4>
                <?php
                $forum->topic_id = $topic_id;
                $forum->user_id = $user_id;
                $stmt2 = $forum->get_responses();
                while ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
                    $response_id = $row2['response_id'];
                    $last_updated_ts_reply = $row2['created_ts'];
                    $time1 = date("d-M-Y h:i A", strtotime($last_updated_ts_reply));
                    $id2 = $row2['user_id'];
                    $fname = $row2['first_name'];
                    $lname = $row2['last_name'];
                    $name = $fname . " " . $lname;
                    $image2 = $row2['user_image'];
                    $filepath3 = DEFAULT_USER_IMAGE;
                    if ($image2 != "" || $image2 != NULL) {
                        $filepath3 = ADMIN_HTTP_PATH . $properties['jdbc.user_image_folder'] . "/" . $image2;
                    }
                    ?>
                    <div class="d-flex justify-start mt-20 replies-list">
                        <img class="mt-8 fit-cover rounded-full size-50"
                             src="<?php echo $filepath3 ?>" alt="image">
                        <div class="px-10 py-5" style="width:100%">
                            <pre class="reply_desc"><?php echo htmlentities($row2['response_desc']); ?>
                            </pre>
                            <div id="reply_length_empty_edit<?php echo $row2['response_id']; ?>" class="text-red-1 ml-5 mb-5 message"><?php echo _("FR0504"); ?>.</div>
                            <div class="action_buttons">
                                <a href="javascript:void(0)" class="px-15 text-orange-1 border-light rounded-8 py-5 ml-5 reply_submit"><i
                                        class="fa fa-check"></i> <?php echo _("FR0104"); ?></a>
                                <a href="javascript:void(0)" class="px-15 text-orange-1 border-light rounded-8 py-5 ml-5 reply_cancel"><i
                                        class="fa fa-times"></i> <?php echo _("FR0111"); ?></a>
                            </div>
                            <p>by <span class="text-blue-3 forumuser"><?php echo $name ?></span> - <?php echo $time1 ?></p>
                            <?php if ($row2['user'] == 0) { ?>
                                <a href="javascript:void(0)" class="px-8 text-blue-3 border-light mt-5 reply_edit" onclick="replyEdit(this,<?php echo $row2['response_id']; ?>)"  title="<?php echo _("FR0116") ?>"><i
                                        class="fa fa-pencil"></i> <?php echo _("FR0116") ?></a>
                                <a href="javascript:void(0)" class="px-8 text-blue-3 border-light mt-5 ml-5 reply_delete" onclick="replyDelete(this,<?php echo $row2['response_id']; ?>)"  title="<?php echo _("FR0117") ?>"><i
                                        class="fa fa-trash"></i> <?php echo _("FR0117") ?></a>
                                <?php } ?>
                                <?php
                                $check_spam_reply = $forum->check_spam_reply($response_id, $user_id);
                                if ($check_spam_reply->fetch(PDO::FETCH_ASSOC)) {
                                    ?>
                                <a href="javascript:void(0)" class="px-8 text-blue-3 border-light mt-5 ml-5" onclick="replyRemoveSpam(this,<?php echo $response_id ?>);" title="<?php echo _("FR0119") ?>"><i
                                        class="fa fa-exclamation"></i> <?php echo _("FR0119") ?></a>
                                    <?php
                                } else {
                                    if ($user_id != $id2) {
                                        ?>
                                    <a href="javascript:void(0)" class="px-8 text-blue-3 border-light mt-5 ml-5" onclick="replyReportSpam(this,<?php echo $topic_id ?>,<?php echo $response_id ?>);" title="<?php echo _("FR0118") ?>"><i class="fa fa-ban"></i> <?php echo _("FR0118") ?></a>
                                    <?php
                                }
                            }
                            ?>
                        </div>
                    </div>

                <?php } ?>

                <div class="d-flex justify-start mt-30">
                    <img class="fit-cover rounded-full size-50" src="<?php echo $filepath1; ?>"
                         alt="image">
                    <div class="col-md-10">
                        <form class="contact-form mb-0 ml-5">
                            <textarea type="text" placeholder="<?php echo _("FR0123"); ?>"
                                      class="text-16" autocomplete='off' style="padding: 10px 22px;" id='topic_res_user_<?php echo $topic_id ?>' name= 'topic_res_user' placeholder='<?php echo _("FR0123") ?>' maxLength="65535"></textarea>
                        </form>
                        <div id="reply_length_empty<?php echo $row1['topic_id']; ?>" style="color:#CC0000;font-size:12px;display:none;"><?php echo _("FR0504"); ?></div>
                    </div>

                    <a href="javascript:;" class="button bg-color-primary text-white" onclick='reply(this, this.name);'
                       name="<?php echo $topic_id ?>" style="min-width: 80px;height: 44px;"><i class="fa fa-spinner fa-spin" id="loader<?php echo $topic_id ?>" style="display:none;"></i><?php echo _("FR0107"); ?>
                    </a>
                </div>

            </div>
        </div>
        <?php
    }
} else {
    echo '<div class="d-flex justify-center mt-25 py-60 text-30 fw-500">';
    echo _("FR0122");
    echo '</div>';
}?>