<?php
// start session 
session_start();

if (!isset($_SESSION['uid'])) {
    header("Location: index.php");
} else {

    include_once "config/database.php";
    include_once "config/properties.php";
    include_once "resources/EncryptDecrypt.php";
    include_once "resources/offering.php";
    include_once "resources/manageusers.php";
    include_once "resources/survey.php";
    include_once "resources/company.php";

    // initialize objects
    $offering = new Offering();
    $company = new Company();
    $survey = new Survey();
    $users = new ManageUsers();

    // pagination
    $page = isset($_GET['page']) ? $_GET['page'] : 1; // page is the current page, if there's nothing set, default is page 1
    $mode = isset($_GET['mode']) ? $_GET['mode'] : "active";
    $view = isset($_GET['view']) ? $_GET['view'] : "grid";

    // set page title
    $page_no = 2;
    $page_url = "courses.php";
    $user_id = $_SESSION['uid'];
    ?>
    <html>

        <head>
            <?php include "./head.php" ?>
            <title>
                <?php echo _("LB0102"); ?>
            </title>
            <link id="favicon" rel="shortcut icon" type="image/png" href="" />
            <link rel="stylesheet" href="assets/css/course/style.css">
            <style>
                /*//modal*/
                #assessment_modal_ul {
                    margin-bottom: 0px !important;
                }

                #assessment_modal_ul li {
                    list-style-type: disc;
                    margin-left: 3%;
                }
            </style>
        </head>

        <body>
            <?php include "./menu_primary.php"; ?>

            <div class="container pb-90 x-gap-50 bg-primary-opacity-1 rounded-16 mb-50">
                <div class="pb-30 mb-10 clearfix">
                    <div class="pull-left">
                        <h1 class="text-30 lh-12 fw-700 capitalize"><?php echo _("LB0102") ?></h1>
                        <div class="mt-10"><?php echo _("INF0101")?></div>
                    </div>
                    <div class="pull-right mt-20">
                        <select name="sel_view" id="sel_view"
                                class="dropdown__button text-14 bg-white -dark-bg-dark-2 border-light rounded-8 pl-30 pr-50 py-10 lh-12">
                            <option value="grid" title="grid" selected><?php echo _("CRS101"); ?></option>
                            <option value="list" title="list"><?php echo _("CRS102"); ?></option>
                        </select>
                    </div>
                </div>

                <div class="row y-gap-30">
                    <div class="col-12">
                        <div class="rounded-16 bg-white -dark-bg-dark-1 shadow-4 h-100">
                            <div class="tabs -active-purple-2 js-tabs">
                                <div class="tabs__controls d-flex items-center pt-20 px-30 border-bottom-light js-tabs-controls"
                                     id="tab_controls">
                                    <button class="text-light-1 text-16 lh-12 tabs__button js-tabs-button is-active-tab"
                                            type="button" name="active">
                                                <?php echo _("HM0124"); ?>
                                    </button>
                                    <button class="text-light-1 text-16 lh-12 tabs__button js-tabs-button ml-30" type="button"
                                            name="complete">
                                                <?php echo _("HM0125"); ?>
                                    </button>
                                    <button class="text-light-1 text-16 lh-12 tabs__button js-tabs-button ml-30" type="button"
                                            name="incomplete">
                                                <?php echo _("HM0126"); ?>
                                    </button>
                                </div>

                                <div class="tabs__content py-30 px-30 js-tabs-content">
                                    <div id="tabs">
                                        <!--course-list-->
                                        <div class="row y-gap-30"></div>
                                        <!--paging-->
                                        <div class="row justify-center pt-30" id="paging"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <!--Instructions for assessment-->
            <div class="modal fade" id="assessment_take_test_modal" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <div class="d-flex justify-between items-center">
                                <h2 class="modal-title text-17 lh-1 fw-500"><?php echo _("AS0140"); ?></h2>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        </div>
                        <div class="modal-body bg-primary-opacity-1 scrollermodal" id="assmt_in">

                        </div>
                        <div class="modal-footer">
                            <div class="d-flex justify-center">
                                <button type="button" class="text-16 button -icon px-50 py-0 bg-color-primary text-white" onclick="proceed();">
                                    <?php echo _("CRT3107"); ?>
                                </button>
                                &nbsp;
                                <button type="button" class="text-16 button -icon px-50 py-0 -secondary-1 text-white" data-dismiss="modal"><?php echo _("AS0156") ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php include "./footer_primary.php"; ?>
            <script>
                var mode = "<?php echo $mode; ?>";
                var view = "<?php echo $view; ?>";
                var page = <?php echo $page; ?>;
                var user = <?php echo $_SESSION['uid']; ?>;
                var page_url = "<?php echo $page_url; ?>";

                //view
                $('select[name=sel_view]').change(function () {
                    var drop_value = $('#sel_view option:selected').val();
                    view = drop_value;
                    course_view(view, mode, page, user);
                });
                //mode
                $('#tab_controls > button').click(function () {
                    mode = this.name;
                    page = 1;
                    var uri = window.location.toString();
                    if (uri.indexOf("?") > 0) {
                        var clean_uri = uri.substring(0, uri.indexOf("?"));
                        window.history.replaceState({}, document.title, clean_uri);
                    }
                    course_view(view, mode, page, user);
                });
                course_view(view, mode, page, user);
                function course_view(view, mode, page, user) {
                    //view action
                    $('select[name="sel_view"] option:selected').attr("selected", null);
                    $('select[name="sel_view"] option[value="' + view + '"]').attr("selected", "selected");
                    //tab-controls action
                    $('#tab_controls > button').removeClass('is-active-tab');
                    $('#tab_controls > button[name="' + mode + '"]').addClass('is-active-tab');
                    $('#tabs').addClass('is-active-tab');

                    $.ajax({
                        url: 'modules/courseview_load.php',
                        data: {"view": view, "mode": mode, "page": page, "user_id": user},
                        type: 'GET',
                        contentType: "application/json",
                        dataType: "html",
                        success: function (response) {
                            //                        alert(response);
                            var obj = JSON.parse(response);
                            //                     alert(obj.html);
                            //                     alert(obj1.rows);
                            if (obj.html !== "") {
                                //                             alert("in"); 
                                $("#tabs > .row:first").empty();
                                $('#tabs > .row:first').append(obj.html);
                            }
                            if(obj.rows !='0'){
                                $.ajax({
                                    url: 'modules/paging.php',
                                    data: {"view": view, "mode": mode, "page": page, "user_id": user, "page_url": page_url, "total_rows": obj.rows, "records_per_page": 10},
                                    type: 'GET',
                                    dataType: "html",
                                    contentType: "application/json",
                                    success: function (response) {
                                        if (response !== "") {
                                            $("#paging").empty();
                                            $('#paging').append(response);
                                        }
                                    }
                                });
                            }else{
                                 $("#paging").empty();
                            }
                        }
                    });


                }
            </script>
            <script>
                window.CallParent = function () {
                };
                function takeTest(cAttempt, mAttempt, score, pScore, aid, oid, duration, pScore1) {
                    if (~~pScore1 == 0) {
                        pScore1 = pScore;
                    }
                    if (~~score >= ~~pScore1) {
                        alert("<?php echo _("AS0107") ?>");
                    } else if (~~cAttempt > ~~mAttempt) {
                        alert("<?php echo _("AS0109") ?>");
                    } else {
                        var oid = oid;
                        var aid = aid;
                        $.ajax({
                            url: 'assessment/quiz_check.php',
                            data: {"aid": aid, "oid": oid},
                            dataType: "html",
                            contentType: "application/json",
                            type: 'GET',
                            success: function (data) {
                                var d = data;
                                if (d === 1) {
                                    alert("Cannot take the assessment.\n\Either you have exhausted all attempts or passed the assessment.\n\Please go to active courses");
                                    window.location = "home.php";
                                } else {
                                    var ps = pScore;
                                    var ca = cAttempt;
                                    var tl = duration;
                                    $.ajax({
                                        url: "assessment/assmt_modal.php",
                                        data: {"oid": oid, "aid": aid, "ps": ps, "ca": ca, "tl": tl},
                                        dataType: "html",
                                        contentType: "application/json",
                                        type: 'GET',
                                        success: function (data) {
                                            $('#assmt_in').html(data);
                                            jQuery('#assessment_take_test_modal').modal("show");
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
                function proceed() {
                    jQuery('#assessment_take_test_modal').modal("hide");
                    var oid = $('#oid').val();
                    var aid = $('#aid').val();
                    var width = window.innerWidth;
                    var height = window.innerHeight;
                    //        window.open('../assessment/quiz_assessment.php?oid=' + oid + '&aid=' + aid, 'newwindow', 'width=' + width + ', height=' + height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,top=' + ((window.innerHeight - height) / 2) + ', left=' + ((window.innerWidth - width) / 2));
                    var winName = 'MyWindow';
                    var winURL = 'quiz_assessment.php';
                    var windowoption = 'width=' + width + ', height=' + height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,top=' + ((window.innerHeight - height) / 2) + ', left=' + ((window.innerWidth - width) / 2);
                    //var windowoption = 'width=' + window.width + ', height=' + window.height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,fullscreen=yes';
                    var params = {'oid': oid, 'aid': aid};
                    var form = document.createElement("form");
                    form.setAttribute("method", "post");
                    form.setAttribute("action", winURL);
                    form.setAttribute("target", winName);
                    for (var i in params) {
                        if (params.hasOwnProperty(i)) {
                            var input = document.createElement('input');
                            input.type = 'hidden';
                            input.name = i;
                            input.value = params[i];
                            form.appendChild(input);
                        }
                    }
                    document.body.appendChild(form);
                    window.open('', winName, windowoption);
                    //window.open('', winName, "fullscreen=yes,width=" + window.width + ",height=" + window.height)
                    form.target = winName;
                    form.submit();
                    document.body.removeChild(form);
                }
            </script>
        </body>
    </html>
<?php } ?>
 