<?php
// start session 
session_start();
if (!isset($_SESSION['uid'])) {
    header("Location: index.php");
} else {
// connect to database
    include 'config/database.php';
    include_once 'config/properties.php';
    include_once "resources/assessment.php";
    include_once "resources/manageusers.php";
    include_once "resources/EncryptDecrypt.php";

    $assessment = new Assessment();
    $users = new ManageUsers();

    $page_no = 14;

    $user_id = $_SESSION['uid'];
    $oid = $_GET['oid'];
    $ano = $_GET['ano'];
    $aid = $_GET['aid'];
    ?>

    <!DOCTYPE>
    <html lang="en">
        <head>
            <?php include "./head.php" ?>
            <title>
                <?php echo _("CA0101") ?>
            </title>
            <?php include "./menu_secondary.php" ?>
            <link rel="stylesheet" href="assets/css/assessment/style.css">
        </head>
        <body>
            <div class="container py-10 x-gap-40 bg-light-9 rounded-8 mb-50 mt-20">
                <div class="row y-gap-30 mb-0">
                    <div class="col-xl-12 col-lg-12 px-0">

                        <?php
                          $assmt_path = $properties['jdbc.admin'] . $properties['jdbc.assessment_folder'];
                        $m = 0;
                        $rn = 1;
                        $assessment->offering_id = $oid;
                        $assessment->user_id = $user_id;
                        $assessment->attempt_no = $ano;
                        $assessment->assessment_id = $aid;
                        $stmt = $assessment->get_ques_report();
                        $num = $stmt->rowCount();
                        $total_rows = $assessment->getQuestions_count();
                        $user_name = "";
                        if ($num > 0) {
                            $stmt_user = $assessment->cr_user_details();
                            if ($rowuser = $stmt_user->fetch(PDO::FETCH_ASSOC)) {
                                $user_name = $rowuser['first_name'] . " " . $rowuser['last_name'];
                                if ($rowuser['login_id'] != null) {
                                    $user_name = $rowuser['login_id'];
                                }
                                if ($rowuser['mobile_no'] != null) {
                                    if ($user_name != "") {
                                        $user_name = $user_name . " / ";
                                    }
                                    $user_name = $user_name . $rowuser['mobile_no'];
                                }
                                if ($rowuser['email_id'] != null) {
                                    if ($user_name != "") {
                                        $user_name = $user_name . " / ";
                                    }
                                    $user_name = $user_name . $rowuser['email_id'];
                                }
                                // $user_id = $rowuser['login_id'] . " /" . $rowuser['mobile_no'] . " /" .$rowuser['email_id'].";
                            }
                            ?>


                            <?php
                            $stmt110 = $assessment->get_report_details();
                            if ($row110 = $stmt110->fetch(PDO::FETCH_ASSOC)) {
                                $passing_score = $row110['passing_score'];
                                ?>
                                <div class="rounded-8 bg-white -dark-bg-dark-1 shadow-4">
                                    <div class="row py-20 px-20">

                                        <div class="col-md-6">
                                            <div class="d-flex justify-start py-8 px-10">
                                                <div class="col-auto fw-500"><?php echo _("CA0102") ?> :</div>
                                                <div class="ml-5"><?php echo htmlentities($row110['course_name']); ?></div>
                                            </div>
                                            <div class="d-flex justify-start py-8 px-10 border-top-light">
                                                <div class="col-auto fw-500"><?php echo _("CRT5101") ?> :</div>
                                                <div class="ml-5"><?php echo htmlentities($row110['assessment_name']); ?></div>
                                            </div>
                                            <div class="d-flex justify-start py-8 px-10 border-top-light">
                                                <div class="col-auto fw-500"><?php echo _("US0109") ?> :</div>
                                                <div class="ml-5"><?php echo $user_name ?></div>
                                            </div>
                                            <div class="d-flex justify-start py-8 px-10 border-top-light">
                                                <div class="col-auto fw-500"><?php echo _("CRT5108") ?> :</div>
                                                <div class="ml-5"><?php echo $user_id ?></div>
                                            </div>
                                            <div class="d-flex justify-start py-8 px-10 border-top-light">
                                                <div class="col-auto fw-500"><?php echo _("CA0104") ?> :</div>
                                                <div class="ml-5"><?php echo $ano; ?></div>
                                            </div>
                                            <?php
                                            $stmt111 = $assessment->marks_result_cr();
                                            if ($row111 = $stmt111->fetch(PDO::FETCH_ASSOC)) {
                                                $whole = intval($row111['score']);

                                                $decimal = $row111['score'] - $whole;
                                                if ($decimal != "00") {
                                                    $score = number_format((float) $row111['score'], 2, '.', '');
                                                } else {
                                                    $score = $row111['score'];
                                                }
                                                $total_score = $row111['total_score'];
                                                $score1 = $row111['score1'];
                                                $dateTime = new DateTime($row111['last_updated_ts'], new DateTimeZone('Asia/Kolkata'));
                                                $attended_date = $dateTime->format("d/m/y  h:i A");
                                                if ($score1 >= $passing_score) {
                                                    $result = "Complete";
                                                } else {
                                                    $result = "Incomplete";
                                                }
                                                ?>
                                                <div class="d-flex justify-start py-8 px-10 border-top-light">
                                                    <div class="col-auto fw-500"><?php echo _("CRT1109") ?> :</div>
                                                    <div class="ml-5"><?php echo htmlentities($attended_date); ?></div>
                                                </div>
                                                <div class="d-flex justify-start py-8 px-10 border-top-light">
                                                    <div class="col-auto fw-500"><?php echo _("CRT4108") ?> :</div>
                                                    <div class="ml-5"><?php echo $score; ?>/<?php echo $total_score; ?></div>
                                                </div>
                                                <div class="d-flex justify-start py-8 px-10 border-top-light">
                                                    <div class="col-auto fw-500"><?php echo _("CRT4109") ?> :</div>
                                                    <div class="ml-5"><?php echo $result; ?></div>
                                                </div>

                                            </div>
                                            <div class="col-md-6">
                                                <?php if ($total_score != 0) { ?>
                                                    <div class="d-flex justify-end items-center">
                                                        <div class="single-chart1">
                                                            <svg viewBox="0 0 36 36" class="circular-chart1 green">
                                                            <path class="circle-bg"
                                                                  d="M18 2.0845
                                                                  a 15.9155 15.9155 0 0 1 0 31.831
                                                                  a 15.9155 15.9155 0 0 1 0 -31.831"
                                                                  />
                                                            <path class="circle"
                                                                  stroke-dasharray="<?php echo $score1; ?>, 100"
                                                                  d="M18 2.0845
                                                                  a 15.9155 15.9155 0 0 1 0 31.831
                                                                  a 15.9155 15.9155 0 0 1 0 -31.831"
                                                                  />
                                                            <text x="18" y="20.35" class="percentage1"><?php echo $score1; ?>%</text>
                                                            </svg>
                                                        </div> 
                                                    </div>
                                                <?php } else { ?>
                                                    <div class="d-flex justify-end items-center">
                                                        <div class="single-chart1">
                                                            <svg viewBox="0 0 36 36" class="circular-chart1 green">
                                                            <path class="circle-bg"
                                                                  d="M18 2.0845
                                                                  a 15.9155 15.9155 0 0 1 0 31.831
                                                                  a 15.9155 15.9155 0 0 1 0 -31.831"
                                                                  />
                                                            <path class="circle"
                                                                  stroke-dasharray="0, 100"
                                                                  d="M18 2.0845
                                                                  a 15.9155 15.9155 0 0 1 0 31.831
                                                                  a 15.9155 15.9155 0 0 1 0 -31.831"
                                                                  />
                                                            <text x="18" y="20.35" class="percentage1">0%</text>
                                                            </svg>
                                                        </div>
                                                    </div>
                                                <?php } ?>
                                            </div>

                                        </div>
                                    </div>
                                    <?php
                                }
                            }
                            ?>

                            <div class="clearfix"></div>

                            <div class="rounded-8 bg-white -dark-bg-dark-1 shadow-4 mt-10">
                                <div class="py-20 px-20">
                                    <?php
                                    while ($row1 = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                        extract($row1);
                                        $m = $m + 1;
                                        $rn = $rn + 1;
                                        ?>
                                        <div class="border-light-2 overflow-hidden rounded-8 mt-8">
                                            <div class="py-10 px-20 bg-light-3">
                                                <div class="d-flex justify-between items-end">
                                                    <h4 class="text-14 fw-500 text-black mt-5 mb-5"><?php echo _("AS0112"); ?> <?php echo $m ?> of <?php echo (int)$total_rows ?></h4>
                                                    <h4 class="text-16 fw-500 text-black mt-5 mb-5"><?php echo _("CRT4108"); ?> : <?php echo $row1['marks']; ?> / <?php echo $row1['question_marks']; ?></h4>
                                                </div>
                                                <div class="text-18 lh-12 text-black mt-5 mb-5"><?php echo $question_text ?>
                                                </div>
                                                <?php if ($question_image != "") { ?>
                                                    <div class="relative assessment_image_div">
                                                        <a href="<?php echo "$assmt_path/$aid/$question_image" ?>" class="js-gallery"
                                                           data-gallery="gallery_qus_1">
                                                            <img class="" src="<?php echo "$assmt_path/$aid/$question_image" ?>" alt="image">
                                                            <div class="absolute-full-center d-flex justify-center items-center">
                                                            </div>
                                                        </a>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                            <?php if ($row1['question_type'] == "MC" || $row1['question_type'] == "MR") {
                                                ?>
                                                <div class="px-20 py-15">
                                                    <?php
                                                    $char = 'a';
                                                    $assessment->question_id = $row1['question_id'];
                                                    $stmt2 = $assessment->get_ans_report();
                                                    $flag = true;
                                                    while ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row2);
                                                        $assessment->option_id = $row2['option_id'];
                                                        ?>
                                                        <div class="d-flex items-center mt-5">
                                                            <div class="text-16 fw-500"><?php echo $char; ?>.</div>

                                                            <?php
                                                            $assessment->option_id = $row2['option_id'];
                                                            if ($row2['user_response'] == "Y") {
                                                                $stmt3 = $assessment->get_ans_opt_report();
                                                                if ($row3 = $stmt3->fetch(PDO::FETCH_ASSOC)) {
                                                                    ?>
                                                                    <div class="text-16 fw-500 ml-12 border-green-1 items-center px-10 py-5 rounded-16"><?php echo htmlentities($row2['option_desc']); ?>
                                                                        <?php if ($option_image != "") { ?>

                                                                            <div class="relative assessment_image_div_option mt-5">
                                                                                <a href="<?php echo "$assmt_path/$aid/$option_image" ?>" class="w-1/1 js-gallery"
                                                                                   data-gallery="gallery2">
                                                                                    <img class="" src="<?php echo "$assmt_path/$aid/$option_image" ?>" alt="image">
                                                                                    <div class="absolute-full-center d-flex justify-center items-center">
                                                                                    </div>
                                                                                </a>
                                                                            </div>

                                                                        <?php }
                                                                        ?>
                                                                    </div>
                                                                    <i class="fa fa-check-circle-o text-20 ml-5 text-green-5"></i>
                                                                <?php } else { ?>
                                                                    <div class="text-16 fw-500 ml-12 border-red-1 items-center px-10 py-5 rounded-16"><?php echo htmlentities($row2['option_desc']); ?>
                                                                        <?php if ($option_image != "") { ?>
                                                                            <div class="relative assessment_image_div_option mt-5">
                                                                                <a href="<?php echo "$assmt_path/$aid/$option_image" ?>" class="w-1/1 js-gallery"
                                                                                   data-gallery="gallery2">
                                                                                    <img class="" src="<?php echo "$assmt_path/$aid/$option_image" ?>" alt="image">
                                                                                    <div class="absolute-full-center d-flex justify-center items-center">
                                                                                    </div>
                                                                                </a>
                                                                            </div>
                                                                        <?php }
                                                                        ?>
                                                                    </div>
                                                                    <i class="fa fa-times-circle-o text-20 ml-5 text-red-1"></i>
                                                                    <?php
                                                                }
                                                                $char++;
                                                            } else {
                                                                $stmt3 = $assessment->get_ans_opt_report();
                                                                if ($row3 = $stmt3->fetch(PDO::FETCH_ASSOC)) {
                                                                    $flag = false;
                                                                    ?>
                                                                    <div class="text-16 fw-500 ml-12 items-center px-10 py-5 rounded-16"><?php echo htmlentities($row2['option_desc']); ?>
                                                                        <?php if ($option_image != "") { ?>

                                                                            <div class="relative assessment_image_div_option mt-5">
                                                                                <a href="<?php echo "$assmt_path/$aid/$option_image" ?>" class="w-1/1 js-gallery"
                                                                                   data-gallery="gallery2">
                                                                                    <img class="" src="<?php echo "$assmt_path/$aid/$option_image" ?>" alt="image">
                                                                                    <div class="absolute-full-center d-flex justify-center items-center">
                                                                                    </div>
                                                                                </a>
                                                                            </div>

                                                                        <?php }
                                                                        ?>
                                                                    </div>
                                                                    <i class="fa fa-check-circle-o text-20 ml-5 text-green-5"></i>
                                                                <?php } else { ?>
                                                                    <div class="text-16 fw-500 ml-12 items-center px-10 py-5 rounded-16"><?php echo htmlentities($row2['option_desc']); ?>
                                                                        <?php if ($option_image != "") { ?>

                                                                            <div class="relative assessment_image_div_option mt-5">
                                                                                <a href="<?php echo "$assmt_path/$aid/$option_image" ?>" class="w-1/1 js-gallery"
                                                                                   data-gallery="gallery2">
                                                                                    <img class="" src="<?php echo "$assmt_path/$aid/$option_image" ?>" alt="image">
                                                                                    <div class="absolute-full-center d-flex justify-center items-center">
                                                                                    </div>
                                                                                </a>
                                                                            </div>

                                                                        <?php }
                                                                        ?>
                                                                    </div>
                                                                    <?php
                                                                }
                                                            }
                                                            ?>
                                                        </div>
                                                    <?php }
                                                    ?>
                                                </div>
                                                <?php if ($flag) { ?>
                                                    <div class="py-10 px-20 bg-green-2 text-green-5"><i class="fa fa-check"></i> <?php echo _("CA0106"); ?></div>
                                                <?php } else { ?>
                                                    <div class="py-10 px-20 bg-red-2 text-red-1"><i class="fa fa-times"></i> <?php echo _("CA0107"); ?></div>
                                                <?php } ?>

                                            <?php } else if ($row1['question_type'] == "MF") { ?>
                                                <div class="px-20 py-15">
                                                    <div class="table-responsive">
                                                        <table class="table_mf_ques w-1/1">
                                                            <colgroup>
                                                                <col style="width:30%">
                                                                <col style="width:30%">
                                                                <col style="width:30%">
                                                            </colgroup>
                                                            <thead>
                                                                <tr>
                                                                    <th><?php echo _("AS0128"); ?></th>
                                                                    <th><?php echo _("AS0129"); ?></th>
                                                                    <th><?php echo _("CA0112"); ?></th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php
                                                                $assessment->question_id = $row1['question_id'];
                                                                $stmt4 = $assessment->get_opt_report();
                                                                $flag = true;
                                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row4);
                                                                    ?>

                                                                    <tr class="bg-white shadow-1 rounded-8 border-light">
                                                                        <td class="text-16"><?php
                                                                            echo htmlentities($row4['option_desc']);
                                                                            if ($option_image != "") {
                                                                                ?>
                                                                                <div class="relative assessment_image_div_option">
                                                                                    <a href="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                       class="js-gallery" data-gallery="gallery_opt_5_3">
                                                                                        <img class="" src="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                             alt="image">
                                                                                        <div
                                                                                            class="absolute-full-center d-flex justify-center items-center">
                                                                                        </div>
                                                                                    </a>
                                                                                </div>
                                                                            <?php } ?>
                                                                        </td>
                                                                        <?php
                                                                        $assessment->option_id = $row4['option_id'];
                                                                        $assessment->answer_option = htmlentities($row4['answer_option']);
                                                                        $stmt5 = $assessment->get_opt_ans_report();
                                                                        if ($row5 = $stmt5->fetch(PDO::FETCH_ASSOC)) {
                                                                            $assessment->user_response = $row5['user_response'];
                                                                            $stmt6 = $assessment->check_answer();
                                                                            if ($row6 = $stmt6->fetch(PDO::FETCH_ASSOC)) {
                                                                                ?>
                                                                                <td class="d-flex items-center"><div class="text-16 border-green-1 items-center px-10 py-8 rounded-16"><?php echo htmlentities($row6['option_desc']); ?></div>
                                                                                    <i class="fa fa-check-circle-o text-20 ml-5 text-green-5"></i>
                                                                                </td>
                                                                                <?php
                                                                            }
                                                                        } else {
                                                                            $stmt7 = $assessment->get_opt_an_opt();
                                                                            if ($row7 = $stmt7->fetch(PDO::FETCH_ASSOC)) {
                                                                                $assessment->user_response = $row7['user_response'];
                                                                                $stmt8 = $assessment->get_opt_an_opt1();
                                                                                if ($row8 = $stmt8->fetch(PDO::FETCH_ASSOC)) {
                                                                                    $flag = false;
                                                                                    ?>
                                                                                    <td class="d-flex items-center"><div class="text-16 border-red-1 items-center px-10 py-8 rounded-16"><?php echo htmlentities($row8['option_desc']); ?></div><i class="fa fa-times-circle-o text-20 ml-5 text-red-1" ></i></td>                                          
                                                                                    <?php
                                                                                } else {
                                                                                    $flag = false;
                                                                                    ?>
                                                                                    <td class="d-flex items-center"><div class="text-16 border-red-1 items-center px-10 py-8 rounded-16">----------</div><i class="fa fa-times-circle-o text-20 ml-5 text-red-1" ></i></td>
                                                                                    <?php
                                                                                }
                                                                            }
                                                                        }
                                                                        $assessment->option_id = $row4['option_id'];
                                                                        $stmt9 = $assessment->get_check_ans_report_MF();
                                                                        if ($row9 = $stmt9->fetch(PDO::FETCH_ASSOC)) {
                                                                            $assessment->answer_option = htmlentities($row9['answer_option']);
                                                                            $stmt10 = $assessment->get_check_ans_report_MF1();
                                                                            if ($row10 = $stmt10->fetch(PDO::FETCH_ASSOC)) {
                                                                                ?>
                                                                                <td><?php echo htmlentities($row10['option_desc']); ?></td>
                                                                                <?php
                                                                            }
                                                                        }
                                                                        ?>
                                                                    </tr>
                                                                <?php }
                                                                ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <?php if ($flag) { ?>
                                                    <div class="py-10 px-20 bg-green-2 text-green-5"><i class="fa fa-check"></i> <?php echo _("CA0106"); ?></div>
                                                <?php } else { ?>
                                                    <div class="py-10 px-20 bg-red-2 text-red-1"><i class="fa fa-times"></i> <?php echo _("CA0107"); ?></div>
                                                <?php } ?>

                                            <?php } else if ($row1['question_type'] == "FIB-E" || $row1['question_type'] == "FIB-A") { ?>

                                                <div class="px-20 py-15">
                                                    <?php
                                                    $char = 'a';
                                                    $assessment->question_id = $row1['question_id'];
                                                    if ($row1['question_type'] == "FIB-E") {
                                                        $stmt2 = $assessment->get_fib_e_opt_ans_report();
                                                    } else {
                                                        $stmt2 = $assessment->get_fib_a_opt_ans_report();
                                                    }
                                                    $flag = true;
                                                    while ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row2);
                                                        ?>
                                                        <div class="d-flex items-center">
                                                            <div class="text-16 fw-500"><?php echo $char; ?>.</div>

                                                            <div class="text-16 fw-500 ml-12">
                                                                <?php
                                                                if ($row2['fib_answer'] != "") {
                                                                    echo htmlentities($row2['fib_answer']);
                                                                } else {
                                                                    echo "-----";
                                                                }
                                                                ?>
                                                            </div>
                                                            <?php if ($result == 'Y') { ?>
                                                                <i class="fa fa-check-circle-o text-20 ml-5 text-green-5"></i>
                                                                <?php
                                                            } else {
                                                                $flag = false;
                                                                ?>
                                                                <i class="fa fa-times-circle-o text-20 ml-5 text-red-1"></i>
                                                            <?php } ?>
                                                        </div>
                                                        <?php if (!$flag) { ?>
                                                            <div class="d-flex items-center mt-5">
                                                                <div class="text-14 text-blue-3 fw-500"><?php echo _("CA0112") ?> : </div>
                                                                <div class="text-16 ml-5"> <?php echo htmlentities($row2['option_desc']); ?></div>
                                                            </div>
                                                            <?php
                                                        }
                                                        $char++;
                                                    }
                                                    ?>
                                                </div>

                                                <?php if ($flag) { ?>
                                                    <div class="py-10 px-20 bg-green-2 text-green-5"><i class="fa fa-check"></i> <?php echo _("CA0106"); ?></div>
                                                <?php } else { ?>
                                                    <div class="py-10 px-20 bg-red-2 text-red-1"><i class="fa fa-times"></i> <?php echo _("CA0107"); ?></div>
                                                <?php } ?>


                                                <?php
                                            } else if ($row1['question_type'] == "S-AI" || $row1['question_type'] == "S-AD") {
                                                $assessment->question_id = $row1['question_id'];
                                                $stmt2 = $assessment->get_sub_opt_ans_report();
                                                $flag = true;
                                                while ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row2);
                                                    $subjective_answer = "---";
                                                    if ($row2['subjective_answer'] != "") {
                                                        $subjective_answer = $row2['subjective_answer'];
                                                    }
                                                    ?>
                                                    <div class="px-20 py-15">
                                                        <div class="d-flex justify-start">
                                                            <div class="col-auto text-16 fw-500"><?php echo _("CA0110") ?> :</div>
                                                            <div class="text-16 ml-12"><?php echo $subjective_answer ?></div>
                                                        </div>
                                                        <?php if($row1['question_type'] == "S-AI"){ ?>
                                                        <div class="d-flex justify-start mt-10">
                                                            <div class="col-auto text-16 fw-500"><?php echo _("CA0111") ?> :</div>
                                                            <div class="text-16 ml-12"><?php echo htmlentities($row2['option_desc']); ?></div>
                                                        </div>
                                                        <?php } ?>
                                                    </div>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </div>
                                    <?php }
                                    ?>


                                    <div class="border-light-2 overflow-hidden rounded-8 mt-8">
                                        <div class="py-10 px-20 bg-light-3">
                                            <div class="d-flex justify-between">
                                                <h4 class="text-16 text-black mt-5 mb-5"><?php echo _("CA0109") ?></h4>
                                            </div>
                                        </div>
                                        <div class="px-20 py-15">
                                            <canvas id='lineChart_coaching' width='800' height='300'> </canvas>
                                        </div>
                                    </div>
                                <?php } else { ?>

                                    <h2>
                                        <span><i class="fa fa-star"></i></span>
                                        <?php echo _("CA0108") ?></h2>
                                <?php }
                                ?>

                                <div class="d-flex justify-start items-center mt-40 assmt_nav_button">
                                    <a href="javascript:window.close();" class="button -icon -secondary-1 h-40 text-white ml-10">
                                        <i class="fa fa-times text-13 mr-5"></i>
                                        Close
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include "./footer_secondary.php" ?> 
            <script type='text/javascript' src='assets/js/coachingreport/chart.js'></script>
            <script>
                $(document).ready(function () {
                    if ($('#lineChart_coaching').length) {
                        user_login();
                    }
                });
                function user_login() {
                    var oid =<?php echo $oid ?>;
                    var ano =<?php echo $ano ?>;
                    var aid =<?php echo $aid ?>;
                    jQuery.ajax({
                        url: 'modules/get_quiz_time.php',
                        async: false,
                        data: {"oid": oid, "ano": ano, "aid": aid},
                        type: 'POST',
                        success: function (response) {
                            //alert(response);
                            var times = [];
                            var qs = [];
                            var res = $.parseJSON(response);
                            //alert(res);
                            for (i = 0; i < res.length; ++i) {
                                //alert(res[i]);
                                var a = res[i].split(':');
                                var seconds = (+a[0]) * 60 * 60 + (+a[1]) * 60 + (+a[2]);
                                //alert(seconds);
                                times.push(seconds);
                                qs.push(i + 1);
                            }
                            //var login = [800, 8000, 1500, 4250, 1450, 1400, 2000, 1110, 4000, 1450, 1550, 1800];
                            var user_logins = $('#lineChart_coaching')[0].getContext("2d");

                            var myChart_user_logins = new Chart(user_logins, {
                                type: 'line',
                                data: {
                                    labels: qs,
                                    datasets: [{
                                            label: 'Time',
                                            data: times,
                                            backgroundColor: '#cdd6fe',
                                            borderColor: '#002080',
                                            borderWidth: 1
                                        }]
                                },
                                options: {
                                    legend: {
                                        display: false,
                                    },
                                    scales: {
                                        yAxes: [{
                                                ticks: {
                                                    beginAtZero: true,
                                                    callback: function (label, index, labels) {
                                                        return formatTime(label);
                                                    }
                                                },
                                                scaleLabel: {
                                                    display: true,
                                                    labelString: 'Time Spent'
                                                }
                                            }],
                                        xAxes: [{
                                                scaleLabel: {
                                                    display: true,
                                                    labelString: 'Question No'
                                                }
                                            }]
                                    },
                                    tooltips: {
                                        callbacks: {
                                            label: function (item, data) {
                                                var datasetLabel = data.datasets[item.datasetIndex].label || "";
                                                var dataPoint = item.yLabel;
                                                return datasetLabel + " " + formatTime(dataPoint);
                                            }
                                        }
                                    }
                                }
                            });
                        }, error: function () {

                        }
                    });

                }
                function formatTime(secs) {
                    var sec_num = parseInt(secs, 10); // don't forget the second param
                    var hours = Math.floor(sec_num / 3600);
                    var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
                    var seconds = sec_num - (hours * 3600) - (minutes * 60);

                    if (hours < 10) {
                        hours = "0" + hours;
                    }
                    if (minutes < 10) {
                        minutes = "0" + minutes;
                    }
                    if (seconds < 10) {
                        seconds = "0" + seconds;
                    }
                    return hours + ':' + minutes + ':' + seconds;
                }
            </script>
        </body>
    </html>
    <?php
}
?>

