<?php

session_start();
if (!isset($_SESSION['uid'])) {
    echo "<script>window.location='../../index.php';</script>";
} else {
    include_once '../../config/database.php';
    include_once "../../resources/offering.php";
    include_once '../../config/properties.php';
    include_once "../../resources/company.php";
    require_once('tcpdf_include.php');

    // initialize objects
    $offering = new Offering();
    $id = $_SESSION['uid'];
    $offering->user_id = $id;
    $lid = $_GET['id'];
    $offering->learning_path_id = $lid;

    $course_name = "";
    $first_name = "";
    $last_name = "";
    $attended_date = "";
    $template_id = "";
    $cust_company_logo = "";
    $cust_company_name = "";
    
    $stmt_r = $offering->get_learning_cert();
    if ($row_r = $stmt_r->fetch(PDO::FETCH_ASSOC)) {
        $first_name = $row_r['first_name'];
        $last_name = $row_r['last_name'];
        $course_name = $row_r['learning_path_name'];
        $attended_date = $row_r['completed_date'];
        $cust_company_logo = $row_r['logo_path'];
        $cust_company_name = $row_r['name'];
        $template_id=$row_r['template_id'];
        $offering->template_id = $template_id;
    } else {
        header("Location: 404.php");
    }

    $date = strtotime($attended_date);
    $date1 = date("F d, Y", $date);

   
    $stmt4 = $offering->get_cert_template();
    if ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
        $template_name_1 = $row4['template_name'];
        $template_file_1 = $row4['template_file'];
        $text1_1 = $row4['text1'];
        $text2_1 = $row4['text2'];
        $text3_1 = $row4['text3'];
        $text4_1 = $row4['text4'];
        $text5_1 = $row4['text5'];
        $text6_1 = $row4['text6'];

        $text1_color_1 = $row4['text1_color'];
        $record1_1 = explode(",", $text1_color_1);
        $text2_color_1 = $row4['text2_color'];
        $record2_1 = explode(",", $text2_color_1);
        $text3_color_1 = $row4['text3_color'];
        $record3_1 = explode(",", $text3_color_1);
        $text4_color_1 = $row4['text4_color'];
        $record4_1 = explode(",", $text4_color_1);
        $text5_color_1 = $row4['text5_color'];
        $record5_1 = explode(",", $text5_color_1);
        $text6_color_1 = $row4['text6_color'];
        $record9_1 = explode(",", $text6_color_1);
        $comp_name_color_1 = $row4['comp_name_color'];
        $record10_1 = explode(",", $comp_name_color_1);
        $name_color_1 = $row4['name_color'];
        $record6_1 = explode(",", $name_color_1);
        $course_color_1 = $row4['course_color'];
        $record7_1 = explode(",", $course_color_1);

        $text1_size_1 = $row4['text1_size'];
        $text2_size_1 = $row4['text2_size'];
        $text3_size_1 = $row4['text3_size'];
        $text4_size_1 = $row4['text4_size'];
        $text5_size_1 = $row4['text5_size'];
        $text6_size_1 = $row4['text6_size'];
        $comp_name_size_1 = $row4['comp_name_size'];
        $name_size_1 = $row4['name_size'];
        $course_size_1 = $row4['course_size'];

        $comp_name_path_1 = $row4['comp_name_path'];
        $sign_path_1 = $row4['sign_path'];
        $company_name_con = $row2['comp_name'];

        //$GLOBALS['s_path_1'] = $mobitute_template . $template_name_1 . '/' . $template_file_1;
        define('TEMPLATE_PATH2', ADMIN_PATH . $properties['jdbc.cert_template'] . "/" . $template_id . '/' . $template_file_1);

// Extend the TCPDF class to create custom Header and Footer
        class MYPDF extends TCPDF {

            //Page header
            public function Header() {

                // get the current page break margin
                $bMargin = $this->getBreakMargin();
                // get current auto-page-break mode
                $auto_page_break = $this->AutoPageBreak;
                // disable auto-page-break
                $this->SetAutoPageBreak(false, 0);
                // set bacground image
                //$img_file = $GLOBALS['s_path_1'];
                $this->Image(TEMPLATE_PATH2, 0, 0, 297, 210, '', '', '', false, 300, '', false, false, 0);
                // restore auto-page-break status
                $this->SetAutoPageBreak($auto_page_break, $bMargin);
                // set the starting point for the page content
                $this->setPageMark();
            }

        }

// create new PDF document
        $pdf = new MYPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetTitle('Certificate');

// set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

// set default monospaced font
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
        $pdf->SetMargins(0, 0, 0);
        $pdf->SetHeaderMargin(0);
        $pdf->SetFooterMargin(0);

// remove default footer
        $pdf->setPrintFooter(false);

// set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }

// add a page
        $pdf->AddPage();

// Print a text
        $pdf->Ln(20);
        if ($comp_name_path_1 != "") {
            $pdf->Image(ADMIN_PATH . $properties['jdbc.comp_name_image_folder'] . "/" . $comp_name_path_1, '', '', '', '', '', '', '', true, 300, 'C');
        } else if ($company_name_con != "") {
            $pdf->SetFont('freesans', 'B', $comp_name_size_1);
            $pdf->SetTextColor($record10_1[0], $record10_1[1], $record10_1[2]);
            $pdf->MultiCell(0, 0, $cust_company_name, 0, 'C', 0, 0, '', '', true, 0);
        }
        $pdf->Ln(22);
        $pdf->SetFont('freesans', 'B', $text1_size_1);
        $pdf->SetTextColor($record1_1[0], $record1_1[1], $record1_1[2]);
        $pdf->MultiCell(0, 0, $text1_1, 0, 'C', 0, 0, '', '', true, 0);
        $pdf->Ln(22);
        $pdf->SetFont('freesans', 'B', $text2_size_1);
        $pdf->SetTextColor($record2_1[0], $record2_1[1], $record2_1[2]);
        $pdf->MultiCell(0, 0, $text2_1, 0, 'C', 0, 0, '', '', true, 0);
        $pdf->Ln(12);
        $pdf->SetFont('freesans', 'B', $name_size_1);
        $pdf->SetTextColor($record6_1[0], $record6_1[1], $record6_1[2]);
        $pdf->MultiCell(0, 0, $first_name . ' ' . $last_name, 0, 'C', 0, 0, '', '', true, 0);
        $pdf->Ln(20);
        $pdf->SetFont('freesans', 'B', $text3_size_1);
        $pdf->SetTextColor($record3_1[0], $record3_1[1], $record3_1[2]);
        $pdf->MultiCell(0, 0, $text3_1, 0, 'C', 0, 0, '', '', true, 0);
        $pdf->Ln(11);
        $pdf->SetFont('freesans', 'B', 20);
        $pdf->SetTextColor($record7_1[0], $record7_1[1], $record7_1[2]);
        $pdf->MultiCell(0, 0, $course_name, 0, 'C', 0, 0, '', '', true, 0);
        $pdf->Ln(14);
        
         $pdf->Ln(25);

        $pdf->setCellPaddings($left = '45', $top = '', $right = '46', $bottom = '');
        if ($text5_1 != "" && $attended_date != NULL) {
            $pdf->SetFont('freesans', 'B', $text5_size_1);
            $pdf->SetTextColor($record5_1[0], $record5_1[1], $record5_1[2]);
            $pdf->Cell(0, 0, $date1, 0, false, 'L', 0, '', 0, false, 'T', 0);
        }
        if ($cust_company_logo != "") {
            $pdf->Image(ADMIN_PATH . $properties['jdbc.comp_image_folder'] . "/" . $cust_company_logo, '', '', '', '', '', '', '', true, 300, 'C');
        }
        if ($sign_path_1 != "") {
            $pdf->Image(ADMIN_PATH . $properties['jdbc.signatory_image_folder'] . "/" . $sign_path_1, 220, 142, '', '', '', '', '', true, 300, FALSE);
        }
        if ($text5_1 != "" && $attended_date != NULL) {
            $pdf->Line(30, 156, 100, 156);
        }
        if ($text6_1 != "") {
            $pdf->Line(200, 156, 270, 156);
        }
        $pdf->Ln(1);
        $pdf->setCellPaddings($left = '45', $top = '', $right = '30', $bottom = '');
        if ($text5_1 != "" && $attended_date != NULL) {
            $pdf->SetFont('freesans', 'B', $text5_size_1);
            $pdf->SetTextColor($record5_1[0], $record5_1[1], $record5_1[2]);
            $pdf->Cell(0, 30, $text5_1, 0, false, 'L', 0, '', 0, false, 'T', 'M');
        }
        if ($text6_1 != "") {
            $pdf->SetFont('freesans', 'B', $text6_size_1);
            $pdf->SetTextColor($record6_1[0], $record6_1[1], $record6_1[2]);
            $pdf->Cell(0, 30, $text6_1, 0, false, 'R', 0, '', 0, false, 'T', 'M');
        }
        /*         * ************************************************* */

// --- example with background set on page ---
// remove default header
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

// ---------------------------------------------------------
//Close and output PDF document

        die($pdf->Output('certificate.pdf', 'I'));
    }
}
?>

