<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
session_start();
if (!isset($_SESSION['uid'])) {
    echo "<script>window.location='../../index.php';</script>";
} else {
    include '../../config/database.php';
    include_once '../../config/properties.php';
    include_once "../../resources/offering.php";
    include_once "../../resources/manageusers.php";
    require_once('tcpdf_include.php');
    $date = date("d-m-Y", strtotime($date));
    $id = $_SESSION['uid'];
    $name = $_GET['name'];
    $from_date = $_GET['from_date'];
    $to_date = $_GET['to_date'];

    $start = date("d-M-Y", strtotime($from_date));
    $end = date("d-M-Y", strtotime($to_date));

    // initialize objects
    $offering = new Offering();
    $offering->user_id = $id;
    $total_points = 0;

    // Extend the TCPDF class to create custom Header and Footer
    class MYPDF extends TCPDF {

        //Page header
        public function Header() {
            // get the current page break margin
            $bMargin = $this->getBreakMargin();
            // get current auto-page-break mode
            $auto_page_break = $this->AutoPageBreak;
            // disable auto-page-break
            $this->SetAutoPageBreak(false, 0);

            // restore auto-page-break status
            $this->SetAutoPageBreak($auto_page_break, $bMargin);
            // set the starting point for the page content
            $this->setPageMark();
        }

        // Page footer
        public function Footer() {
            // Position at 15 mm from bottom
            $this->SetY(-15);
            // Set font
            $this->SetFont('helvetica', 'I', 8);
            // Page number
            $this->Cell(0, 10, 'Page ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'R', 0, '', 0, false, 'T', 'M');
            $tDate = date("d-M-Y H:i:s");
            $this->Cell(0, 20, 'Downloaded on  ' . $tDate, 0, false, 'R', 0, '', 0, false, 'T', 'M');
// $this->Cell(0, 0, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages().'Downloaded on '.$tDate, 0, false, 'R', 0, '', 0, false, 'T', 'M');
        }

    }

    // create new PDF document
    $pdf = new MYPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetTitle('Report');

// set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, 15, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(0);
    $pdf->SetFooterMargin(0);

// remove default footer
    $pdf->setPrintFooter(true);

// set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
    if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
        require_once(dirname(__FILE__) . '/lang/eng.php');
        $pdf->setLanguageArray($l);
    }
// add a page
    $pdf->AddPage();

    $pdf->SetFont('freesans', '', 10);
    //---------------------
    $off_val_date = "";
    $mobile_no = "";
    $email_id = "";
    $project = "";
    $location = "";
    $designation = "";
    $department = "";
    $stmt_user = $offering->UserDetails($_SESSION['uid']);
    if ($row_user = $stmt_user->fetch(PDO::FETCH_ASSOC)) {
        if ($row_user["email_id"] != "") {
            $email_id = $row_user["email_id"];
        }if ($row_user["mobile_no"] != "") {
            $mobile_no = $row_user["mobile_no"];
        }if ($row_user["project"] != "") {
            $project = $row_user["project"];
        }if ($row_user["location"] != "") {
            $location = $row_user["location"];
        }if ($row_user["designation"] != "") {
            $designation = $row_user["designation"];
        }if ($row_user["dept_name"] != "") {
            $department = $row_user["dept_name"];
        }
//    $data = "<h4>" . _("US0109") . " : $name</h4>";
        $data = '<h2 align="center">' . _("HM0136") . '</h2>';
        $data .= '<table cellpadding="5">'
                . '<tr>'
                . '<td>' . _("CRT5108") . ' : ' . $row_user["user_id"] . '</td>'
                . '<td>' . _("US0153") . ' : ' . $row_user["first_name"] . ' ' . $row_user["last_name"] . '</td>'
                . '<td>' . _("US0114") . ' : ' . $email_id . '</td>'
                . '</tr>'
                . '<tr>'
                . '<td>' . _("US0113") . ' : ' . $mobile_no . '</td>'
                . '<td>' . _("RP0102") . ' : ' . $end_date . '</td>'
                . '<td>' . _("RP0101") . ' : ' . $row_user["name"] . '</td>'
                . '</tr>'
                . '<tr>'
                . '<td>' . _("US0152") . ' : ' . $department . '</td>'
                . '<td>' . _("US0115") . ' : ' . $designation . '</td>'
                . '<td>' . _("US0118") . ' : ' . $project . '</td>'
                . '</tr>'
                . '<tr>'
                . '<td>' . _("US0119") . ' : ' . $location . '</td>'
                . '</tr>'
                . '</table>';
    }
    if ($from_date !== "") {
        $data .= "<h4>" . _("RP0128") . " : $start  " . _("RP0129") . " : $end</h4>";
    } else {
        $data .= "<h4>" . _("RP0128") . " :   " . _("RP0129") . " :  </h4>";
    }

    if ($from_date !== "") {
        $off_val_date = " AND DATE(ca.course_assigned_ts)>='$from_date' AND DATE(ca.course_assigned_ts)<='$to_date' ";
    } else {
        $off_val_date = "";
    }
    $pdf->writeHTML($data, true, false, false, false, '');

    $completion_points = 0;
    $grade = "";
    $attended_date = "";
    $total_time = 0;

    $tbl = '<h2 align="center">' . _("RP0107") . '</h2>';
    $tbl .= '<table cellspacing="0" cellpadding="5" border="1">
        <thead>
        <tr>
            <th><b>' . _('RP0108') . '</b></th>
            <th><b>' . _('HM0114') . '</b></th>
            <th><b>' . _('RP0109') . '</b></th>
            <th><b>' . _('RP0110') . '</b></th>
            <th><b>' . _('RP0111') . '</b></th>
            <th><b>' . _('RP0112') . '</b></th>
            <th><b>' . _('CRT1109') . '</b></th>
            <th><b>' . _('RP0113') . '</b></th>
            <th><b>' . _('RP0122') . '</b></th>
            <th><b>' . _('RP0114') . '</b></th>
            <th><b>' . _('CR0111') . ' ?</b></th>
    </tr></thead>';
    $stmt = $offering->offering_Course_Report($off_val_date);
    $num = $stmt->rowCount();
    if ($num > 0) {
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $grade = "";
            $attended_date = "";
            $total_time = "";
            $result = "";
            $score = "";
            $content_completion = "";
            $passing_score = "";
            $completion_points = "";
            if ($row['completion_points'] != null) {
                $completion_points = round($row['completion_points'],1);
            }
            if ($row['attended_date'] != null) {
                $attended_date = $row['attended_date'];
            }
            if ($row['total_time'] != null) {
                $total_time = $row['total_time'];
            }
            if ($row['score'] != null && $row['score'] != 0) {
                $score = $row['score'];
            }
            if ($row['passing_score'] != null && $row['passing_score'] != 0) {
                $passing_score = $row['passing_score'];
            }
            if ($row['content_completion'] != null && $row['content_completion'] != 0) {
                $content_completion = $row['content_completion'];
            }
            if ($row['result'] == 'complete') {
                $result = "Complete";
            } else if ($row['result'] == 'incomplete') {
                $result = 'Incomplete';
            } else {
                $result = "";
            }
            $tbl .= ' <tr nobr="true">
                                                        <td>' . $row['category_name'] . '</td>
                                                        <td>' . $row['course_name'] . '</td>
                                                        <td align="right">' . $total_time . '</td>
                                                        <td align="right">' . $content_completion . '</td>
                                                        <td align="right">' . $passing_score . '</td>
                                                        <td align="right">' . $score . '</td>
                                                        <td align="right">' . $attended_date . '</td>
                                                        <td>' . $result . '</td>
                                                        <td align="right">' . $completion_points . '</td>
                                                        <td>';
            $total_points += round($row['completion_points'],1);
            $offering->offering_id = $row['offering_id'];
            $stmt1 = $offering->offering_Course_Reportbadge($off_val_date);
            if ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {
                if ($row1['grade'] != "") {
                    $grade = $row1['grade'];
                } else {
                    $grade = "";
                }
            }
            $tbl .= $grade;
            $tbl .= '</td>';
            $stmt2 = $offering->offering_Course_Reporttemplate($off_val_date);
            if ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
                if ($row2['template_count'] != 0) {
                    $tbl .= "<td>Yes</td>";
                } else {
                    $tbl .= "<td></td>";
                }
            }
            $tbl .= '</tr>';
        }
    }
    $total_duration = $offering->get_Course_totalTime($off_val_date);
    $tbl .= '<tr nobr="true">
<td colspan="2" align="right"><b>' . _("RP0119") . '</b></td>
<td align="right"><b>' . $total_duration . '</b></td>
<td colspan="5" align="right"><b>' . _("RP0120") . '</b></td>
            <td align="right"><b>' . $total_points . '</b></td>
            <td colspan="5"></td>
</tr>';
    $tbl .= '</table>';
    $pdf->writeHTML($tbl, true, false, false, false, '');

    $discussion_forum = 0;
    $offer_completion = 0;
    $offer_ratings = 0;
    $offer_score1 = 0;
    $score1 = 0;
    $offer_score2 = 0;
    $score2 = 0;
    $offer_score3 = 0;
    $score3 = 0;
    $offer_score4 = 0;
    $score4 = 0;
    $offer_view = 0;
    $html = '<h2 align="center">' . _("RP0115") . '</h2>';
    $stmt_points = $offering->get_ReportActivityPoints();
    while ($row_pt = $stmt_points->fetch(PDO::FETCH_ASSOC)) {
        if ($row_pt['name'] == "discussion_forum") {
            $discussion_forum = $row_pt['points'];
        }
        if ($row_pt['name'] == "offer_completion") {
            $offer_completion = $row_pt['points'];
        }
        if ($row_pt['name'] == "offer_ratings") {
            $offer_ratings = $row_pt['points'];
        }
        if ($row_pt['name'] == "offer_score1") {
            $offer_score1 = $row_pt['points'];
            $score1 = $row_pt['score'];
        }
        if ($row_pt['name'] == "offer_score2") {
            $offer_score2 = $row_pt['points'];
            $score2 = $row_pt['score'];
        }
        if ($row_pt['name'] == "offer_score3") {
            $offer_score3 = $row_pt['points'];
            $score3 = $row_pt['score'];
        }
        if ($row_pt['name'] == "offer_score4") {
            $offer_score4 = $row_pt['points'];
            $score4 = $row_pt['score'];
        }
        if ($row_pt['name'] == "offer_view") {
            $offer_view = $row_pt['points'];
        }
    }
    $html .= '<table cellspacing="0" cellpadding="5" border="1"><thead>';
    $html .= '<tr nobr="true">';
    $html .= "<th><b>" . _("RP0116") . "</b></th>"
            . "<th><b>" . _("RP0117") . "</b></th>"
            . "<th><b>" . _("RP0118") . "</b></th>"
            . "</tr></thead>";
    $total_points_pt = 0.0;
    //forum
    if ($from_date !== "") {
        $forum_val_date = "AND DATE(ft.last_updated_ts)>='$from_date' AND DATE(ft.last_updated_ts)<='$to_date'";
    } else {
        $forum_val_date = "";
    }
    $forum_count = $offering->get_totaltopic($forum_val_date, $discussion_forum);
    if ($from_date !== "") {
        $forum_val_date = "AND DATE(ftr.last_updated_ts)>='$from_date' AND DATE(ftr.last_updated_ts)<='$to_date'";
    } else {
        $forum_val_date = "";
    }
    $response_count = $offering->get_totalresponse($forum_val_date, $discussion_forum);
    $total_res = $forum_count + $response_count;
    $total_points_pt += $total_res;
    $html .= '<tr nobr="true">';
    $html .= '<td>' . _("LB0111") . '</td>
                                            <td></td>
                                            <td align="right">' . $total_res . '</td>
                                        </tr>';
//                                       //offer completion
    $offer_completionDate = "";
    if ($from_date !== "") {
        $offer_completionDate = "AND DATE(ca.course_assigned_ts)>='$from_date' AND DATE(ca.course_assigned_ts)<='$to_date'";
    } else {
        $offer_completionDate = "";
    }
    $stmt_completion = $offering->get_offer_CompletionCount($offer_completionDate, $offer_completion, $score1, $score2, $score3, $score4, $offer_score1, $offer_score2, $offer_score3, $offer_score4);
    while ($row_cmp = $stmt_completion->fetch(PDO::FETCH_ASSOC)) {
        $offer_completion_points_value = $row_cmp['offer_completion_points'];
        $offer_score1_points_value = $row_cmp['offer_score1_points'];
        $offer_score2_points_value = $row_cmp['offer_score2_points'];
        $offer_score3_points_value = $row_cmp['offer_score3_points'];
        $offer_score4_points_value = $row_cmp['offer_score4_points'];
    }
    $offer_completion_points = "";
    $stmt_completion_points = $offering->get_offer_CompletionPointsCount($offer_completionDate, $offer_completion);
    while ($row_cmppt = $stmt_completion_points->fetch(PDO::FETCH_ASSOC)) {
        $offer_completion_points .= $row_cmppt['course_name'] . "(" . $row_cmppt['offer_completion_points'] . ")<br/>";
    }
    $total_points_pt += $offer_completion_points_value;
    $html .= '<tr nobr="true">';
    $html .= '<td>' . _("RP0124") . '</td>
                                            <td >' . $offer_completion_points . '</td>
                                            <td align="right">' . $offer_completion_points_value . '</td>
                                        </tr>';
    //above90
    $offer_score1_points = "";
    $score_value = " ca.score >= " . $score1 . " ";
    $stmt_completion_score1 = $offering->get_offer_score($offer_completionDate, $offer_score1, $score_value);
    while ($row_cmp_score1 = $stmt_completion_score1->fetch(PDO::FETCH_ASSOC)) {
        $offer_score1_points .= $row_cmp_score1['course_name'] . "(" . $row_cmp_score1['offer_score1_points'] . ")<br/>";
    }
    $total_points_pt += $offer_score1_points_value;
    $html .= '<tr nobr="true">';
    $html .= '<td>' . _("RP0125") . ' ' . $score1 . ' and above</td>
                                            <td>' . $offer_score1_points . '</td>
                                            <td align="right">' . $offer_score1_points_value . '</td>
                                        </tr>';
    //above80
    $offer_score2_points = "";
    $score_value = " ca.score >= " . $score2 . " AND ca.score<" . $score1 . " ";
    $stmt_completion_score2 = $offering->get_offer_score($offer_completionDate, $offer_score2, $score_value);
    while ($row_cmp_score2 = $stmt_completion_score2->fetch(PDO::FETCH_ASSOC)) {
        $offer_score2_points .= $row_cmp_score2['course_name'] . "(" . $row_cmp_score2['offer_score1_points'] . ")<br/>";
    }
    $total_points_pt += $offer_score2_points_value;
    $html .= '<tr nobr="true">';
    $html .= '<td>' . _("RP0125") . ' ' . $score2 . ' - ' . --$score1 . ' </td>
                                            <td>' . $offer_score2_points . '</td>
                                            <td align="right">' . $offer_score2_points_value . '</td>
                                        </tr>';
    //above70
    $offer_score3_points = "";
    $score_value = " ca.score >= " . $score3 . " AND ca.score<" . $score2 . " ";
    $stmt_completion_score3 = $offering->get_offer_score($offer_completionDate, $offer_score3, $score_value);
    while ($row_cmp_score3 = $stmt_completion_score3->fetch(PDO::FETCH_ASSOC)) {
        $offer_score3_points .= $row_cmp_score3['course_name'] . "(" . $row_cmp_score3['offer_score1_points'] . ")<br/>";
    }
    $total_points_pt += $offer_score3_points_value;
    $html .= '<tr nobr="true">';
    $html .= '<td>' . _("RP0125") . ' ' . $score3 . ' - ' . --$score2 . ' </td>
                                            <td>' . $offer_score3_points . '</td>
                                            <td align="right">' . $offer_score3_points_value . '</td>
                                        </tr>';
    //above70
    $offer_score4_points = "";
    $score_value = " ca.score >= " . $score4 . " AND ca.score<" . $score3 . " ";
    $stmt_completion_score4 = $offering->get_offer_score($offer_completionDate, $offer_score4, $score_value);
    while ($row_cmp_score4 = $stmt_completion_score4->fetch(PDO::FETCH_ASSOC)) {
        $offer_score4_points .= $row_cmp_score4['course_name'] . "(" . $row_cmp_score4['offer_score1_points'] . ")<br/>";
    }
    $total_points_pt += $offer_score4_points_value;
    $html .= '<tr nobr="true">';
    $html .= '<td>' . _("RP0125") . ' ' . $score4 . ' - ' . --$score3 . ' </td>
                                            <td>' . $offer_score4_points . '</td>
                                            <td align="right">' . $offer_score4_points_value . '</td>
                                        </tr>';
    //offer view
//                                        $total_viewTime = $offering->get_offer_viewpt($offer_completionDate,$offer_view);
    $offer_totalTime = 0.0;
    $offer_view_points = "";
    $stmt_view = $offering->get_offer_view($offer_completionDate, $offer_view);
    while ($row_view = $stmt_view->fetch(PDO::FETCH_ASSOC)) {
        $offer_view_points .= $row_view['course_name'] . "(" . $row_view['total_time'] . ")<br/>";
        $offer_totalTime += $row_view['total_time'];
    }
    $total_points_pt += $offer_totalTime;
    $html .= '<tr nobr="true">';
    $html .= '<td>' . _("RP0126") . '</td>
                                            <td>' . $offer_view_points . '</td>
                                            <td align="right">' . $offer_totalTime . '</td>
                                        </tr>';
    //offer rating
    $offer_totalrating = 0.0;
    $offer_rating_points = "";
    $stmt_rat = $offering->get_offer_rating($offer_completionDate, $offer_ratings);
    while ($row_rat = $stmt_rat->fetch(PDO::FETCH_ASSOC)) {
        $offer_rating_points .= $row_rat['course_name'] . "(" . $row_rat['rating_value'] . ")<br/>";
        $offer_totalrating += $row_rat['rating_value'];
    }
    $total_points_pt += $offer_totalrating;
    $html .= '<tr nobr="true">';
    $html .= '<td>' . _("RP0127") . '</td>
                                            <td>' . $offer_rating_points . '</td>
                                            <td align="right">' . $offer_totalrating . '</td>
                                        </tr>';
    $html .= '<tr nobr="true">';
    $html .= '<td colspan="2" align="right"><b>' . _('RP0123') . '</b></td> <td align="right"><b> ' . round($total_points_pt, 0) . ' </b></td></tr>';
    $html .= "</table>";
    //if points zero does not download
    if ($total_points_pt != 0) {
        $pdf->writeHTML($html, true, false, false, false, '');
    }


// -----------------------------------------------------------------------------
//Close and output PDF document
    die($pdf->Output('SummaryReport_"' . $name . '"_"' . $date . '".pdf', 'D'));

//============================================================+
// END OF FILE
//============================================================+
}
?>


