<?php

//============================================================+
// File name   : example_051.php
// Begin       : 2009-04-16
// Last Update : 2013-05-14
//
// Description : Example 051 for TCPDF class
//               Full page background
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Full page background
 * @author Nicola Asuni
 * @since 2009-04-16
 */
// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');
require_once('../../config.php');

$format_id = $_GET['fid'];

$cname = "";
$clogo = "";
//$sql = "SELECT * FROM company_profile";
//$result = mysqli_query($link, $sql);
//if ($row = mysqli_fetch_array($result)) {
//    $cname = $row['name'];
//    $clogo = $row['logo_path'];
//}
$sql1 = "select cf.*,cp.name,cp.logo_path from certificate_format as cf,company as cp where cp.company_id=cf.company_id AND cf.format_id=" . $format_id;
$result1 = mysqli_query($link, $sql1);
if ($row1 = mysqli_fetch_array($result1)) {
    $text1 = $row1['text1'];
    $text2 = $row1['text2'];
    $text3 = $row1['text3'];
    $text4 = $row1['text4'];
    $text5 = $row1['text5'];
    $text6 = $row1['text6'];
    
    $cname = $row1['comp_name'];
    //echo "cname:",$cname;

    if($cname == 'Y')
    {
        $cname = $row1['name'];
    }
    $clogo = $row1['logo_path'];

    $text1_color = $row1['text1_color'];
    $record1 = explode(",", $text1_color);
    $text2_color = $row1['text2_color'];
    $record2 = explode(",", $text2_color);
    $text3_color = $row1['text3_color'];
    $record3 = explode(",", $text3_color);
    $text4_color = $row1['text4_color'];
    $record4 = explode(",", $text4_color);
    $text5_color = $row1['text5_color'];
    $record5 = explode(",", $text5_color);
    $text6_color = $row1['text6_color'];
    $record9 = explode(",", $text6_color);
    $comp_name_color = $row1['comp_name_color'];
    $record10 = explode(",", $comp_name_color);
    $name_color = $row1['name_color'];
    $record6 = explode(",", $name_color);
    $course_color = $row1['course_color'];
    $record7 = explode(",", $course_color);
    $grade_color = $row1['grade_color'];
    $record8 = explode(",", $grade_color);

    $text1_size = $row1['text1_size'];
    $text2_size = $row1['text2_size'];
    $text3_size = $row1['text3_size'];
    $text4_size = $row1['text4_size'];
    $text5_size = $row1['text5_size'];
    $text6_size = $row1['text6_size'];
    $comp_name_size = $row1['comp_name_size'];
    $name_size = $row1['name_size'];
    $course_size = $row1['course_size'];
    $grade_size = $row1['grade_size'];

    $comp_name_path = $row1['comp_name_path'];
    $sign_path = $row1['sign_path'];

// Extend the TCPDF class to create custom Header and Footer
    class MYPDF extends TCPDF {

        //Page header
        public function Header() {
            // get the current page break margin
            $bMargin = $this->getBreakMargin();
            // get current auto-page-break mode
            $auto_page_break = $this->AutoPageBreak;
            // disable auto-page-break
            $this->SetAutoPageBreak(false, 0);
            // set bacground image
            $this->Image(FORMAT_TEMPLATE, 0, 0, 297, 210, '', '', '', false, 300, '', false, false, 0);
            // restore auto-page-break status
            $this->SetAutoPageBreak($auto_page_break, $bMargin);
            // set the starting point for the page content
            $this->setPageMark();
        }

    }

// create new PDF document
    $pdf = new MYPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetTitle('Certificate');
    $pdf->SetSubject('Certificate');
    $pdf->SetKeywords('Certificate');

// set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

// set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
    $pdf->SetMargins(0, 0, 0);
    $pdf->SetHeaderMargin(0);
    $pdf->SetFooterMargin(0);

// remove default footer
    $pdf->setPrintFooter(false);

// set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
    if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
        require_once(dirname(__FILE__) . '/lang/eng.php');
        $pdf->setLanguageArray($l);
    }

// add a page
    $pdf->AddPage();
    $style3 = array('width' => 0.2, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0));
// Print a text
    $pdf->Ln(20);
    if ($comp_name_path != "") {
        $pdf->Image(COMP_NAME_PATH . $comp_name_path, '', '', '', '', '', '', '', true, 300, 'C');
    } else {
        $pdf->SetFont('freesans', 'B', $comp_name_size);
        $pdf->SetTextColor($record10[0], $record10[1], $record10[2]);
        $pdf->MultiCell(0, 0, $cname, 0, 'C', 0, 0, '', '', true, 0);
    }
    $pdf->Ln(22);
    $pdf->SetFont('freesans', 'B', $text1_size);
    $pdf->SetTextColor($record1[0], $record1[1], $record1[2]);
    $pdf->MultiCell(0, 0, $text1, 0, 'C', 0, 0, '', '', true, 0);
    $pdf->Ln(22);
    $pdf->SetFont('freesans', 'B', $text2_size);
    $pdf->SetTextColor($record2[0], $record2[1], $record2[2]);
    $pdf->MultiCell(0, 0, $text2, 0, 'C', 0, 0, '', '', true, 0);
    $pdf->Ln(12);
    $pdf->Image(FORMAT_BADGE, 40, 76, '', '', '', '', '', true, 300, '');
    $pdf->SetFont('freesans', 'B', $name_size);
    $pdf->SetTextColor($record6[0], $record6[1], $record6[2]);
    $pdf->MultiCell(0, 0, '[First name] [Last name]', 0, 'C', 0, 0, '', '', true, 0);
    $pdf->Ln(20);
    $pdf->SetFont('freesans', 'B', $text3_size);
    $pdf->SetTextColor($record3[0], $record3[1], $record3[2]);
    $pdf->MultiCell(0, 0, $row1['text3'], 0, 'C', 0, 0, '', '', true, 0);
    $pdf->Ln(11);
    $pdf->SetFont('freesans', 'B', 20);
    $pdf->SetTextColor($record7[0], $record7[1], $record7[2]);
    $pdf->MultiCell(0, 0, '[Course]', 0, 'C', 0, 0, '', '', true, 0);
    $pdf->Ln(14);
    $pdf->SetFont('freesans', 'B', $text4_size);
    $pdf->SetTextColor($record4[0], $record4[1], $record4[2]);
    $pdf->MultiCell(0, 0, $row1['text4'], 0, 'C', 0, 0, '', '', true, 0);
    $pdf->Ln(10);
    $pdf->SetFont('freesans', 'BU', $grade_size);
    $pdf->SetTextColor($record8[0], $record8[1], $record8[2]);
    $pdf->MultiCell(0, 0, '[Grade]', 0, 'C', 0, 0, '', '', true, 0);
    $pdf->Ln(15);
    $pdf->setCellPaddings($left = '50', $top = '', $right = '46', $bottom = '');
    if ($text5 != "") {
        $pdf->SetFont('freesans', 'B', $text5_size);
        $pdf->SetTextColor($record5[0], $record5[1], $record5[2]);
        $pdf->Cell(0, 0, '[Date]', 0, false, 'L', 0, '', 0, false, 'T', 0);
    }
    if ($clogo != "") {
        $pdf->Image(COMPANY_PROFILE . $clogo, '', '', '', '', '', '', '', true, 300, 'C');
    }
    if ($sign_path != "") {
        $pdf->Image(SIGNATORY_PATH . $sign_path, 220, 120, '', '', '', '', '', true, 300, FALSE);
    }
    if ($text5 != "") {
        $pdf->Line(30, 156, 100, 156);
    }
    if ($text6 != "") {
        $pdf->Line(200, 156, 270, 156);
    }
    $pdf->Ln(1);
    $pdf->setCellPaddings($left = '45', $top = '', $right = '30', $bottom = '');
    if ($text5 != "") {
        $pdf->SetFont('freesans', 'B', $text5_size);
        $pdf->SetTextColor($record5[0], $record5[1], $record5[2]);
        $pdf->Cell(0, 30, $text5, 0, false, 'L', 0, '', 0, false, 'T', 'M');
    }
    if ($text6 != "") {
        $pdf->SetFont('freesans', 'B', $text6_size);
        $pdf->SetTextColor($record9[0], $record9[1], $record9[2]);
        $pdf->Cell(0, 30, $text6, 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }


// --- example with background set on page ---
// remove default header
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

// ---------------------------------------------------------
//Close and output PDF document
    $pdf->Output('certificate_format.pdf', 'I');
}